/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

import java.util.Date;
import java.util.Random;

public final class HGBaseVerify {
    private static Random random = new Random(new Date().getTime());
    private static final int KEY_LENGTH = 7;

    private HGBaseVerify() {
    }

    public static boolean verifyNumber(int number, String key) {
        return HGBaseVerify.verifyNumber(number, key, null);
    }

    public static boolean verifyNumber(int number, String key, String applicationKey) {
        if (key == null || key.length() != 7) {
            return false;
        }
        if (applicationKey != null && applicationKey.length() == 7) {
            key = HGBaseVerify.doApplicationKeyXor(key, applicationKey, false);
        }
        String offset = String.valueOf(key.charAt(key.length() - 1));
        int xor = key.charAt(0) - 65;
        String newKey = String.valueOf(HGBaseVerify.getLetter(xor, 'A')) + HGBaseVerify.generateVerification(number, offset, xor) + offset;
        return key.equals(newKey);
    }

    public static String generateVerification(int number) {
        String offset = HGBaseVerify.createOffset(number);
        int xor = HGBaseVerify.createXorValue();
        String key = HGBaseVerify.generateVerification(number, offset, xor);
        return String.valueOf(HGBaseVerify.getLetter(xor, 'A')) + key + offset;
    }

    public static String generateVerification(int number, String applicationKey) {
        String key = HGBaseVerify.generateVerification(number);
        if (applicationKey != null && applicationKey.length() == 7) {
            key = HGBaseVerify.doApplicationKeyXor(key, applicationKey, true);
        }
        return key;
    }

    private static String doApplicationKeyXor(String key, String applicationKey, boolean add) {
        if (key.length() == applicationKey.length()) {
            StringBuffer newKey = new StringBuffer("");
            int i = 0;
            while (i < key.length()) {
                int k = key.charAt(i) - 65;
                int a = applicationKey.charAt(i) - 65;
                int sum = add ? k + a : 26 + k - a;
                newKey.append(HGBaseVerify.getLetter(sum, 'A'));
                ++i;
            }
            return newKey.toString();
        }
        return key;
    }

    private static int createXorValue() {
        return random.nextInt(26);
    }

    private static String getLetter(int digit, char offset) {
        char c = (char)(offset + digit % 26);
        if (c > 'Z') {
            c = (char)(65 + c - 90);
        }
        return String.valueOf(c);
    }

    private static String getLetter(int digit, String offset) {
        return HGBaseVerify.getLetter(digit, offset.charAt(0));
    }

    private static String createOffset(int number) {
        int offset = random.nextInt(13) * 2;
        if (number < 0) {
            ++offset;
        }
        return HGBaseVerify.getLetter(offset, 'A');
    }

    private static String generateVerification(int number, String offset, int xor) {
        int[] keyPos = new int[5];
        int n = HGBaseVerify.calculateDigits(number);
        int sumOut = HGBaseVerify.getOuterSum(number);
        keyPos[0] = sumOut < 10 ? sumOut * 2 : sumOut / 2;
        int right = HGBaseVerify.getSubInteger(number, n / 2, (n + 1) / 2);
        keyPos[1] = HGBaseVerify.getMultiplicated(right, n);
        keyPos[2] = number % 17;
        int left = HGBaseVerify.getSubInteger(number, 0, n / 2);
        keyPos[3] = HGBaseVerify.getMultiplicated(left, n);
        keyPos[4] = number < 100 ? sumOut : HGBaseVerify.getInnerSum(number, n);
        StringBuffer result = new StringBuffer("");
        int i = 0;
        while (i < keyPos.length) {
            result.append(HGBaseVerify.getLetter(keyPos[i] ^ xor, offset));
            ++i;
        }
        return result.toString();
    }

    private static int getInnerSum(int number, int n) {
        int sum = 0;
        int num = number / 10;
        int i = 0;
        while (i < n - 2) {
            int digit = num % 10;
            num /= 10;
            sum += digit;
            ++i;
        }
        return sum;
    }

    private static int getMultiplicated(int number, int n) {
        int result = 1;
        int num = number;
        int i = 0;
        while (i < n) {
            int digit = num % 10;
            num /= 10;
            result *= digit + 1;
            ++i;
        }
        return result;
    }

    private static int getOuterSum(int number) {
        if (number < 10) {
            return number;
        }
        int i1 = number % 10;
        int i2 = number / (int)Math.pow(10.0, HGBaseVerify.calculateDigits(number) - 1);
        return i1 + i2;
    }

    private static int calculateDigits(int number) {
        int digits = 1;
        int num = number;
        while (num >= 10) {
            ++digits;
            num /= 10;
        }
        return digits;
    }

    private static int getSubInteger(int number, int start, int digits) {
        int n = HGBaseVerify.calculateDigits(number);
        if (start < 0 || start >= n) {
            return number;
        }
        int help = number % (int)Math.pow(10.0, n - start);
        int len = digits;
        if (len > n - start) {
            len = n - start;
        }
        int newNumber = 0;
        int factor = (int)Math.pow(10.0, len - 1);
        int factor2 = (int)Math.pow(10.0, n - start);
        int i = 0;
        while (i < len) {
            newNumber += (int)((double)help * 1.0 / (double)factor2) * factor;
            help %= factor2;
            factor /= 10;
            factor2 /= 10;
            ++i;
        }
        return newNumber;
    }
}

