/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

public class IntCollection
implements Cloneable {
    int[] values;

    public IntCollection(int[] values) {
        this.values = (int[])values.clone();
    }

    public int get(int index) {
        if (index >= 0 && index < this.values.length) {
            return this.values[index];
        }
        return -2147483631;
    }

    public void set(int index, int value) {
        if (index >= 0 && index < this.values.length) {
            this.values[index] = value;
        }
    }

    public int size() {
        return this.values.length;
    }

    public int[] values() {
        return (int[])this.values.clone();
    }

    public boolean contains(int value) {
        int[] nArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            int existing = nArray[n2];
            if (existing == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean contains(int[] values, int value) {
        return new IntCollection(values).contains(value);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new IntCollection(this.values);
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        int size = this.size();
        int i = 0;
        while (i < size) {
            if (i > 0) {
                text.append(" / ");
            }
            text.append(String.valueOf(i));
            text.append("=");
            text.append(this.get(i));
            ++i;
        }
        return text.toString();
    }

    public boolean equals(Object o2) {
        if (o2 instanceof IntCollection) {
            IntCollection ic2 = (IntCollection)o2;
            int size = this.size();
            if (size != ic2.size()) {
                return false;
            }
            int i = 0;
            while (i < size) {
                if (this.get(i) != ic2.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

