/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib.xml;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ChildNodeIterator {
    private NodeList list;
    private int index;
    private Object userObject;

    public ChildNodeIterator(Node parent, Object userObject) {
        this(parent, null, userObject);
    }

    public ChildNodeIterator(Node parent, String name, Object userObject) {
        if (parent != null && (name == null || parent.getNodeName().equals(name))) {
            this.list = parent.getChildNodes();
            this.index = 0;
            this.userObject = userObject;
        }
    }

    public abstract void performNode(Node var1, int var2, Object var3);

    private Node getCurrentNode() {
        if (this.list != null && this.list.getLength() > this.getCurrentPosition()) {
            return this.list.item(this.index);
        }
        return null;
    }

    private int getCurrentPosition() {
        return this.index;
    }

    private void next() {
        ++this.index;
    }

    private Object getUserObject() {
        return this.userObject;
    }

    public static void run(ChildNodeIterator nodes) {
        Node node;
        while ((node = nodes.getCurrentNode()) != null && !nodes.isInterrupted()) {
            nodes.performNode(node, nodes.getCurrentPosition(), nodes.getUserObject());
            nodes.next();
        }
    }

    protected boolean isInterrupted() {
        return false;
    }
}

