/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib.xml;

import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseTools;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class HGBaseXMLTools {
    private HGBaseXMLTools() {
    }

    public static Element readXML(String file) {
        InputStream in = HGBaseFileTools.openApplicationFileStream(file, new HGBaseXMLTools());
        if (in != null) {
            try {
                DocumentBuilder build = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = build.parse(in);
                Element element = doc.getDocumentElement();
                return element;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                HGBaseLog.logError("Error when reading xml file '" + file + "': " + e.getMessage());
            }
            finally {
                HGBaseFileTools.closeStream(in);
            }
        }
        return null;
    }

    public static Element readXML(InputStream stream) {
        try {
            DocumentBuilder build = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = build.parse(stream);
            if (doc != null) {
                return doc.getDocumentElement();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            HGBaseLog.logWarn(e.getMessage());
        }
        return null;
    }

    public static boolean writeXML(Document doc, String file) {
        if (doc != null && file != null) {
            try {
                String fileToWrite = HGBaseXMLTools.prepareFileToWrite(file);
                String content = HGBaseXMLTools.transformDocument(doc, true);
                FileOutputStream fout = new FileOutputStream(fileToWrite);
                fout.write(content.getBytes(HGBaseXMLTools.getEncoding()));
                fout.close();
                return true;
            }
            catch (IOException | TransformerException | TransformerFactoryConfigurationError throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static String prepareFileToWrite(String fileName) {
        try {
            File f = null;
            f = fileName.startsWith("/") || fileName.startsWith("\\") || fileName.contains(":") ? new File(fileName).getAbsoluteFile() : new File(HGBaseFileTools.getCurrentDir(), fileName);
            File parentDir = f.getParentFile();
            if (!parentDir.isDirectory() && !f.getParentFile().mkdirs()) {
                HGBaseLog.logError("Could not create directory: " + parentDir);
            }
            return f.getAbsolutePath();
        }
        catch (SecurityException securityException) {
            return fileName;
        }
    }

    public static String getAttributeValue(Node node, String attribute) {
        Node name;
        if (node != null && node.getAttributes() != null && (name = node.getAttributes().getNamedItem(attribute)) != null) {
            return name.getNodeValue();
        }
        return "";
    }

    public static int getAttributeIntValue(Node node, String attribute) {
        return HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, attribute));
    }

    public static int getAttributeIntValue(Node node, String attribute, int defaultValue) {
        return HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, attribute), defaultValue);
    }

    public static long getAttributeLongValue(Node node, String attribute) {
        return HGBaseTools.toLong(HGBaseXMLTools.getAttributeValue(node, attribute));
    }

    public static long getAttributeLongValue(Node node, String attribute, long defaultValue) {
        return HGBaseTools.toLong(HGBaseXMLTools.getAttributeValue(node, attribute), defaultValue);
    }

    public static boolean getAttributeBooleanValue(Node node, String attribute) {
        return HGBaseTools.toBoolean(HGBaseXMLTools.getAttributeValue(node, attribute));
    }

    public static Color getAttributeRGBColorValue(Node node, String attribute) {
        String value = HGBaseXMLTools.getAttributeValue(node, attribute);
        try {
            int r = Integer.parseInt(value.substring(0, 2), 16);
            int g = Integer.parseInt(value.substring(2, 4), 16);
            int b = Integer.parseInt(value.substring(4, 6), 16);
            return new Color(r, g, b);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    public static Color getAttributeRGBColorValue(Node node, String attribute, Color defaultValue) {
        Color color = HGBaseXMLTools.getAttributeRGBColorValue(node, attribute);
        if (color == null) {
            color = defaultValue;
        }
        return color;
    }

    public static String getNodeValue(Node node) {
        Node text = node.getFirstChild();
        if (text != null) {
            return text.getNodeValue();
        }
        return "";
    }

    public static void setNodeValue(Element node, String value) {
        node.setTextContent(value);
    }

    public static String transformDocument(Document newDoc, boolean indent) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.setOutputProperty("indent", indent ? "yes" : "no");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", HGBaseXMLTools.getEncoding());
        transformer.transform(new DOMSource(newDoc), new StreamResult(output));
        try {
            return output.toString(HGBaseXMLTools.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            HGBaseLog.logWarn("The character set '" + HGBaseXMLTools.getEncoding() + "' is not supported!");
            return output.toString();
        }
    }

    public static Document createDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (FactoryConfigurationError | ParserConfigurationException throwable) {
            return null;
        }
    }

    public static Element createElement(Document doc, Element parent, String name) {
        Element node = doc.createElement(name);
        if (parent == null) {
            doc.appendChild(node);
        } else {
            parent.appendChild(node);
        }
        return node;
    }

    public static String getEncoding() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") >= 0) {
            return "ISO-8859-1";
        }
        if (os.indexOf("linux") >= 0) {
            return "UTF-8";
        }
        return System.getProperty("file.encoding");
    }
}

