/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import hgb.lib.internal.IntBooleanStringMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import tjger.game.completed.GameConfigFileReader;
import tjger.gui.completed.Arrangement;
import tjger.gui.completed.Background;
import tjger.gui.completed.Board;
import tjger.gui.completed.CardSet;
import tjger.gui.completed.Cover;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.PieceSet;
import tjger.lib.ArrayUtil;

public final class GameConfig {
    public static final int STANDARD_ZOOM = 100;
    public static final int ORDERBY_NONE = 0;
    public static final int ORDERBY_COLOR = 1;
    public static final int ORDERBY_VALUE = 2;
    public static final int PLAYERS_LEFTTORIGHT = 0;
    public static final int PLAYERS_CLOCKWISE = 1;
    public static final int PLAYERS_COUNTERCLOCKWISE = 2;
    public static final String CONFIG_SHADOW = "shadow";
    public static final String CONFIG_REFLECTION = "reflection";
    static final String EMPTY_STRING = "";
    static final int WELCOME_TIMEOUT_DEFAULT = 1700;
    private static final String CONFIG_STANDARD_WIDTH = "standard_width";
    private static final String CONFIG_STANDARD_HEIGHT = "standard_height";
    private static final String CONFIG_PLAYER_HEIGHT = "playerFieldHeight";
    private static final String GAMESPEED_CONFIG = "gamespeed";
    private static final GameConfig INSTANCE = new GameConfig();
    Background[] backgrounds;
    Board[] boards;
    Cover[] covers;
    Map<String, List<CardSet>> cardSetsMap;
    PieceSet[] pieceSets;
    Arrangement[] arrangements;
    Map<String, Color> colors;
    Map<String, List<Part>> partMap;
    Map<String, List<PartSet>> partSetMap;
    Map<String, String> extendPartMap;
    Map<String, String> extendPartSetMap;
    Map<String, String> extendCvpMap;
    boolean completeArrangement;
    int minZoom;
    int maxZoom;
    Map<String, String> extensionMap;
    Map<String, String> pathMap;
    boolean networkPossible;
    int networkPort;
    int minPlayers;
    int maxPlayers;
    int fieldWidth;
    int fieldHeight;
    int fieldHorizontalAlignment;
    int fieldVerticalAlignment;
    ImageIcon welcomeImage;
    private ImageIcon tjgerImage;
    int welcomeImageTimeout;
    boolean hasErrors;
    boolean oneHumanPlayer;
    boolean withoutHumanPlayer;
    String playerImageName;
    String playerPieceColor;
    boolean helpHidden;
    boolean rememberScores;
    boolean rememberGames;
    int highScoreLength;
    boolean onlyFirstHighScore;
    boolean isLowerScoreBetter;
    int statisticsScrollWhen;
    boolean changedOnNewGame;
    boolean changedOnNewRound;
    boolean changedOnNewTurn;
    boolean changedAfterMove;
    boolean dialogAfterTurn;
    boolean dialogAfterRound;
    boolean dialogAfterGame;
    boolean interruptAfterRound;
    IntBooleanStringMap setOrderBy;
    boolean localGameStateTurn;
    boolean localGameStateRound;
    boolean localGameStateGame;
    LinkedHashMap<String, String> hintsMap;
    int delayRound;
    int delayTurn;
    int delayMove;
    int delayPlayer;
    double gameSpeed;
    int playersOrder;
    boolean recordOnNewGame;
    boolean recordOnNewRound;
    boolean recordOnNewTurn;
    String gameStateXmlRoot;

    private GameConfig() {
        GameConfigFileReader.read(this);
    }

    public static GameConfig getInstance() {
        return INSTANCE;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean isOneHumanPlayer() {
        return this.oneHumanPlayer;
    }

    public boolean isWithoutHumanPlayer() {
        return this.withoutHumanPlayer;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getActiveZoom() {
        int zoom = HGBaseConfig.getInt("game.zoom");
        if (zoom != -2147483631 && zoom >= this.getMinZoom() && zoom <= this.getMaxZoom()) {
            return zoom;
        }
        return this.getStandardZoom();
    }

    public int getStandardZoom() {
        int zoom = 100;
        if (zoom >= this.getMinZoom() && zoom <= this.getMaxZoom()) {
            return zoom;
        }
        return (this.getMinZoom() + this.getMaxZoom()) / 2;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getPlayersOrder() {
        return this.playersOrder;
    }

    public int getHighScoreLength() {
        return this.highScoreLength;
    }

    public boolean isOnlyFirstHighScore() {
        return this.onlyFirstHighScore;
    }

    public boolean isLowerScoreBetter() {
        return this.isLowerScoreBetter;
    }

    public int getStatisticsScrollWhen() {
        return this.statisticsScrollWhen;
    }

    public boolean isRememberGames() {
        return this.rememberGames;
    }

    public void setRememberGames(boolean remember) {
        this.rememberGames = remember;
    }

    public boolean isRememberScores() {
        return this.rememberScores;
    }

    public void setRememberScores(boolean remember) {
        this.rememberScores = remember;
    }

    public boolean isNetworkPossible() {
        return this.networkPossible;
    }

    public int getNetworkDefaultPort() {
        return this.networkPort;
    }

    public int getNetworkPort() {
        int port = HGBaseConfig.getInt("game.networkport");
        if (port != -2147483631) {
            return port;
        }
        return this.networkPort;
    }

    public boolean isLocalGameStateGame() {
        return this.localGameStateGame;
    }

    public void setLocalGameStateGame(boolean local) {
        this.localGameStateGame = local;
    }

    public boolean isLocalGameStateRound() {
        return this.localGameStateRound;
    }

    public void setLocalGameStateRound(boolean local) {
        this.localGameStateRound = local;
    }

    public boolean isLocalGameStateTurn() {
        return this.localGameStateTurn;
    }

    public void setLocalGameStateTurn(boolean local) {
        this.localGameStateTurn = local;
    }

    public ImageIcon getTjgerImage() {
        return this.tjgerImage;
    }

    public ImageIcon getWelcomeImage() {
        return this.welcomeImage;
    }

    public int getWelcomeImageTimeOut() {
        return this.welcomeImageTimeout;
    }

    public Arrangement[] getArrangements() {
        return HGBaseTools.clone(this.arrangements);
    }

    public Background[] getBackgrounds() {
        return HGBaseTools.clone(this.backgrounds);
    }

    public Board[] getBoards() {
        return HGBaseTools.clone(this.boards);
    }

    public Cover[] getCovers() {
        return HGBaseTools.clone(this.covers);
    }

    public CardSet[] getCardSets() {
        return this.getCardSets("game.cardset");
    }

    public CardSet[] getCardSets(String type) {
        return this.getCardSetsFromMap(this.cardSetsMap, type).toArray(new CardSet[0]);
    }

    public String[] getCardSetTypes() {
        return this.cardSetsMap.keySet().toArray(new String[this.cardSetsMap.size()]);
    }

    public PieceSet[] getPieceSets() {
        return HGBaseTools.clone(this.pieceSets);
    }

    public Arrangement getArrangement(String name) {
        Part part = this.getPartByName(this.getArrangements(), name);
        if (part != null) {
            return (Arrangement)part;
        }
        return null;
    }

    public Background getBackground(String name) {
        Part part = this.getPartByName(this.getBackgrounds(), name);
        if (part != null) {
            return (Background)part;
        }
        return null;
    }

    public Board getBoard(String name) {
        Part part = this.getPartByName(this.getBoards(), name);
        if (part != null) {
            return (Board)part;
        }
        return null;
    }

    public Cover getCover(String name) {
        Part part = this.getPartByName(this.getCovers(), name);
        if (part != null) {
            return (Cover)part;
        }
        return null;
    }

    public CardSet getCardSet(String name) {
        return this.getCardSet("game.cardset", name);
    }

    public CardSet getCardSet(String type, String name) {
        Part part = this.getPartByName(this.getCardSets(type), name);
        return (CardSet)part;
    }

    public PieceSet getPieceSet(String name) {
        Part part = this.getPartByName(this.getPieceSets(), name);
        return (PieceSet)part;
    }

    public Arrangement getActiveArrangement() {
        String name = this.getActivePartName(this.getArrangements(), "game.arrangement");
        if (HGBaseConfig.existsKey("game.arrangement") && !name.equals(HGBaseConfig.get("game.arrangement"))) {
            return null;
        }
        return this.getArrangement(name);
    }

    public Background getActiveBackground() {
        String name = this.getActivePartName(this.getBackgrounds(), "game.background");
        return this.getBackground(name);
    }

    public Board getActiveBoard() {
        String name = this.getActivePartName(this.getBoards(), "game.board");
        return this.getBoard(name);
    }

    public Cover getActiveCover() {
        String name = this.getActivePartName(this.getCovers(), "game.cover");
        return this.getCover(name);
    }

    public CardSet getActiveCardSet() {
        return this.getActiveCardSet("game.cardset");
    }

    public CardSet getActiveCardSet(String type) {
        String name = this.getActivePartName(this.getCardSets(type), type);
        return this.getCardSet(type, name);
    }

    public PieceSet getActivePieceSet() {
        String name = this.getActivePartName(this.getPieceSets(), "game.pieceset");
        return this.getPieceSet(name);
    }

    public Part[] getParts(String type) {
        return this.getPartsFromMap(this.partMap, type).toArray(new Part[0]);
    }

    public Part getPart(String type, String name) {
        return this.getPartByName(this.getParts(type), name);
    }

    public PartSet[] getPartSets(String type) {
        return this.getPartSetsFromMap(this.partSetMap, type).toArray(new PartSet[0]);
    }

    public PartSet getPartSet(String type, String name) {
        return (PartSet)this.getPartByName(this.getPartSets(type), name);
    }

    public String[] getPartTypes() {
        return this.partMap.keySet().toArray(new String[0]);
    }

    public String[] getPartSetTypes() {
        return this.partSetMap.keySet().toArray(new String[0]);
    }

    public Part getActivePart(String type) {
        String name = this.getActivePartName(this.getParts(type), type);
        return this.getPart(type, name);
    }

    public Part getActivePartFromSet(String partSetType, String partColor, int sequence) {
        PartSet ps = this.getActivePartSet(partSetType);
        return ps == null ? null : ps.getPart(partColor, sequence);
    }

    public PartSet getActivePartSet(String type) {
        String name = this.getActivePartName(this.getPartSets(type), type);
        return this.getPartSet(type, name);
    }

    public String[] getColorTypes() {
        return this.colors.keySet().toArray(new String[this.colors.size()]);
    }

    public Color getActiveColor(String colorType) {
        Color c = HGBaseConfig.getColor(colorType);
        return c == null ? this.getDefaultColor(colorType) : c;
    }

    public Color getDefaultColor(String colorType) {
        return this.colors.get(colorType);
    }

    public void setFieldWidth(int fieldWidth) {
        this.fieldWidth = fieldWidth;
    }

    public void setFieldHeight(int fieldHeight) {
        this.fieldHeight = fieldHeight;
    }

    public int getFieldWidth() {
        return this.fieldWidth > 0 ? this.fieldWidth : this.getFieldWidth(this.getActiveBoard(), this.getActiveBackground());
    }

    public int getFieldWidth(Board board, Background back) {
        int wBack;
        int wBoard;
        int n = wBoard = board == null ? 0 : (int)((double)(board.getImage().getIconWidth() * board.getZoom()) / 100.0) + 2 * board.getXPos();
        if (wBoard == 1) {
            wBoard = 0;
        }
        int n2 = wBack = back == null || back.getImage() == null || back.isRepeatMode() ? 0 : (int)((double)(back.getImage().getIconWidth() * back.getZoom()) / 100.0);
        if (wBoard > wBack) {
            return wBoard;
        }
        if (wBack > wBoard) {
            return wBack;
        }
        if (wBack > this.fieldWidth) {
            return wBack;
        }
        if (this.fieldWidth > 0) {
            return this.fieldWidth;
        }
        int s = HGBaseSettings.getInt(CONFIG_STANDARD_WIDTH);
        if (s > 0) {
            return s;
        }
        return 0;
    }

    public int getFieldHeight() {
        return this.fieldHeight > 0 ? this.fieldHeight : this.getFieldHeight(this.getActiveBoard(), this.getActiveBackground());
    }

    public int getFieldHeight(Board board, Background back) {
        int hBack;
        int hBoard;
        int n = hBoard = board == null ? 0 : (int)((double)(board.getImage().getIconHeight() * board.getZoom()) / 100.0) + 2 * board.getYPos();
        if (hBoard == 1) {
            hBoard = 0;
        }
        int n2 = hBack = back == null || back.getImage() == null || back.isRepeatMode() ? 0 : (int)((double)(back.getImage().getIconHeight() * back.getZoom()) / 100.0);
        if (hBoard > hBack) {
            return hBoard;
        }
        if (hBack > hBoard) {
            return hBack;
        }
        if (hBack > this.fieldHeight) {
            return hBack;
        }
        if (this.fieldHeight > 0) {
            return this.fieldHeight;
        }
        int s = HGBaseSettings.getInt(CONFIG_STANDARD_HEIGHT);
        return Math.max(s, 0);
    }

    public int getFieldHorizontalAlignment() {
        return this.fieldHorizontalAlignment;
    }

    public int getFieldVerticalAlignment() {
        return this.fieldVerticalAlignment;
    }

    public int getPlayerFieldHeight() {
        int h = HGBaseSettings.getInt(CONFIG_PLAYER_HEIGHT);
        return h > 0 ? h : HGBaseGuiTools.getFieldHeight();
    }

    private List<Part> getPartsFromMap(Map<String, List<Part>> map, String type) {
        ArrayList list = map.get(type);
        return list != null ? list : new ArrayList();
    }

    private List<PartSet> getPartSetsFromMap(Map<String, List<PartSet>> map, String type) {
        ArrayList list = map.get(type);
        return list != null ? list : new ArrayList();
    }

    private List<CardSet> getCardSetsFromMap(Map<String, List<CardSet>> map, String type) {
        ArrayList list = map.get(type);
        return list != null ? list : new ArrayList();
    }

    private Part getPartByName(Part[] parts, String name) {
        int index = this.getIndexOfPart(parts, name);
        if (index >= 0 && parts.length > index) {
            return parts[index];
        }
        return null;
    }

    private String getActivePartName(Part[] parts, String configKey) {
        String name = HGBaseConfig.get(configKey);
        int index = this.getIndexOfPart(parts, name);
        if (index >= 0 && index < parts.length && !parts[index].isHidden()) {
            return parts[index].getName();
        }
        int i = 0;
        while (i < parts.length) {
            if (!parts[i].isHidden()) {
                return parts[i].getName();
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    private int getIndexOfPart(Part[] parts, String name) {
        Object[] itemNames = ArrayUtil.toPartNames(parts);
        return HGBaseTools.getIndexOf(itemNames, name);
    }

    void loadTjgerImage() {
        this.tjgerImage = this.welcomeImage == null ? HGBaseGuiTools.loadImage("/tjger/gui/gfx/tjger.jpg") : HGBaseGuiTools.loadImage("/tjger/gui/gfx/tjger2.jpg");
    }

    public String getImageExtension(String pieceType) {
        if (this.extensionMap.containsKey(pieceType)) {
            return this.extensionMap.get(pieceType).toString();
        }
        return EMPTY_STRING;
    }

    public String getImagePath(String pieceType) {
        if (this.pathMap.containsKey(pieceType)) {
            return this.pathMap.get(pieceType).toString();
        }
        return EMPTY_STRING;
    }

    public String getPlayerImageName() {
        return this.playerImageName;
    }

    public String getPlayerPieceColor() {
        return this.playerPieceColor;
    }

    public boolean isCompleteArrangement() {
        return this.completeArrangement;
    }

    public boolean isChangedAfterMove() {
        return this.changedAfterMove;
    }

    public void setChangedAfterMove(boolean changed) {
        this.changedAfterMove = changed;
    }

    public boolean isChangedOnNewGame() {
        return this.changedOnNewGame;
    }

    public void setChangedOnNewGame(boolean changed) {
        this.changedOnNewGame = changed;
    }

    public boolean isChangedOnNewRound() {
        return this.changedOnNewRound;
    }

    public void setChangedOnNewRound(boolean changed) {
        this.changedOnNewRound = changed;
    }

    public boolean isChangedOnNewTurn() {
        return this.changedOnNewTurn;
    }

    public void setChangedOnNewTurn(boolean changed) {
        this.changedOnNewTurn = changed;
    }

    public boolean showDialogAfterTurn() {
        return this.dialogAfterTurn;
    }

    public void setDialogAfterTurn(boolean show) {
        this.dialogAfterTurn = show;
    }

    public boolean showDialogAfterRound() {
        return this.dialogAfterRound;
    }

    public void setDialogAfterRound(boolean show) {
        this.dialogAfterRound = show;
    }

    public boolean showDialogAfterGame() {
        return this.dialogAfterGame;
    }

    public void setDialogAfterGame(boolean show) {
        this.dialogAfterGame = show;
    }

    public boolean isInterruptAfterRound() {
        return this.interruptAfterRound;
    }

    public void setInterruptAfterRound(boolean interrupt) {
        this.interruptAfterRound = interrupt;
    }

    public int getOrderby(String type) {
        return this.setOrderBy.getInt(type);
    }

    public String getHintsSetting(String setting) {
        return this.hintsMap.get(setting);
    }

    public int getDelayRound() {
        return this.delayRound;
    }

    public void setDelayRound(int delay) {
        this.delayRound = delay > 0 ? delay : 0;
    }

    public int getDelayRoundWithSpeedFactor() {
        return (int)((double)this.getDelayRound() * this.getGameSpeedFactor());
    }

    public int getDelayTurn() {
        return this.delayTurn;
    }

    public void setDelayTurn(int delay) {
        this.delayTurn = delay > 0 ? delay : 0;
    }

    public int getDelayTurnWithSpeedFactor() {
        return (int)((double)this.getDelayTurn() * this.getGameSpeedFactor());
    }

    public int getDelayMove() {
        return this.delayMove;
    }

    public void setDelayMove(int delay) {
        this.delayMove = delay > 0 ? delay : 0;
    }

    public int getDelayMoveWithSpeedFactor() {
        return (int)((double)this.getDelayMove() * this.getGameSpeedFactor());
    }

    public int getDelayPlayer() {
        return this.delayPlayer;
    }

    public void setDelayPlayer(int delay) {
        this.delayPlayer = delay > 0 ? delay : 0;
    }

    public int getDelayPlayerWithSpeedFactor() {
        return (int)((double)this.getDelayMove() * this.getGameSpeedFactor());
    }

    public void setGameSpeedFactor(double factor) {
        this.gameSpeed = factor;
    }

    public double getGameSpeedFactor() {
        return this.gameSpeed;
    }

    public boolean isRecordedOnNewGame() {
        return this.recordOnNewGame;
    }

    public boolean isRecordedOnNewRound() {
        return this.recordOnNewRound;
    }

    public boolean isRecordedOnNewTurn() {
        return this.recordOnNewTurn;
    }

    public String getGameStateXmlRoot() {
        return this.gameStateXmlRoot;
    }
}

