/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import hgb.lib.internal.ClassFactory;
import hgb.lib.internal.IntBooleanStringMap;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.completed.GameConfig;
import tjger.game.completed.PartSetContructor;
import tjger.game.completed.imagereader.AbstractImageEffectReader;
import tjger.game.completed.imagereader.ImageReflectionReader;
import tjger.game.completed.imagereader.ImageShodawReader;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.PlayingFieldFileOperator;
import tjger.game.completed.playingfield.PlayingFieldManager;
import tjger.game.internal.PlayerFactory;
import tjger.game.internal.RulesFactory;
import tjger.game.internal.StateFactory;
import tjger.gui.completed.Arrangement;
import tjger.gui.completed.Background;
import tjger.gui.completed.Board;
import tjger.gui.completed.Card;
import tjger.gui.completed.CardSet;
import tjger.gui.completed.ColorValuePart;
import tjger.gui.completed.Cover;
import tjger.gui.completed.ImageEffect;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.Piece;
import tjger.gui.completed.PieceSet;
import tjger.gui.internal.GameDialogFactory;
import tjger.gui.internal.TjgerWelcome;
import tjger.lib.ConstantValue;

class GameConfigFileReader {
    private static final String CONFIG_TJGER = "tjger";
    private static final String CONFIG_WELCOME = "welcome";
    private static final String CONFIG_WELCOME_TIMEOUT = "timeout";
    static final String CONFIG_NAME = "name";
    static final String CONFIG_IMAGE = "image";
    private static final String CONFIG_CLASS = "class";
    private static final String CONFIG_SETTINGS = "settings";
    private static final String CONFIG_RULES = "rules";
    private static final String CONFIG_HINTS = "hints";
    private static final String CONFIG_NETWORK = "network";
    private static final String CONFIG_PORT = "port";
    private static final String CONFIG_LOCAL = "local";
    private static final String CONFIG_GAMESTATE = "gamestate";
    private static final String CONFIG_XML_ROOT = "xmlroot";
    private static final String CONFIG_GAMES = "games";
    private static final String CONFIG_GAME = "game";
    private static final String CONFIG_ROUND = "round";
    private static final String CONFIG_TURN = "turn";
    private static final String CONFIG_MOVE = "move";
    private static final String CONFIG_NEWGAME = "newgame";
    private static final String CONFIG_NEWROUND = "newround";
    private static final String CONFIG_NEWTURN = "newturn";
    private static final String CONFIG_AFTERMOVE = "aftermove";
    private static final String CONFIG_GAMEDIALOGS = "gamedialogs";
    private static final String CONFIG_INFODIALOGS = "infodialogs";
    private static final String CONFIG_NEWGAMEDIALOG = "newgamedialog";
    private static final String CONFIG_ASKTOSAVE = "asktosave";
    private static final String CONFIG_CHANGED = "changed";
    private static final String CONFIG_RECORD = "record";
    private static final String CONFIG_STATISTICS = "statistics";
    private static final String CONFIG_SCORES = "scores";
    private static final String CONFIG_HIGHSCORE = "highscore";
    private static final String CONFIG_ONLYFIRST = "onlyfirst";
    private static final String CONFIG_LOWERSCOREISBETTER = "lowerscoreisbetter";
    private static final String CONFIG_SCROLLWHEN = "scrollwhen";
    private static final String CONFIG_ZOOM = "zoom";
    private static final String CONFIG_IGNOREZOOM = "ignorezoom";
    private static final String CONFIG_PATH = "path";
    static final String CONFIG_TYPE = "type";
    static final String CONFIG_VALUE = "value";
    private static final String CONFIG_FALSE = "false";
    private static final String CONFIG_TRUE = "true";
    private static final String CONFIG_DEFAULT = "default";
    private static final String CONFIG_DELAY = "delay";
    private static final String CONFIG_INTERRUPT = "interrupt";
    private static final String CONFIG_HIDDEN = "hidden";
    private static final String CONFIG_ORDERBY = "orderby";
    private static final String CONFIG_MIN = "min";
    private static final String CONFIG_MAX = "max";
    private static final String CONFIG_ORDER = "order";
    private static final String CONFIG_CLOCKWISE = "clockwise";
    private static final String CONFIG_COUNTERCLOCKWISE = "counterclockwise";
    private static final String CONFIG_ANTICLOCKWISE = "anticlockwise";
    private static final String CONFIG_EXTENSION = "extension";
    private static final String CONFIG_COMPLETE = "complete";
    private static final String CONFIG_PLAYERS = "players";
    private static final String CONFIG_ONEHUMAN = "onehuman";
    private static final String CONFIG_WITHOUTHUMAN = "withouthuman";
    private static final String CONFIG_PLAYER = "player";
    private static final String CONFIG_PLAYERIMAGE = "playerimage";
    private static final String CONFIG_GAMEFIELD = "gamefield";
    private static final String CONFIG_HEIGHT = "height";
    private static final String CONFIG_WIDTH = "width";
    private static final String CONFIG_HORIZONTAL_ALIGNMENT = "halign";
    private static final String CONFIG_VERTICAL_ALIGNMENT = "valign";
    private static final String CONFIG_BACKGROUNDS = "backgrounds";
    private static final String CONFIG_BACKGROUND = "background";
    private static final String CONFIG_FIXED = "fixed";
    private static final String CONFIG_REPEAT = "repeat";
    private static final String CONFIG_YPOS = "ypos";
    private static final String CONFIG_XPOS = "xpos";
    private static final String CONFIG_BOARDS = "boards";
    private static final String CONFIG_BOARD = "board";
    private static final String CONFIG_PIECESET = "pieceset";
    private static final String CONFIG_PIECES = "pieces";
    private static final String CONFIG_PIECE = "piece";
    private static final String CONFIG_PIECECOLOR = "piececolor";
    static final String CONFIG_CARDSET = "cardset";
    private static final String CONFIG_CARDS = "cards";
    private static final String CONFIG_CARD = "card";
    private static final String CONFIG_COVERS = "covers";
    private static final String CONFIG_COVER = "cover";
    private static final String CONFIG_PARTSET = "partset";
    private static final String CONFIG_PARTS = "parts";
    private static final String CONFIG_PART = "part";
    private static final String CONFIG_EXT_PART = ".part";
    private static final String CONFIG_EXTEND = "extend";
    private static final String CONFIG_PARTCLASS = "partclass";
    private static final String CONFIG_SETCLASS = "setclass";
    private static final String CONFIG_CVPCLASS = "cvpclass";
    private static final String CONFIG_COLORS = "colors";
    static final String CONFIG_COLOR = "color";
    private static final String CONFIG_ARRANGEMENTS = "arrangements";
    private static final String CONFIG_ARRANGEMENT = "arrangement";
    private static final String CONFIG_PLAYING_FIELDS = "playingfields";
    private static final String CONFIG_PLAYING_FIELD = "playingfield";
    private static final String CONFIG_FILE = "file";
    private static List<Background> backgroundList = new ArrayList<Background>();
    private static List<Board> boardList = new ArrayList<Board>();
    private static List<Cover> coverList = new ArrayList<Cover>();
    private static List<PieceSet> pieceSetList = new ArrayList<PieceSet>();
    private static List<Arrangement> arrangementList = new ArrayList<Arrangement>();
    private static Map<String, AbstractImageEffectReader<? extends ImageEffect>> effectReaders = new HashMap<String, AbstractImageEffectReader<? extends ImageEffect>>();

    static {
        effectReaders.put("shadow", new ImageShodawReader());
        effectReaders.put("reflection", new ImageReflectionReader());
    }

    GameConfigFileReader() {
    }

    public static void read(GameConfig config) {
        GameConfigFileReader.initConfigValues(config);
        String fileName = HGBaseSettings.get("fileTjger");
        Element root = HGBaseXMLTools.readXML(fileName);
        if (root == null) {
            config.hasErrors = true;
            HGBaseLog.logError("The game configuration file '" + fileName + "' was not found or is not xml conform!");
        } else {
            ChildNodeIterator.run(new ChildNodeIterator(root, CONFIG_TJGER, config){

                @Override
                public void performNode(Node node, int index, Object obj) {
                    GameConfig config = (GameConfig)obj;
                    switch (node.getNodeName()) {
                        case "settings": {
                            GameConfigFileReader.readSettings(node, config);
                            config.loadTjgerImage();
                            TjgerWelcome.getInstance().setGameConfig(config);
                            break;
                        }
                        case "players": {
                            GameConfigFileReader.readPlayers(node, config);
                            break;
                        }
                        case "backgrounds": {
                            GameConfigFileReader.readBackgrounds(node, config);
                            break;
                        }
                        case "boards": {
                            GameConfigFileReader.readBoards(node, config);
                            break;
                        }
                        case "covers": {
                            GameConfigFileReader.readCovers(node, config);
                            break;
                        }
                        case "cards": {
                            GameConfigFileReader.readCardSets(node, config);
                            break;
                        }
                        case "pieces": {
                            GameConfigFileReader.readPieceSets(node, config);
                            break;
                        }
                        case "parts": {
                            GameConfigFileReader.readParts(node, config);
                            break;
                        }
                        case "colors": {
                            GameConfigFileReader.readColors(node, config);
                            break;
                        }
                        case "arrangements": {
                            GameConfigFileReader.readArrangements(node, config);
                            break;
                        }
                        case "playingfields": {
                            GameConfigFileReader.readPlayingFields(node);
                        }
                    }
                }
            });
            config.backgrounds = backgroundList.toArray(new Background[backgroundList.size()]);
            config.boards = boardList.toArray(new Board[boardList.size()]);
            config.covers = coverList.toArray(new Cover[coverList.size()]);
            config.pieceSets = pieceSetList.toArray(new PieceSet[pieceSetList.size()]);
            config.arrangements = arrangementList.toArray(new Arrangement[arrangementList.size()]);
            GameConfigFileReader.testForErrors(config);
        }
    }

    private static void fillImageInformation(String pieceType, Node node, GameConfig config) {
        config.extensionMap.put(pieceType, HGBaseXMLTools.getAttributeValue(node, CONFIG_EXTENSION));
        config.pathMap.put(pieceType, HGBaseXMLTools.getAttributeValue(node, CONFIG_PATH));
    }

    protected static void readPlayingFields(Node node) {
        final PlayingFieldManager manager = PlayingFieldManager.getInstance();
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_PLAYING_FIELDS, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                InputStream in;
                String fileName;
                if (GameConfigFileReader.CONFIG_PLAYING_FIELD.equals(node.getNodeName()) && HGBaseTools.hasContent(fileName = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_FILE)) && (in = HGBaseFileTools.openApplicationFileStream(fileName, this)) != null) {
                    PlayingField field = PlayingFieldFileOperator.fromStream(in);
                    if (field != null) {
                        String name = HGBaseFileTools.getFileName(fileName, false);
                        manager.addField(name, field);
                    }
                    HGBaseFileTools.closeStream(in);
                }
            }
        });
    }

    protected static void readArrangements(Node node, GameConfig config) {
        config.completeArrangement = HGBaseXMLTools.getAttributeValue(node, CONFIG_COMPLETE).equals(CONFIG_TRUE);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_ARRANGEMENTS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_ARRANGEMENT)) {
                    String name = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_NAME);
                    String back = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_BACKGROUND);
                    String board = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_BOARD);
                    String pieceset = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_PIECESET);
                    String cover = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_COVER);
                    String cardset = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_CARDSET);
                    Arrangement newArrangement = new Arrangement(name, back, board, pieceset, cover, cardset);
                    arrangementList.add(newArrangement);
                    ChildNodeIterator.run(new ChildNodeIterator(node, GameConfigFileReader.CONFIG_ARRANGEMENT, newArrangement){

                        @Override
                        public void performNode(Node node, int index, Object obj) {
                            Arrangement arrange = (Arrangement)obj;
                            String type = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TYPE);
                            String value = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_VALUE);
                            if (HGBaseTools.hasContent(type) && HGBaseTools.hasContent(value)) {
                                int rgb;
                                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_PART)) {
                                    arrange.setPart(type, value);
                                }
                                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_PARTSET)) {
                                    arrange.setPartSet(type, value);
                                }
                                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_CARDSET)) {
                                    arrange.setCardSet(type, value);
                                }
                                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_COLOR) && (rgb = HGBaseTools.toInt(value)) != -2147483631) {
                                    arrange.setColor(type, new Color(rgb));
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    protected static boolean isHiddenEntry(Node node) {
        return HGBaseXMLTools.getAttributeValue(node, CONFIG_HIDDEN).equals(CONFIG_TRUE);
    }

    protected static boolean isVisibleEntry(Node node) {
        return HGBaseXMLTools.getAttributeValue(node, CONFIG_HIDDEN).equals(CONFIG_FALSE);
    }

    protected static boolean isHiddenPart(Node node, GameConfig config) {
        return config.helpHidden && !GameConfigFileReader.isVisibleEntry(node) || GameConfigFileReader.isHiddenEntry(node);
    }

    static <T extends Part> List<T> getListFromMap(Map<String, List<T>> map, String type) {
        List<T> list = map.get(type);
        if (list != null) {
            return list;
        }
        ArrayList newList = new ArrayList();
        map.put(type, newList);
        return newList;
    }

    protected static void readParts(Node node, final GameConfig config) {
        GameConfigFileReader.fillImageInformation(CONFIG_PART, node, config);
        GameConfigFileReader.fillImageInformation(CONFIG_PARTSET, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_PARTS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_EXTEND)) {
                    String type = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TYPE);
                    String partClass = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_PARTCLASS);
                    String setClass = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_SETCLASS);
                    String cvpClass = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_CVPCLASS);
                    if (partClass.length() > 0) {
                        config.extendPartMap.put(type, partClass);
                    }
                    if (setClass.length() > 0) {
                        config.extendPartSetMap.put(type, setClass);
                    }
                    if (cvpClass.length() > 0) {
                        config.extendCvpMap.put(type, cvpClass);
                    }
                }
            }
        });
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_PARTS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_PART)) {
                    String name = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_NAME);
                    String type = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TYPE);
                    if (HGBaseTools.hasContent(type)) {
                        String image = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_IMAGE);
                        if (!HGBaseTools.hasContent(image)) {
                            image = GameConfigFileReader.calculateImage(GameConfigFileReader.CONFIG_PART, name, config);
                        }
                        ImageIcon imgPart = HGBaseGuiTools.loadImage(image);
                        boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
                        if (imgPart != null) {
                            List listPart = GameConfigFileReader.getListFromMap(config.partMap, type);
                            String partClass = config.extendPartMap.get(type);
                            Part newPart = null;
                            if (partClass != null) {
                                Class[] classes = new Class[]{String.class, String.class, ImageIcon.class, Boolean.TYPE};
                                Object[] params = new Object[]{type, name, imgPart, hidden};
                                newPart = ClassFactory.createClass(partClass, Part.class, GameConfigFileReader.CONFIG_PARTCLASS, classes, params);
                            }
                            if (newPart == null) {
                                newPart = new Part(type, name, imgPart, hidden);
                            }
                            GameConfigFileReader.setEffectsForPart(newPart, node, topLevelEffects);
                            listPart.add(newPart);
                        } else {
                            HGBaseLog.logWarn("Part image " + image + " not found!");
                        }
                    } else {
                        HGBaseLog.logWarn("No type defined for part '" + name + "'!");
                    }
                }
            }
        });
        new PartSetContructor<PartSet>(CONFIG_PARTS, CONFIG_PARTSET, CONFIG_PART, config.partSetMap){

            @Override
            protected PartSet createPartSet(String type, String name, Node node, boolean hidden) {
                String setClass = config.extendPartSetMap.get(type);
                PartSet newPartSet = null;
                if (setClass != null) {
                    Class[] classes = new Class[]{String.class, String.class, Boolean.TYPE};
                    Object[] params = new Object[]{type, name, hidden};
                    newPartSet = ClassFactory.createClass(setClass, PartSet.class, GameConfigFileReader.CONFIG_SETCLASS, classes, params);
                }
                if (newPartSet == null) {
                    newPartSet = new PartSet(type, name, hidden);
                }
                GameConfigFileReader.setEffectsForPart(newPartSet, node, topLevelEffects);
                return newPartSet;
            }

            @Override
            protected ColorValuePart createColorValuePart(PartSet set, String color, int sequence, int value, ImageIcon image, Node node) {
                String partType = String.valueOf(set.getType()) + GameConfigFileReader.CONFIG_EXT_PART;
                String cvpClass = config.extendCvpMap.get(set.getType());
                ColorValuePart newCVP = null;
                if (cvpClass != null) {
                    Class[] classes = new Class[]{PartSet.class, String.class, String.class, Integer.TYPE, Integer.TYPE, ImageIcon.class};
                    Object[] params = new Object[]{set, partType, color, sequence, value, image};
                    newCVP = ClassFactory.createClass(cvpClass, ColorValuePart.class, GameConfigFileReader.CONFIG_CVPCLASS, classes, params);
                }
                if (newCVP == null) {
                    newCVP = new ColorValuePart(set, partType, color, sequence, value, image);
                }
                GameConfigFileReader.setEffectsForPart(newCVP, node, set);
                return newCVP;
            }
        }.run(node, config);
    }

    protected static void readColors(Node node, GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_COLORS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                String colorType;
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_COLOR) && HGBaseTools.hasContent(colorType = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TYPE))) {
                    String defaultText = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_DEFAULT);
                    int rgb = HGBaseTools.toInt(defaultText);
                    Color defaultColor = rgb == -2147483631 ? null : new Color(rgb);
                    config.colors.put(colorType, defaultColor);
                }
            }
        });
    }

    protected static void readPieceSets(Node node, GameConfig config) {
        GameConfigFileReader.setOrderBy(config, "game.pieceset", node);
        GameConfigFileReader.fillImageInformation(CONFIG_PIECE, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        new PartSetContructor<PieceSet>(CONFIG_PIECES, CONFIG_PIECESET, CONFIG_PIECE, pieceSetList){

            @Override
            protected PieceSet createPartSet(String type, String name, Node node, boolean hidden) {
                PieceSet pieceSetPart = new PieceSet(name, hidden);
                GameConfigFileReader.setEffectsForPart(pieceSetPart, node, topLevelEffects);
                return pieceSetPart;
            }

            @Override
            protected ColorValuePart createColorValuePart(PartSet set, String color, int sequence, int value, ImageIcon image, Node node) {
                Piece piecePart = new Piece((PieceSet)set, color, sequence, value, image);
                GameConfigFileReader.setEffectsForPart(piecePart, node, set);
                return piecePart;
            }
        }.run(node, config);
    }

    static void setOrderBy(GameConfig config, String setType, Node node) {
        int currentOrder = config.getOrderby(setType);
        if (currentOrder < 0 || currentOrder == 0) {
            String modeText = HGBaseXMLTools.getAttributeValue(node, CONFIG_ORDERBY);
            int modeInt = 0;
            if (modeText.equals(CONFIG_VALUE)) {
                modeInt = 2;
            } else if (modeText.equals(CONFIG_COLOR)) {
                modeInt = 1;
            }
            config.setOrderBy.set(setType, modeInt);
        }
    }

    protected static void readCardSets(Node node, GameConfig config) {
        GameConfigFileReader.setOrderBy(config, "game.cardset", node);
        GameConfigFileReader.fillImageInformation(CONFIG_CARD, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        new PartSetContructor<CardSet>(CONFIG_CARDS, CONFIG_CARDSET, CONFIG_CARD, config.cardSetsMap){

            @Override
            protected CardSet createPartSet(String type, String name, Node node, boolean hidden) {
                String validType = type == null || type.isEmpty() ? "game.cardset" : type;
                CardSet cardSetPart = new CardSet(validType, name, hidden);
                GameConfigFileReader.setEffectsForPart(cardSetPart, node, topLevelEffects);
                return cardSetPart;
            }

            @Override
            protected ColorValuePart createColorValuePart(PartSet set, String color, int sequence, int value, ImageIcon image, Node node) {
                Card cardPart = new Card((CardSet)set, color, sequence, value, image);
                GameConfigFileReader.setEffectsForPart(cardPart, node, set);
                return cardPart;
            }
        }.run(node, config);
        int defaultOrder = config.getOrderby("game.cardset");
        if (GameConfigFileReader.isDefinedOrder(defaultOrder)) {
            String[] cardTypes = config.getCardSetTypes();
            int i = 0;
            while (i < cardTypes.length) {
                int testOrder = config.getOrderby(cardTypes[i]);
                if (!GameConfigFileReader.isDefinedOrder(testOrder)) {
                    config.setOrderBy.set(cardTypes[i], defaultOrder);
                }
                ++i;
            }
        }
    }

    private static boolean isDefinedOrder(int defaultOrder) {
        return defaultOrder >= 0 && defaultOrder != 0;
    }

    protected static void readCovers(Node node, GameConfig config) {
        GameConfigFileReader.fillImageInformation(CONFIG_COVER, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_COVERS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_COVER)) {
                    String name = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_NAME);
                    String image = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_IMAGE);
                    if (!HGBaseTools.hasContent(image)) {
                        image = GameConfigFileReader.calculateImage(GameConfigFileReader.CONFIG_COVER, name, config);
                    }
                    ImageIcon imgCover = HGBaseGuiTools.loadImage(image);
                    boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
                    if (imgCover != null) {
                        Cover coverPart = new Cover(name, imgCover, hidden);
                        GameConfigFileReader.setEffectsForPart(coverPart, node, topLevelEffects);
                        coverList.add(coverPart);
                    } else {
                        HGBaseLog.logWarn("Cover image " + image + " not found!");
                    }
                }
            }
        });
    }

    protected static void readBoards(Node node, GameConfig config) {
        GameConfigFileReader.fillImageInformation(CONFIG_BOARD, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_BOARDS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_BOARD)) {
                    int zoom;
                    int yPos;
                    String name = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_NAME);
                    String image = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_IMAGE);
                    if (!HGBaseTools.hasContent(image)) {
                        image = GameConfigFileReader.calculateImage(GameConfigFileReader.CONFIG_BOARD, name, config);
                    }
                    ImageIcon imgBoard = HGBaseGuiTools.loadImage(image);
                    int xPos = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_XPOS));
                    if (xPos == -2147483631) {
                        xPos = 0;
                    }
                    if ((yPos = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_YPOS))) == -2147483631) {
                        yPos = 0;
                    }
                    if ((zoom = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ZOOM))) == -2147483631) {
                        zoom = 100;
                    }
                    boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
                    if (imgBoard != null) {
                        Board boardPart = new Board(name, imgBoard, xPos, yPos, hidden, zoom);
                        GameConfigFileReader.setEffectsForPart(boardPart, node, topLevelEffects);
                        boardList.add(boardPart);
                    } else {
                        HGBaseLog.logWarn("Board image " + image + " not found!");
                    }
                }
            }
        });
    }

    protected static void readBackgrounds(Node node, GameConfig config) {
        GameConfigFileReader.fillImageInformation(CONFIG_BACKGROUND, node, config);
        final Map<String, ImageEffect> topLevelEffects = GameConfigFileReader.readEffectsFromNode(node);
        config.helpHidden = GameConfigFileReader.isHiddenEntry(node);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_BACKGROUNDS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_BACKGROUND)) {
                    String name = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_NAME);
                    String image = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_IMAGE);
                    String color = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_COLOR);
                    if (HGBaseTools.hasContent(image) && HGBaseTools.hasContent(color)) {
                        HGBaseLog.logWarn("Ambigous background " + name + ": defines image and color!");
                    } else {
                        boolean hidden = GameConfigFileReader.isHiddenPart(node, config);
                        if (HGBaseTools.hasContent(color)) {
                            boolean fixed = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_FIXED).equals(GameConfigFileReader.CONFIG_TRUE);
                            int rgb = HGBaseTools.toInt(color);
                            if (rgb != -2147483631) {
                                backgroundList.add(new Background(name, new Color(rgb), fixed, hidden));
                            } else {
                                HGBaseLog.logWarn("Invalid color for background " + name + "!");
                            }
                        } else {
                            ImageIcon imgBack;
                            if (!HGBaseTools.hasContent(image)) {
                                image = GameConfigFileReader.calculateImage(GameConfigFileReader.CONFIG_BACKGROUND, name, config);
                            }
                            if ((imgBack = HGBaseGuiTools.loadImage(image)) != null) {
                                boolean repeat = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_REPEAT).equals(GameConfigFileReader.CONFIG_TRUE);
                                boolean ignoreZoom = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_IGNOREZOOM).equals(GameConfigFileReader.CONFIG_TRUE);
                                int zoom = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ZOOM));
                                if (zoom == -2147483631) {
                                    zoom = 100;
                                }
                                Background backPart = new Background(name, imgBack, repeat, ignoreZoom, hidden, zoom);
                                if (!repeat) {
                                    GameConfigFileReader.setEffectsForPart(backPart, node, topLevelEffects);
                                }
                                backgroundList.add(backPart);
                            } else {
                                HGBaseLog.logWarn("Background image " + image + " not found!");
                            }
                        }
                    }
                }
            }
        });
    }

    protected static String calculateImage(String pieceType, String name, GameConfig config) {
        return String.valueOf(config.getImagePath(pieceType)) + "/" + name + "." + config.getImageExtension(pieceType);
    }

    private static Map<String, ImageEffect> readEffectsFromNode(Node node) {
        HashMap<String, ImageEffect> availableEffects = new HashMap<String, ImageEffect>();
        for (Map.Entry<String, AbstractImageEffectReader<? extends ImageEffect>> reader : effectReaders.entrySet()) {
            ImageEffect effect = reader.getValue().getEffectDefinition(node);
            if (effect == null) continue;
            availableEffects.put(reader.getKey(), effect);
        }
        return availableEffects;
    }

    private static void setEffectsForPart(Part part, Node node, Map<String, ImageEffect> higherLevelEffects) {
        for (Map.Entry<String, AbstractImageEffectReader<? extends ImageEffect>> reader : effectReaders.entrySet()) {
            ImageEffect higherLevelEffect = higherLevelEffects.get(reader.getKey());
            reader.getValue().setEffectForPart(part, node, higherLevelEffect);
        }
    }

    private static void setEffectsForPart(Part part, Node node, Part higherLevelPart) {
        for (Map.Entry<String, AbstractImageEffectReader<? extends ImageEffect>> reader : effectReaders.entrySet()) {
            ImageEffect higherLevelEffect = reader.getValue().getEffectFromPart(higherLevelPart);
            reader.getValue().setEffectForPart(part, node, higherLevelEffect);
        }
    }

    protected static void readPlayers(Node node, GameConfig config) {
        GameConfigFileReader.fillImageInformation(CONFIG_PLAYER, node, config);
        config.playerImageName = HGBaseXMLTools.getAttributeValue(node, CONFIG_PLAYERIMAGE);
        config.playerPieceColor = HGBaseXMLTools.getAttributeValue(node, CONFIG_PIECECOLOR);
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_PLAYERS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config = (GameConfig)obj;
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_PLAYER)) {
                    String playerType = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TYPE);
                    String classPath = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_CLASS);
                    String image = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_IMAGE);
                    if (!HGBaseTools.hasContent(image)) {
                        image = GameConfigFileReader.calculateImage(GameConfigFileReader.CONFIG_PLAYER, playerType, config);
                    }
                    ImageIcon typeImage = HGBaseGuiTools.loadImage(image);
                    if (PlayerFactory.getInstance().addPlayerType(playerType, classPath, typeImage) && typeImage == null) {
                        HGBaseLog.logWarn("Player type image " + image + " not found!");
                    }
                }
            }
        });
    }

    protected static void readSettings(Node node, GameConfig config) {
        ChildNodeIterator.run(new ChildNodeIterator(node, CONFIG_SETTINGS, config){

            @Override
            public void performNode(Node node, int index, Object obj) {
                GameConfig config;
                block51: {
                    String classPath;
                    config = (GameConfig)obj;
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_RULES)) {
                        classPath = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_CLASS);
                        if (!RulesFactory.getInstance().setRulesClass(classPath)) {
                            config.hasErrors = true;
                        }
                    }
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_GAMESTATE)) {
                        classPath = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_CLASS);
                        if (!StateFactory.getInstance().setGameStateClass(classPath)) {
                            config.hasErrors = true;
                        } else {
                            String record = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_RECORD).toLowerCase();
                            config.recordOnNewGame = GameConfigFileReader.CONFIG_GAME.equals(record);
                            config.recordOnNewRound = GameConfigFileReader.CONFIG_ROUND.equals(record);
                            config.recordOnNewTurn = GameConfigFileReader.CONFIG_TURN.equals(record);
                            config.gameStateXmlRoot = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_XML_ROOT);
                        }
                    }
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_NEWGAMEDIALOG)) {
                        classPath = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_CLASS);
                        String askToSave = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ASKTOSAVE);
                        GameDialogFactory.getInstance().setNewGameDialogClass(classPath, askToSave);
                    }
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_GAMEDIALOGS)) {
                        classPath = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_CLASS);
                        GameDialogFactory.getInstance().setGameDialogsClass(classPath);
                    }
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_CHANGED)) {
                        config.changedOnNewGame = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_NEWGAME).equals(GameConfigFileReader.CONFIG_TRUE);
                        config.changedOnNewRound = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_NEWROUND).equals(GameConfigFileReader.CONFIG_TRUE);
                        config.changedOnNewTurn = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_NEWTURN).equals(GameConfigFileReader.CONFIG_TRUE);
                        config.changedAfterMove = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_AFTERMOVE).equals(GameConfigFileReader.CONFIG_TRUE);
                    }
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_PLAYERS)) {
                        String order;
                        config.oneHumanPlayer = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ONEHUMAN).equals(GameConfigFileReader.CONFIG_TRUE);
                        config.withoutHumanPlayer = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_WITHOUTHUMAN).equals(GameConfigFileReader.CONFIG_TRUE);
                        int min = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_MIN));
                        int max = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_MAX));
                        if (min != -2147483631 && max != -2147483631 && min <= max) {
                            config.minPlayers = min;
                            config.maxPlayers = max;
                        }
                        config.playersOrder = GameConfigFileReader.CONFIG_CLOCKWISE.equals(order = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ORDER)) ? 1 : (GameConfigFileReader.CONFIG_COUNTERCLOCKWISE.equals(order) || GameConfigFileReader.CONFIG_ANTICLOCKWISE.equals(order) ? 2 : 0);
                    }
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_STATISTICS)) {
                        int scrollWhen;
                        config.rememberGames = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_GAMES).equals(GameConfigFileReader.CONFIG_TRUE);
                        config.rememberScores = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_SCORES).equals(GameConfigFileReader.CONFIG_TRUE);
                        int hiScore = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_HIGHSCORE));
                        if (hiScore > 0) {
                            config.highScoreLength = hiScore;
                            config.onlyFirstHighScore = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ONLYFIRST).equals(GameConfigFileReader.CONFIG_TRUE);
                        }
                        if ((scrollWhen = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_SCROLLWHEN))) > 0) {
                            config.statisticsScrollWhen = scrollWhen;
                        }
                        config.isLowerScoreBetter = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_LOWERSCOREISBETTER).equals(GameConfigFileReader.CONFIG_TRUE);
                    }
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_ZOOM)) {
                        int min = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_MIN));
                        int max = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_MAX));
                        if (min != -2147483631) {
                            config.minZoom = min;
                        }
                        if (max != -2147483631) {
                            config.maxZoom = max;
                        }
                        if (config.minZoom > config.maxZoom) {
                            config.minZoom = 100;
                            config.maxZoom = 100;
                        }
                    }
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_NETWORK)) {
                        int port = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_PORT));
                        if (port != -2147483631) {
                            config.networkPort = port;
                        }
                        config.localGameStateTurn = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TURN).equals(GameConfigFileReader.CONFIG_LOCAL);
                        config.localGameStateRound = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ROUND).equals(GameConfigFileReader.CONFIG_LOCAL);
                        config.localGameStateGame = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_GAME).equals(GameConfigFileReader.CONFIG_LOCAL);
                    }
                    if (node.getNodeName().equals(GameConfigFileReader.CONFIG_IMAGE)) {
                        String welcome = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_WELCOME);
                        config.welcomeImage = HGBaseGuiTools.loadImage(welcome);
                        int timeout = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_WELCOME_TIMEOUT));
                        if (timeout >= 0) {
                            config.welcomeImageTimeout = timeout;
                        }
                    }
                    if (!node.getNodeName().equals(GameConfigFileReader.CONFIG_GAMEFIELD)) break block51;
                    int w = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_WIDTH));
                    int h = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_HEIGHT));
                    if (w != -2147483631 && h != -2147483631) {
                        config.fieldWidth = w;
                        config.fieldHeight = h;
                    }
                    switch (HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_HORIZONTAL_ALIGNMENT).toUpperCase()) {
                        case "CENTER": {
                            config.fieldHorizontalAlignment = 0;
                            break;
                        }
                        case "RIGHT": {
                            config.fieldHorizontalAlignment = -1;
                            break;
                        }
                        default: {
                            config.fieldHorizontalAlignment = 1;
                        }
                    }
                    switch (HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_VERTICAL_ALIGNMENT).toUpperCase()) {
                        case "MIDDLE": {
                            config.fieldVerticalAlignment = 0;
                            break;
                        }
                        case "BOTTOM": {
                            config.fieldVerticalAlignment = -1;
                            break;
                        }
                        default: {
                            config.fieldVerticalAlignment = 1;
                        }
                    }
                }
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_INFODIALOGS)) {
                    config.dialogAfterTurn = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TURN).equals(GameConfigFileReader.CONFIG_TRUE);
                    config.dialogAfterRound = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ROUND).equals(GameConfigFileReader.CONFIG_TRUE);
                    config.dialogAfterGame = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_GAME).equals(GameConfigFileReader.CONFIG_TRUE);
                }
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_INTERRUPT)) {
                    config.interruptAfterRound = HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ROUND).equals(GameConfigFileReader.CONFIG_TRUE);
                }
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_HINTS)) {
                    GameConfigFileReader.putIntoMap(node, GameConfigFileReader.CONFIG_PATH, config.hintsMap);
                    GameConfigFileReader.putIntoMap(node, GameConfigFileReader.CONFIG_EXTENSION, config.hintsMap);
                    for (String hintType : ConstantValue.getHintTypes()) {
                        GameConfigFileReader.putIntoMap(node, hintType, config.hintsMap);
                    }
                }
                if (node.getNodeName().equals(GameConfigFileReader.CONFIG_DELAY)) {
                    int player;
                    int move;
                    int turn;
                    int round = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_ROUND));
                    if (round > 0) {
                        config.delayRound = round;
                    }
                    if ((turn = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_TURN))) > 0) {
                        config.delayTurn = turn;
                    }
                    if ((move = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_MOVE))) > 0) {
                        config.delayMove = move;
                    }
                    if ((player = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, GameConfigFileReader.CONFIG_PLAYER))) > 0) {
                        config.delayPlayer = player;
                    }
                }
            }
        });
    }

    private static void putIntoMap(Node node, String attribute, Map<String, String> map) {
        String value = HGBaseXMLTools.getAttributeValue(node, attribute);
        if (HGBaseTools.hasContent(value)) {
            map.put(attribute, value);
        }
    }

    private static void testForErrors(GameConfig config) {
        if (config.getMinPlayers() == 0 || config.getMaxPlayers() == 0 || config.getMaxPlayers() < config.getMinPlayers()) {
            config.hasErrors = true;
            HGBaseLog.logError("Number of players are defined ambiguous!");
        } else {
            PlayerFactory f = PlayerFactory.getInstance();
            if (f.getSupportedPlayerTypes().length - f.getNetworkPlayerTypes().length <= 0) {
                config.hasErrors = true;
                HGBaseLog.logError("There aren't enough valid player types defined!");
            }
            if (config.networkPort > 0 && f.getNetworkPlayerTypes().length > 0) {
                config.networkPossible = true;
            }
        }
    }

    private static void initConfigValues(GameConfig config) {
        config.welcomeImageTimeout = 1700;
        config.completeArrangement = false;
        config.minZoom = 100;
        config.maxZoom = 100;
        config.extensionMap = new LinkedHashMap<String, String>();
        config.pathMap = new LinkedHashMap<String, String>();
        config.colors = new LinkedHashMap<String, Color>();
        config.playerImageName = "";
        config.playerPieceColor = "";
        config.networkPossible = false;
        config.networkPort = 0;
        config.minPlayers = 0;
        config.maxPlayers = 0;
        config.fieldWidth = 0;
        config.fieldHeight = 0;
        config.oneHumanPlayer = false;
        config.withoutHumanPlayer = false;
        config.rememberScores = false;
        config.rememberGames = false;
        config.highScoreLength = 0;
        config.onlyFirstHighScore = false;
        config.isLowerScoreBetter = false;
        config.statisticsScrollWhen = 0;
        config.changedOnNewGame = false;
        config.changedOnNewRound = false;
        config.changedOnNewTurn = false;
        config.changedAfterMove = false;
        config.dialogAfterTurn = false;
        config.dialogAfterRound = false;
        config.dialogAfterGame = false;
        config.interruptAfterRound = false;
        config.hasErrors = false;
        config.cardSetsMap = new LinkedHashMap<String, List<CardSet>>();
        config.partMap = new LinkedHashMap<String, List<Part>>();
        config.partSetMap = new LinkedHashMap<String, List<PartSet>>();
        config.extendPartMap = new HashMap<String, String>();
        config.extendPartSetMap = new HashMap<String, String>();
        config.extendCvpMap = new HashMap<String, String>();
        config.setOrderBy = new IntBooleanStringMap();
        config.localGameStateTurn = false;
        config.localGameStateRound = false;
        config.localGameStateGame = false;
        config.hintsMap = new LinkedHashMap();
        config.delayRound = 0;
        config.delayTurn = 0;
        config.delayMove = 0;
        config.delayPlayer = 0;
        config.gameSpeed = 1.0;
        config.playersOrder = 0;
        config.recordOnNewGame = false;
        config.recordOnNewRound = false;
        config.recordOnNewTurn = false;
    }
}

