/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import javax.swing.ImageIcon;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.game.internal.PlayerFactory;
import tjger.lib.ArrayUtil;

public final class PlayerManager {
    private static PlayerManager manager = new PlayerManager();
    private final GameConfig gameConfig = GameConfig.getInstance();
    private GamePlayer[] playerList;

    private PlayerManager() {
        this.initPlayers();
    }

    public static PlayerManager getInstance() {
        return manager;
    }

    private void initPlayers() {
        this.playerList = new GamePlayer[this.getMaxPlayers()];
        String imagePath = this.gameConfig.getImagePath("player");
        String imageExtension = this.gameConfig.getImageExtension("player");
        int i = 0;
        while (i < this.playerList.length) {
            String playerType = this.getPlayerType(i);
            String playerName = this.getStandardPlayerName(i);
            ImageIcon playerImage = this.getPlayerImage(i, imagePath, imageExtension);
            String pieceColor = this.getPieceColor(i);
            this.playerList[i] = PlayerFactory.getInstance().createPlayer(playerType, playerName, playerImage, pieceColor);
            ++i;
        }
    }

    private ImageIcon getPlayerImage(int i, String imagePath, String imageExtension) {
        String imageName = HGBaseConfig.get("player.image" + i);
        if (!HGBaseTools.hasContent(imageName)) {
            imageName = String.valueOf(this.gameConfig.getPlayerImageName()) + i;
        }
        ImageIcon playerImage = HGBaseGuiTools.loadImage(String.valueOf(imagePath) + "/" + imageName + "." + imageExtension);
        return playerImage;
    }

    private String getPieceColor(int i) {
        String pieceColor = HGBaseConfig.get("player.piececolor" + i);
        if (!HGBaseTools.hasContent(pieceColor) && HGBaseTools.hasContent(this.gameConfig.getPlayerPieceColor())) {
            pieceColor = String.valueOf(this.gameConfig.getPlayerPieceColor()) + i;
        }
        return pieceColor;
    }

    public String getStandardPlayerName(int i) {
        String playerName = HGBaseConfig.get("player.name" + i);
        if (!HGBaseTools.hasContent(playerName)) {
            playerName = String.valueOf(HGBaseSettings.get("appName")) + " " + (i + 1);
        }
        return playerName;
    }

    private String getPlayerType(int index) {
        String playerType = HGBaseConfig.get("player.type" + index);
        Object[] sp = ArrayUtil.toPlayerTypeIds(PlayerFactory.getInstance().getSupportedPlayerTypes());
        if (HGBaseTools.getIndexOf(sp, playerType) == -1 && sp.length > 0) {
            Object pt;
            Object[] hp = ArrayUtil.toPlayerTypeIds(PlayerFactory.getInstance().getHumanPlayerTypes());
            Object[] np = ArrayUtil.toPlayerTypeIds(PlayerFactory.getInstance().getNetworkPlayerTypes());
            int i = 0;
            while (i < sp.length) {
                pt = sp[i];
                if (HGBaseTools.getIndexOf(np, pt) == -1) {
                    if (HGBaseTools.getIndexOf(hp, pt) >= 0) {
                        if (!this.gameConfig.isOneHumanPlayer() || index == 0) {
                            return pt;
                        }
                    } else {
                        return pt;
                    }
                }
                ++i;
            }
            if (this.gameConfig.isNetworkPossible()) {
                i = 0;
                while (i < sp.length) {
                    pt = sp[i];
                    if (HGBaseTools.getIndexOf(hp, pt) >= 0) {
                        if (!this.gameConfig.isOneHumanPlayer() || index == 0) {
                            return pt;
                        }
                    } else {
                        return pt;
                    }
                    ++i;
                }
            }
            return sp[0];
        }
        return playerType;
    }

    public int getMinPlayers() {
        return this.gameConfig.getMinPlayers();
    }

    public int getMaxPlayers() {
        return this.gameConfig.getMaxPlayers();
    }

    public GamePlayer[] getPlayers() {
        if (this.playerList == null) {
            return null;
        }
        return (GamePlayer[])this.playerList.clone();
    }

    public GamePlayer getPlayer(int index) {
        if (index >= 0 && index < this.playerList.length) {
            return this.playerList[index];
        }
        return null;
    }

    public int getIndexOfPlayer(GamePlayer player) {
        int index = -1;
        int i = 0;
        while (i < this.playerList.length && index == -1) {
            if (this.playerList[i].equals(player)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void setPlayer(int index, GamePlayer player) {
        if (index >= 0 && index < this.playerList.length && player != null && this.getIndexOfPlayer(player) == -1) {
            this.playerList[index] = player;
        }
    }
}

