/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed.imagereader;

import hgb.lib.xml.HGBaseXMLTools;
import org.w3c.dom.Node;
import tjger.gui.completed.ImageEffect;
import tjger.gui.completed.Part;

public abstract class AbstractImageEffectReader<T extends ImageEffect> {
    private final String attributeName;
    private Node currentNode;

    protected AbstractImageEffectReader(String attributeName) {
        this.attributeName = attributeName;
    }

    protected Node getCurrentNode() {
        return this.currentNode;
    }

    public final T getEffectDefinition(Node node) {
        this.currentNode = node;
        String effectValue = HGBaseXMLTools.getAttributeValue(node, this.attributeName);
        return this.readEffectDefinition(effectValue);
    }

    protected abstract T readEffectDefinition(String var1);

    public final T getEffectDefinition(Node node, T higherLevelEffect) {
        T currentEffect = this.getEffectDefinition(node);
        return currentEffect == null ? higherLevelEffect : currentEffect;
    }

    public final void setEffectForPart(Part part, Node node, ImageEffect higherLevelEffect) {
        this.currentNode = node;
        ImageEffect currentEffect = this.getEffectDefinition(node, higherLevelEffect);
        if (currentEffect != null) {
            this.setEffectForPart(part, currentEffect);
        }
    }

    protected abstract void setEffectForPart(Part var1, T var2);

    public abstract T getEffectFromPart(Part var1);
}

