/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.internal;

import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.internal.GameStatistics;
import tjger.game.internal.ScoreRankElement;

class GameStatisticsFileOperator {
    private static int loadNumSre;
    private static int loadGameRanks;

    GameStatisticsFileOperator() {
    }

    public static void write(Document doc, Element root, GameStatistics statistics) {
        Element playerStat = doc.createElement("playerstats");
        GamePlayer[] player = statistics.gamePlayerList;
        int i = 0;
        while (i < player.length) {
            Element pE = doc.createElement("player");
            pE.setAttribute("index", String.valueOf(i));
            pE.setAttribute("st", String.valueOf(player[i].getScore(1)));
            pE.setAttribute("sr", String.valueOf(player[i].getScore(2)));
            pE.setAttribute("sg", String.valueOf(player[i].getScore(4)));
            pE.setAttribute("gp", String.valueOf(player[i].getGamesPlayed()));
            pE.setAttribute("gw", String.valueOf(player[i].getGamesWon()));
            pE.setAttribute("do", String.valueOf(player[i].isDropOut()));
            playerStat.appendChild(pE);
            ++i;
        }
        root.appendChild(playerStat);
        Element rounds = doc.createElement("rounds");
        rounds.setAttribute("number", String.valueOf(statistics.roundScoreRankingList.size()));
        int i2 = 0;
        while (i2 < statistics.roundScoreRankingList.size()) {
            Element ri = doc.createElement("round" + i2);
            ScoreRankElement[] sre = statistics.roundScoreRankingList.get(i2);
            int j = 0;
            while (j < sre.length) {
                Element sreNode = doc.createElement("sre" + j);
                sreNode.setAttribute("score", String.valueOf(sre[j].getScore()));
                sreNode.setAttribute("rank", String.valueOf(sre[j].getRank()));
                ri.appendChild(sreNode);
                ++j;
            }
            rounds.appendChild(ri);
            ++i2;
        }
        root.appendChild(rounds);
        if (statistics.gameRankingList != null) {
            Element rank = doc.createElement("gamerank");
            int i3 = 0;
            while (i3 < statistics.gameRankingList.length) {
                Element grNode = doc.createElement("gr" + i3);
                grNode.setAttribute("rank", String.valueOf(statistics.gameRankingList[i3]));
                rank.appendChild(grNode);
                ++i3;
            }
            root.appendChild(rank);
        }
    }

    public static boolean read(Node root, final GameStatistics statistics) {
        loadGameRanks = 0;
        statistics.resetRanking();
        ChildNodeIterator.run(new ChildNodeIterator(root, "gamestatistics", statistics){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (node.getNodeName().equals("playerstats")) {
                    ChildNodeIterator.run(new ChildNodeIterator(node, "playerstats", obj){

                        @Override
                        public void performNode(Node node, int index, Object obj) {
                            GamePlayer player;
                            int i;
                            if (node.getNodeName().equals("player") && (i = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "index"))) >= 0 && statistics.gamePlayerList.length > i && (player = statistics.gamePlayerList[i]) != null) {
                                player.setScore(this.getScore(node, "st"), 1);
                                player.setScore(this.getScore(node, "sr"), 2);
                                player.setScore(this.getScore(node, "sg"), 4);
                                int playedGames = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "gp"));
                                int wonGames = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "gw"));
                                if (playedGames >= 0 && wonGames >= 0) {
                                    statistics.setGamesPlayedWon(player, playedGames, wonGames);
                                }
                                boolean dropOut = HGBaseXMLTools.getAttributeValue(node, "do").equals("true");
                                player.setDropOut(dropOut);
                            }
                        }

                        private int getScore(Node node, String scoreType) {
                            int score = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, scoreType));
                            if (score == -2147483631) {
                                score = 0;
                            }
                            return score;
                        }
                    });
                }
                if (node.getNodeName().equals("rounds")) {
                    ChildNodeIterator.run(new ChildNodeIterator(node, "rounds", obj){

                        @Override
                        public void performNode(Node node, int index, Object obj) {
                            int round;
                            if (node.getNodeName().startsWith("round") && (round = HGBaseTools.toInt(node.getNodeName().replaceFirst("round", ""))) >= 0) {
                                loadNumSre = 0;
                                final ScoreRankElement[] sreList = new ScoreRankElement[statistics.gamePlayerList.length];
                                ChildNodeIterator.run(new ChildNodeIterator(node, "round" + round, obj){

                                    @Override
                                    public void performNode(Node node, int index, Object obj) {
                                        int sre;
                                        if (node.getNodeName().startsWith("sre") && (sre = HGBaseTools.toInt(node.getNodeName().replaceFirst("sre", ""))) >= 0) {
                                            int score = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "score"));
                                            int rank = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "rank"));
                                            if (score != -2147483631 && rank >= 0 && loadNumSre < sreList.length) {
                                                sreList[loadNumSre] = new ScoreRankElement(score, rank);
                                                loadNumSre = loadNumSre + 1;
                                            }
                                        }
                                    }
                                });
                                statistics.roundScoreRankingList.add(sreList);
                            }
                        }
                    });
                }
                if (node.getNodeName().equals("gamerank")) {
                    statistics.gameRankingList = new int[statistics.gamePlayerList.length];
                    ChildNodeIterator.run(new ChildNodeIterator(node, "gamerank", obj){

                        @Override
                        public void performNode(Node node, int index, Object obj) {
                            int rank;
                            int gr;
                            if (node.getNodeName().startsWith("gr") && (gr = HGBaseTools.toInt(node.getNodeName().replaceFirst("gr", ""))) >= 0 && loadGameRanks < statistics.gameRankingList.length && (rank = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, "rank"))) >= 0) {
                                statistics.gameRankingList[loadGameRanks] = rank;
                                loadGameRanks = loadGameRanks + 1;
                            }
                        }
                    });
                }
            }
        });
        return true;
    }
}

