/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseTools;
import java.awt.Color;
import javax.swing.ImageIcon;
import tjger.gui.completed.Part;

public class Background
extends Part {
    private boolean repeatMode;
    private boolean ignoreZoom;
    private boolean fixedColor;
    private int zoom;
    private Color backColor;

    public Background(String name, ImageIcon image, boolean repeat, boolean ignoreZoom, boolean hidden, int zoom) {
        super("game.background", name, image, hidden);
        this.repeatMode = repeat;
        this.ignoreZoom = ignoreZoom;
        this.backColor = null;
        this.zoom = zoom > 0 ? zoom : 100;
    }

    public Background(String name, Color backColor, boolean fixedColor, boolean hidden) {
        super("game.background", name, null, hidden);
        this.fixedColor = fixedColor;
        this.backColor = backColor;
    }

    @Override
    public boolean equals(Object o2) {
        return HGBaseTools.equalClass(this, o2) && this.toString().equals(o2.toString());
    }

    public boolean isRepeatMode() {
        return this.repeatMode;
    }

    public boolean isIgnoreZoom() {
        return this.ignoreZoom;
    }

    public boolean isFixedColor() {
        return this.fixedColor;
    }

    public int getZoom() {
        return this.zoom;
    }

    public Color getColor() {
        int rgb = HGBaseConfig.getInt("game.backcolor." + this.getName());
        if (rgb != -2147483631) {
            return new Color(rgb);
        }
        return this.backColor;
    }

    public Color getOriginalColor() {
        return this.backColor;
    }
}

