/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import hgb.lib.HGBaseTools;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import tjger.gui.completed.ColorValuePart;
import tjger.gui.completed.Part;

public class PartSet
extends Part {
    private final Map<String, List<ColorValuePart>> partMap = new LinkedHashMap<String, List<ColorValuePart>>();

    public PartSet(String partType, String name, boolean hidden) {
        super(partType, name, null, hidden);
    }

    @Override
    public boolean equals(Object o2) {
        return HGBaseTools.equalClass(this, o2) && this.toString().equals(o2.toString());
    }

    public void addPart(ColorValuePart newPart) {
        List<ColorValuePart> partList = this.partMap.get(newPart.getColor());
        if (partList == null) {
            partList = new ArrayList<ColorValuePart>();
            this.partMap.put(newPart.getColor(), partList);
        }
        partList.add(newPart);
    }

    public String[] getColors() {
        return HGBaseTools.toStringArray(this.partMap.keySet());
    }

    public List<ColorValuePart> getParts() {
        ArrayList<ColorValuePart> listAll = new ArrayList<ColorValuePart>();
        for (List<ColorValuePart> listColor : this.partMap.values()) {
            for (ColorValuePart part : listColor) {
                listAll.add(part);
            }
        }
        return listAll;
    }

    public List<ColorValuePart> getParts(String color) {
        ArrayList list = this.partMap.get(color);
        return list == null ? new ArrayList() : list;
    }

    public ColorValuePart getPart(String color, int sequence) {
        List<ColorValuePart> list = this.partMap.get(color);
        if (list != null) {
            int listSize = list.size();
            int i = 0;
            while (i < listSize) {
                ColorValuePart c = list.get(i);
                if (c.getSequence() == sequence) {
                    return c;
                }
                ++i;
            }
        }
        return null;
    }

    public List<ColorValuePart> getParts(String color, int sequenceStart, int sequenceEnd) {
        ArrayList<ColorValuePart> sequenceList = new ArrayList<ColorValuePart>();
        List<ColorValuePart> list = this.partMap.get(color);
        if (list != null) {
            for (ColorValuePart part : list) {
                int sequence = part.getSequence();
                if (sequence < sequenceStart || sequence > sequenceEnd) continue;
                sequenceList.add(part);
            }
        }
        return sequenceList;
    }

    public int getStartSequence(String color) {
        List<ColorValuePart> list = this.partMap.get(color);
        if (list != null && !list.isEmpty()) {
            return list.get(0).getSequence();
        }
        return -1;
    }

    public int getEndSequence(String color) {
        List<ColorValuePart> list = this.partMap.get(color);
        if (list != null && !list.isEmpty()) {
            return list.get(list.size() - 1).getSequence();
        }
        return -1;
    }

    @Override
    public ImageIcon getImage() {
        int distance = 20;
        String[] color = this.getColors();
        ImageIcon[] imgList = new ImageIcon[color.length];
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < imgList.length) {
            Object[] parts = this.getParts(color[i]).toArray(new Part[0]);
            Arrays.sort(parts);
            if (parts.length > 0) {
                ImageIcon img;
                imgList[i] = img = ((Part)parts[0]).getImage();
                if (img != null) {
                    width += distance;
                    if (img.getIconHeight() > height) {
                        height = img.getIconHeight();
                    }
                    if (i == imgList.length - 1) {
                        width += img.getIconWidth();
                    }
                }
            }
            ++i;
        }
        BufferedImage imgBuf = new BufferedImage(width, height, 2);
        Graphics2D g2 = imgBuf.createGraphics();
        int xpos = 0;
        int i2 = 0;
        while (i2 < imgList.length) {
            if (imgList[i2] != null) {
                g2.drawImage(imgList[i2].getImage(), xpos, 0, imgList[i2].getImageObserver());
                xpos += distance;
            }
            ++i2;
        }
        return new ImageIcon(imgBuf);
    }
}

