/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed;

import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseMultiTextPanel;
import hgb.gui.HGBasePanel;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameManager;
import tjger.gui.completed.Card;
import tjger.gui.completed.Piece;
import tjger.lib.ImageUtil;
import tjger.lib.PartUtil;
import tjger.lib.PlayerUtil;

public class PlayerInfoPanel
extends HGBasePanel {
    private static final long serialVersionUID = 854371087L;
    public static final int TYPE = 1;
    public static final int ICON = 2;
    public static final int NAME = 4;
    public static final int TURN = 8;
    public static final int ROUND = 16;
    public static final int SCORE = 32;
    public static final int GAMES = 64;
    public static final int WON = 128;
    public static final int PIECE = 256;
    public static final int NAMETYPE = 512;
    private final GameManager manager;
    private final GameConfig config;
    private HGBaseMultiTextPanel pnPlayer;
    private int indexType = -1;
    private int indexIcon = -1;
    private int indexPiece = -1;
    private int indexName = -1;
    private int indexNameType = -1;
    private int indexScoreTurn = -1;
    private int indexScoreRound = -1;
    private int indexScoreGame = -1;
    private int indexGames = -1;
    private int indexWon = -1;
    private int panelHeight;
    private int fields;

    public PlayerInfoPanel(GamePlayer player, int fields, int panelHeight) {
        super(new BorderLayout());
        this.fields = fields;
        this.panelHeight = panelHeight;
        this.manager = GameManager.getInstance();
        this.config = this.manager.getGameConfig();
        this.createRow();
        this.setInformation(player);
        this.actualizeText();
    }

    @Override
    public void actualizeText() {
        if (this.indexScoreTurn >= 0) {
            this.pnPlayer.getLabel(this.indexScoreTurn).setToolTipText(HGBaseText.getText("tooltip.scoreturn", new String[0]));
        }
        if (this.indexScoreRound >= 0) {
            this.pnPlayer.getLabel(this.indexScoreRound).setToolTipText(HGBaseText.getText("tooltip.scoreround", new String[0]));
        }
        if (this.indexScoreGame >= 0) {
            this.pnPlayer.getLabel(this.indexScoreGame).setToolTipText(HGBaseText.getText("tooltip.scoregame", new String[0]));
        }
        if (this.indexGames >= 0) {
            this.pnPlayer.getLabel(this.indexGames).setToolTipText(HGBaseText.getText("tooltip.gamesplayed", new String[0]));
        }
        if (this.indexWon >= 0) {
            this.pnPlayer.getLabel(this.indexWon).setToolTipText(HGBaseText.getText("tooltip.gameswon", new String[0]));
        }
    }

    private int[] getPanelWidths() {
        int imgWidth = HGBaseGuiTools.getFieldHeight() + 10;
        int showIndex = 0;
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(5);
        ++showIndex;
        if ((this.fields & 1) == 1) {
            list.add(imgWidth);
            this.indexType = showIndex++;
        }
        if ((this.fields & 2) == 2) {
            list.add(imgWidth);
            list.add(10);
            this.indexIcon = showIndex;
            showIndex += 2;
        }
        if ((this.fields & 0x100) == 256) {
            list.add(imgWidth);
            list.add(10);
            this.indexPiece = showIndex;
            showIndex += 2;
        }
        if ((this.fields & 4) == 4) {
            list.add(0);
            this.indexName = showIndex++;
        }
        if ((this.fields & 0x200) == 512) {
            list.add(0);
            this.indexNameType = showIndex++;
        }
        if ((this.fields & 8) == 8) {
            list.add(50);
            this.indexScoreTurn = showIndex++;
        }
        if ((this.fields & 0x10) == 16) {
            list.add(50);
            this.indexScoreRound = showIndex++;
        }
        if ((this.fields & 0x20) == 32) {
            list.add(50);
            this.indexScoreGame = showIndex++;
        }
        if ((this.fields & 0x40) == 64) {
            list.add(32);
            this.indexGames = showIndex++;
        }
        if ((this.fields & 0x80) == 128) {
            list.add(32);
            this.indexWon = showIndex++;
        }
        list.add(5);
        ++showIndex;
        return HGBaseTools.toIntArray(list);
    }

    private void createRow() {
        int[] pnWidths = this.getPanelWidths();
        this.pnPlayer = new HGBaseMultiTextPanel(pnWidths, this.panelHeight, false, false, true, false);
        this.setRightAlignment(this.indexScoreTurn);
        this.setRightAlignment(this.indexScoreRound);
        this.setRightAlignment(this.indexScoreGame);
        this.setRightAlignment(this.indexGames);
        this.setRightAlignment(this.indexWon);
        this.pnPlayer.setOpaque(false);
        this.add((Component)this.pnPlayer, "Center");
    }

    private void setRightAlignment(int index) {
        if (index >= 0) {
            this.pnPlayer.getLabel(index).setHorizontalAlignment(4);
        }
    }

    public void setInformation(GamePlayer player) {
        if (player == null) {
            this.resetInformation();
        } else {
            ImageIcon pieceImage = null;
            String playerColor = player.getPieceColor();
            Piece[] pieces = PartUtil.getPiecesWithColor(playerColor);
            if (pieces.length > 0) {
                pieceImage = pieces[0].getImage();
            } else {
                Card[] cards = PartUtil.getCardsWithColor(playerColor);
                if (cards.length > 0) {
                    pieceImage = cards[0].getImage();
                }
            }
            String nameType = PlayerUtil.getPlayerNameType(player);
            this.setInformation(player.getImage(), pieceImage, player.getName(), nameType, player.getType().getImage(), player.getScore(1), player.getScore(2), player.getScore(4), player.getGamesPlayed(), player.getGamesWon());
        }
    }

    public void resetInformation() {
        this.setInformation(null, null, "", "", null, -2147483631, -2147483631, -2147483631, -2147483631, -2147483631);
    }

    private void setInformation(ImageIcon iconPlayer, ImageIcon iconPiece, String playerName, String nameType, ImageIcon iconType, int scoreTurn, int scoreRound, int scoreGame, int gamesPlayed, int gamesWon) {
        if (this.indexIcon >= 0 && iconPlayer != null) {
            ImageUtil.setImageOnLabel(this.pnPlayer.getLabel(this.indexIcon), iconPlayer);
        }
        if (this.indexPiece >= 0) {
            ImageUtil.setImageOnLabel(this.pnPlayer.getLabel(this.indexPiece), iconPiece);
        }
        if (this.indexName >= 0) {
            this.pnPlayer.getLabel(this.indexName).setText(playerName);
            this.pnPlayer.getLabel(this.indexName).setToolTipText(playerName.length() == 0 ? null : playerName);
        }
        if (this.indexNameType >= 0) {
            this.pnPlayer.getLabel(this.indexNameType).setText(nameType);
            this.pnPlayer.getLabel(this.indexNameType).setToolTipText(nameType.length() == 0 ? null : nameType);
        }
        if (this.indexType >= 0) {
            ImageUtil.setImageOnLabel(this.pnPlayer.getLabel(this.indexType), iconType);
        }
        if (this.indexScoreTurn >= 0) {
            this.pnPlayer.getLabel(this.indexScoreTurn).setText(this.getValueText(scoreTurn));
        }
        if (this.indexScoreRound >= 0) {
            this.pnPlayer.getLabel(this.indexScoreRound).setText(this.getValueText(scoreRound));
        }
        if (this.indexScoreGame >= 0) {
            this.pnPlayer.getLabel(this.indexScoreGame).setText(this.getValueText(scoreGame));
        }
        if (this.indexGames >= 0) {
            this.pnPlayer.getLabel(this.indexGames).setText(this.getValueText(gamesPlayed));
        }
        if (this.indexWon >= 0) {
            this.pnPlayer.getLabel(this.indexWon).setText(this.getValueText(gamesWon));
        }
    }

    private String getValueText(int value) {
        if (value == -2147483631) {
            return "";
        }
        return String.valueOf(value);
    }
}

