/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed.playingfield;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseTools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.ImageIcon;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.game.completed.playingfield.SingleFieldConnection;
import tjger.gui.GamePanel;
import tjger.gui.completed.Part;
import tjger.gui.completed.playingfield.ConnectionLinePainter;
import tjger.gui.completed.playingfield.ConnectionPainter;
import tjger.gui.completed.playingfield.SingleFieldAreaPainter;
import tjger.gui.completed.playingfield.SingleFieldPainter;

public class PlayingFieldPaintUtil {
    public static final Color DEFAULT_SELECTION_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.5f);

    private PlayingFieldPaintUtil() {
    }

    public static void drawAllFields(PlayingField field, SingleFieldPainter painter, GamePanel panel, Graphics g) {
        for (SingleField sf : field.getFields()) {
            painter.drawSingleField(field, sf, panel, g);
        }
    }

    public static void drawAllFields(PlayingField field, Color border, Color fill, GamePanel panel, Graphics g) {
        SingleFieldAreaPainter painter = new SingleFieldAreaPainter(border, fill);
        for (SingleField sf : field.getFields()) {
            painter.drawSingleField(field, sf, panel, g);
        }
    }

    public static void drawSingleField(PlayingField playField, SingleField field, Color border, Color fill, GamePanel panel, Graphics g) {
        SingleFieldAreaPainter painter = new SingleFieldAreaPainter(border, fill);
        painter.drawSingleField(playField, field, panel, g);
    }

    public static void drawSingleFieldSelected(PlayingField playField, SingleField field, GamePanel panel, Graphics g) {
        PlayingFieldPaintUtil.drawSingleFieldSelected(playField, field, DEFAULT_SELECTION_COLOR, panel, g);
    }

    public static void drawSingleFieldSelected(PlayingField playField, SingleField field, Color selection, GamePanel panel, Graphics g) {
        PlayingFieldPaintUtil.drawSingleField(playField, field, null, selection, panel, g);
    }

    public static void drawSingleField(PlayingField playField, SingleField field, int percentSize, ImageIcon img, GamePanel panel, Graphics g) {
        if (img != null) {
            Point center = HGBaseGuiTools.getCenterOfPolygon(playField.getPixelPositions(field));
            int diffX = (int)((double)(img.getIconWidth() * percentSize) / 200.0);
            int diffY = (int)((double)(img.getIconHeight() * percentSize) / 200.0);
            panel.drawImage(center.x - diffX, center.y - diffY, percentSize, img, g);
        }
    }

    public static void drawSingleField(PlayingField playField, SingleField field, int percentSize, Part part, GamePanel panel, Graphics g) {
        if (part != null) {
            Point center = HGBaseGuiTools.getCenterOfPolygon(playField.getPixelPositions(field));
            ImageIcon img = part.getImage();
            int diffX = (int)((double)(img.getIconWidth() * percentSize) / 200.0);
            int diffY = (int)((double)(img.getIconHeight() * percentSize) / 200.0);
            panel.drawPart(center.x - diffX, center.y - diffY, percentSize, part, g);
        }
    }

    public static void drawAllConnections(PlayingField field, ConnectionPainter painter, GamePanel panel, Graphics g) {
        for (SingleFieldConnection connection : PlayingFieldPaintUtil.getConnectionsBetweenFields(field)) {
            painter.drawConnection(field, (SingleField)connection.getFirst(), (SingleField)connection.getSecond(), panel, g);
        }
    }

    public static void drawAllConnections(PlayingField field, Color color, int size, GamePanel panel, Graphics g) {
        ConnectionLinePainter painter = new ConnectionLinePainter(color, size);
        PlayingFieldPaintUtil.drawAllConnections(field, painter, panel, g);
    }

    public static Collection<SingleFieldConnection> getConnectionsBetweenFields(PlayingField field) {
        HashSet<SingleFieldConnection> connections = new HashSet<SingleFieldConnection>();
        for (SingleField sf1 : field.getFields()) {
            for (SingleField sf2 : field.getNeighbours(sf1)) {
                if (connections.contains(new SingleFieldConnection(sf2, sf1))) continue;
                connections.add(new SingleFieldConnection(sf1, sf2));
            }
        }
        return Collections.unmodifiableCollection(connections);
    }

    public static void drawConnectionLine(PlayingField playField, SingleField field1, SingleField field2, Color color, int size, GamePanel panel, Graphics g) {
        g.setColor(color);
        if (size == 1) {
            Point center1 = HGBaseGuiTools.getCenterOfPolygon(playField.getPixelPositions(field1));
            Point center2 = HGBaseGuiTools.getCenterOfPolygon(playField.getPixelPositions(field2));
            panel.drawLine(center1.x, center1.y, center2.x, center2.y, g);
        } else {
            Polygon polygon = PlayingFieldPaintUtil.getPolygonForConnection(playField, field1, field2, size);
            panel.drawPolygon(polygon, true, g);
        }
    }

    public static Polygon getPolygonForConnection(PlayingField playField, SingleField field1, SingleField field2, int size) {
        HGBaseTools.checkCondition(size >= 1, "The size of the connection must not lower than 1!");
        Point center1 = HGBaseGuiTools.getCenterOfPolygon(playField.getPixelPositions(field1));
        Point center2 = HGBaseGuiTools.getCenterOfPolygon(playField.getPixelPositions(field2));
        boolean horizontal = Math.abs(center1.y - center2.y) <= Math.abs(center1.x - center2.x);
        boolean vertical = !horizontal;
        int diff1 = size / 2;
        int diff2 = HGBaseTools.isEven(size) ? Math.max(diff1 - 1, 0) : diff1;
        int diffX1 = horizontal ? 0 : diff1;
        int diffX2 = horizontal ? 0 : diff2;
        int diffY1 = vertical ? 0 : diff1;
        int diffY2 = vertical ? 0 : diff2;
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(center1.x - diffX1, center1.y - diffY1));
        points.add(new Point(center1.x + diffX2, center1.y + diffY2));
        points.add(new Point(center2.x + diffX2, center2.y + diffY2));
        points.add(new Point(center2.x - diffX1, center2.y - diffY1));
        return HGBaseGuiTools.createPolygon(points.toArray(new Point[points.size()]));
    }

    public static void drawConnectionArrow(PlayingField playField, SingleField start, SingleField target, Color color, int size, GamePanel panel, Graphics g) {
        PlayingFieldPaintUtil.drawConnectionLine(playField, start, target, color, size, panel, g);
        g.setColor(color);
        Point center1 = HGBaseGuiTools.getCenterOfPolygon(playField.getPixelPositions(start));
        Point center2 = HGBaseGuiTools.getCenterOfPolygon(playField.getPixelPositions(target));
        panel.drawArrow(center1.x, center1.y, center2.x, center2.y, (int)((float)size * 1.5f), g);
    }
}

