/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseHTMLPage;
import hgb.gui.config.HGBaseConfigCheckBox;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import tjger.gui.GameDialogs;

public class HintPanel
extends JPanel {
    private static final long serialVersionUID = 4841874111202825802L;
    private GameDialogs gameDialog;
    private URL[] hintUrls;
    private int numHints;
    private int indexShow;
    private JLabel labelPosition;
    private JButton btNext;
    private JButton btPrev;
    private HGBaseHTMLPage htmlPage;

    public HintPanel(GameDialogs gameDialog, URL[] hintUrls) {
        super(new BorderLayout());
        this.gameDialog = gameDialog;
        this.hintUrls = HGBaseTools.clone(hintUrls);
        this.numHints = hintUrls.length;
        try {
            this.indexShow = gameDialog.getIndexOfIntialHint(this.numHints - 1);
            this.htmlPage = gameDialog.createHtmlPageForHint(hintUrls[this.indexShow]);
            this.htmlPage.setOpaque(true);
            JScrollPane scrollHtml = HGBaseGuiTools.createScrollPane(this.htmlPage, 0, 0, false);
            this.add((Component)scrollHtml, "Center");
            JPanel pnBottom = new JPanel(new BorderLayout());
            this.add((Component)pnBottom, "South");
            pnBottom.setBorder(new EmptyBorder(7, 7, 7, 7));
            if (!HGBaseSettings.getBoolean("hideNotShowAgainHintOption")) {
                HGBaseConfigCheckBox chkNotAgain = new HGBaseConfigCheckBox("dlg.notshowagain", "hint.dontshow");
                pnBottom.add((Component)chkNotAgain, "Center");
            }
            JPanel pnNavigation = new JPanel(new BorderLayout());
            this.btPrev = new JButton();
            ImageIcon imgPrev = HGBaseGuiTools.loadImage("/tjger/gui/gfx/prev.png");
            if (imgPrev != null) {
                this.btPrev.setIcon(imgPrev);
            } else {
                this.btPrev.setText("<<");
            }
            this.btPrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    HintPanel.this.showAnotherPage(-1);
                }
            });
            pnNavigation.add((Component)this.btPrev, "West");
            this.btNext = new JButton();
            ImageIcon imgNext = HGBaseGuiTools.loadImage("/tjger/gui/gfx/next.png");
            if (imgNext != null) {
                this.btNext.setIcon(imgNext);
            } else {
                this.btNext.setText("<<");
            }
            this.btNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    HintPanel.this.showAnotherPage(1);
                }
            });
            pnNavigation.add((Component)this.btNext, "East");
            this.labelPosition = new JLabel();
            pnNavigation.add((Component)this.labelPosition, "Center");
            pnBottom.add((Component)pnNavigation, "East");
            this.checkState();
        }
        catch (IOException e) {
            HGBaseLog.logError(e.getMessage());
        }
    }

    private void showAnotherPage(int step) {
        int newIndex = this.indexShow + step;
        if (newIndex >= 0 && newIndex < this.numHints) {
            try {
                this.gameDialog.showAnotherHtmlPageForHint(this.htmlPage, this.hintUrls[newIndex]);
                this.indexShow = newIndex;
            }
            catch (IOException e) {
                HGBaseLog.logWarn("Could not show hint: " + e.getMessage());
            }
            this.checkState();
        }
    }

    private void checkState() {
        this.labelPosition.setText("   " + (this.indexShow + 1) + " / " + this.numHints + "   ");
        this.btPrev.setEnabled(this.indexShow > 0);
        this.btNext.setEnabled(this.indexShow < this.numHints - 1);
    }
}

