/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import hgb.gui.config.HGBaseConfigColorChooser;
import hgb.gui.config.HGBaseConfigComboBox;
import hgb.gui.config.HGBaseConfigDialog;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.internal.IntBooleanStringMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import tjger.game.completed.GameConfig;
import tjger.gui.GameDialogs;
import tjger.gui.GamePanel;
import tjger.gui.completed.Arrangement;
import tjger.gui.completed.Background;
import tjger.gui.completed.Board;
import tjger.gui.completed.CardSet;
import tjger.gui.completed.Cover;
import tjger.gui.completed.Part;
import tjger.gui.completed.PieceSet;
import tjger.gui.internal.GameDialogFactory;

public class PartsDlg
extends HGBaseConfigDialog {
    private static final int LABEL_WIDTH = HGBaseSettings.getInt("partsDlgLabelWidth", 120);
    private static final int COMBO_WIDTH = HGBaseSettings.getInt("partsDlgComboWidth", 150);
    private static final int BUTTON_WIDTH = 24;
    private static final int PREVIEW_WIDTH = LABEL_WIDTH + COMBO_WIDTH;
    private static final int PREVIEW_HEIGHT = (int)((double)PREVIEW_WIDTH * 0.6);
    private static final UserDefinedArrangement ARRANGE_USERDEFINED = new UserDefinedArrangement();
    private PartsComboBox[] configComboList;
    private HGBaseConfigColorChooser[] configColorList;
    private static GamePanel pnPreview;
    private JButton btBackColor;
    private Color newBackColor;
    private boolean completeArrangement;
    private boolean onChangeArrangement = false;
    private final IntBooleanStringMap indexMapStandard = new IntBooleanStringMap();
    private final IntBooleanStringMap indexMapUserDef = new IntBooleanStringMap();
    private final String[] userParts;
    private final String[] userPartSets;
    private final String[] cardSetTypes;
    private final String[] colorTypes;

    public PartsDlg(HGBaseFrame mainFrame) {
        super(mainFrame, HGBaseText.getText("settings.parts", new String[0]).replace('.', ' '));
        GameConfig config = GameConfig.getInstance();
        this.cardSetTypes = config.getCardSetTypes();
        this.userParts = config.getPartTypes();
        this.userPartSets = config.getPartSetTypes();
        this.colorTypes = config.getColorTypes();
    }

    @Override
    protected void createComponents(HGBasePanel pnDialog) {
        GameConfig config = GameConfig.getInstance();
        this.completeArrangement = config.isCompleteArrangement() && config.getArrangements().length > 0;
        ArrayList<PartsComboBox> cbList = new ArrayList<PartsComboBox>();
        this.addComboBox("game.arrangement", config.getArrangements(), config.getActiveArrangement(), cbList, true);
        this.addComboBox("game.background", config.getBackgrounds(), config.getActiveBackground(), cbList, true);
        this.addComboBox("game.board", config.getBoards(), config.getActiveBoard(), cbList, true);
        this.addComboBox("game.cover", config.getCovers(), config.getActiveCover(), cbList, true);
        int i = 0;
        while (i < this.cardSetTypes.length) {
            String cardType = this.cardSetTypes[i];
            this.addComboBox(cardType, config.getCardSets(cardType), config.getActiveCardSet(cardType), cbList, true);
            ++i;
        }
        this.addComboBox("game.pieceset", config.getPieceSets(), config.getActivePieceSet(), cbList, true);
        i = 0;
        while (i < this.userPartSets.length) {
            this.addComboBox(this.userPartSets[i], config.getPartSets(this.userPartSets[i]), config.getActivePartSet(this.userPartSets[i]), cbList, false);
            ++i;
        }
        i = 0;
        while (i < this.userParts.length) {
            this.addComboBox(this.userParts[i], config.getParts(this.userParts[i]), config.getActivePart(this.userParts[i]), cbList, false);
            ++i;
        }
        ArrayList<HGBaseConfigColorChooser> ccList = new ArrayList<HGBaseConfigColorChooser>();
        int i2 = 0;
        while (i2 < this.colorTypes.length) {
            String colorType = this.colorTypes[i2];
            this.addColorChooser(colorType, config.getDefaultColor(colorType), config.getActiveColor(colorType), ccList);
            ++i2;
        }
        this.configComboList = cbList.toArray(new PartsComboBox[cbList.size()]);
        this.configColorList = ccList.toArray(new HGBaseConfigColorChooser[ccList.size()]);
        JPanel pnCombo = new JPanel(new GridLayout(this.configComboList.length + this.configColorList.length + 1, 2));
        int i3 = 0;
        while (i3 < this.configComboList.length) {
            JPanel pnPart = this.createPartPanelWithLabel(this.configComboList[i3].getId());
            pnPart.add(this.configComboList[i3]);
            if (i3 == this.indexOf("game.background", true)) {
                this.addBackgroundColorButton(pnPart);
            }
            pnCombo.add(pnPart);
            ++i3;
        }
        i3 = 0;
        while (i3 < this.configColorList.length) {
            HGBaseConfigColorChooser ccPanel = this.configColorList[i3];
            JPanel pnPart = this.createPartPanelWithLabel(this.configColorList[i3].getOption());
            ccPanel.getLabel().setPreferredSize(new Dimension(COMBO_WIDTH, HGBaseGuiTools.getFieldHeight()));
            ccPanel.getButton().setPreferredSize(new Dimension(24, HGBaseGuiTools.getFieldHeight()));
            pnPart.add(ccPanel);
            pnCombo.add(pnPart);
            ++i3;
        }
        pnCombo.add(new JPanel());
        this.changeArrangement();
        GameDialogs dlg = GameDialogFactory.getInstance().createGameDialogs();
        pnPreview = dlg.getPreviewPanel(this, PREVIEW_WIDTH, PREVIEW_HEIGHT);
        if (pnPreview != null) {
            pnPreview.setPreferredSize(new Dimension(PREVIEW_WIDTH, PREVIEW_HEIGHT));
            pnPreview.setBorder(new LineBorder(Color.BLACK, 1));
            pnDialog.add((Component)pnPreview, "Center");
        }
        pnDialog.add((Component)pnCombo, "North");
    }

    private JPanel createPartPanelWithLabel(String textId) {
        JPanel pnPart = new JPanel(new FlowLayout(0));
        JLabel lbPart = new JLabel(String.valueOf(HGBaseText.getText(textId, new String[0])) + ":");
        lbPart.setPreferredSize(new Dimension(LABEL_WIDTH, HGBaseGuiTools.getFieldHeight()));
        pnPart.add(lbPart);
        return pnPart;
    }

    private void addBackgroundColorButton(JPanel pnPart) {
        this.btBackColor = new JButton("...");
        this.btBackColor.setPreferredSize(new Dimension(24, HGBaseGuiTools.getFieldHeight()));
        this.btBackColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Color color;
                Background back = PartsDlg.this.getSelectedBackground();
                if (back != null && back.getColor() != null && (color = JColorChooser.showDialog(PartsDlg.this.getMainFrame(), HGBaseText.getText("dlg.choosecolor", new String[0]), back.getOriginalColor())) != null) {
                    PartsDlg.this.newBackColor = color;
                    if (pnPreview != null) {
                        pnPreview.repaint();
                    }
                }
            }
        });
        this.testBackColorButton(this.getSelectedBackground());
        pnPart.add(this.btBackColor);
    }

    public int indexOf(String id, boolean standardType) {
        return standardType ? this.indexMapStandard.getInt(id) : this.indexMapUserDef.getInt(id);
    }

    public int indexOfColorChooser(String id) {
        return this.indexMapUserDef.getInt(id);
    }

    private void changeArrangement() {
        Arrangement a = this.getSelectedArrangement();
        if (a != null) {
            this.onChangeArrangement = true;
            this.changePartOfArrangement(this.indexOf("game.background", true), a.getBackground());
            this.changePartOfArrangement(this.indexOf("game.board", true), a.getBoard());
            this.changePartOfArrangement(this.indexOf("game.pieceset", true), a.getPieceSet());
            this.changePartOfArrangement(this.indexOf("game.cover", true), a.getCover());
            int i = 0;
            while (i < this.cardSetTypes.length) {
                this.changePartOfArrangement(this.indexOf(this.cardSetTypes[i], true), a.getCardSet(this.cardSetTypes[i]));
                ++i;
            }
            i = 0;
            while (i < this.userParts.length) {
                this.changePartOfArrangement(this.indexOf(this.userParts[i], false), a.getPart(this.userParts[i]));
                ++i;
            }
            i = 0;
            while (i < this.userPartSets.length) {
                this.changePartOfArrangement(this.indexOf(this.userPartSets[i], false), a.getPartSet(this.userPartSets[i]));
                ++i;
            }
            i = 0;
            while (i < this.colorTypes.length) {
                Color c = a.getColor(this.colorTypes[i]);
                if (c != null) {
                    this.configColorList[i].setColor(c);
                }
                ++i;
            }
            this.onChangeArrangement = false;
        }
    }

    private void changePartOfArrangement(int index, Part part) {
        if (part != null && index >= 0) {
            this.configComboList[index].setSelectedItem(part);
        }
    }

    public Arrangement getSelectedArrangement() {
        Object oSel;
        if (this.indexOf("game.arrangement", true) >= 0 && (oSel = this.configComboList[this.indexOf("game.arrangement", true)].getSelectedItem()) instanceof Arrangement) {
            return (Arrangement)oSel;
        }
        return null;
    }

    public Background getSelectedBackground() {
        if (this.indexOf("game.background", true) >= 0) {
            return (Background)this.getSelectedPart(this.indexOf("game.background", true));
        }
        return null;
    }

    public Board getSelectedBoard() {
        if (this.indexOf("game.board", true) >= 0) {
            return (Board)this.getSelectedPart(this.indexOf("game.board", true));
        }
        return null;
    }

    public Part getSelectedPart(int index) {
        return (Part)this.configComboList[index].getSelectedItem();
    }

    public Color getSelectedColor(int index) {
        return this.configColorList[index].getColor();
    }

    public Color getBackgroundColor() {
        return this.newBackColor;
    }

    private void addComboBox(String id, Part[] parts, Part activePart, List<PartsComboBox> cbList, boolean standardType) {
        if ((parts = this.getOnlyVisible(parts)).length > 0) {
            JComboBox<Part> cbHelp = HGBaseGuiTools.createArrayComboBox(parts, COMBO_WIDTH, HGBaseGuiTools.getFieldHeight());
            if (id.equals("game.arrangement") && !this.completeArrangement) {
                cbHelp.addItem(ARRANGE_USERDEFINED);
            }
            PartsComboBox cbPart = new PartsComboBox(id, id, cbHelp);
            cbList.add(cbPart);
            try {
                if (activePart != null) {
                    cbPart.setSelectedItem(activePart);
                }
            }
            catch (Exception ex) {
                HGBaseLog.logWarn("Exception at addComboBox: " + ex.getMessage());
            }
            if (cbPart.getItemCount() == 1) {
                cbPart.setEnabled(false);
            }
            cbPart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (ev.getSource() instanceof PartsComboBox) {
                        PartsComboBox cb = (PartsComboBox)ev.getSource();
                        Object select = cb.getSelectedItem();
                        if (select instanceof Background) {
                            PartsDlg.this.testBackColorButton((Background)select);
                        }
                        if (select instanceof Arrangement) {
                            PartsDlg.this.changeArrangement();
                        } else {
                            PartsDlg.this.testChangedArrangement(PartsDlg.this.getSelectedArrangement());
                        }
                        if (pnPreview != null) {
                            pnPreview.repaint();
                        }
                    }
                }
            });
            if (this.completeArrangement && !id.equals("game.arrangement")) {
                cbPart.setEnabled(false);
            }
            IntBooleanStringMap indexMap = standardType ? this.indexMapStandard : this.indexMapUserDef;
            indexMap.set(id, cbList.indexOf(cbPart));
        }
    }

    private void addColorChooser(String colorType, Color defaultColor, Color activeColor, List<HGBaseConfigColorChooser> ccList) {
        HGBaseConfigColorChooser ccColor = new HGBaseConfigColorChooser(colorType, defaultColor);
        if (activeColor != null) {
            ccColor.setColor(activeColor);
        }
        ccList.add(ccColor);
        ccColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PartsDlg.this.testChangedArrangement(PartsDlg.this.getSelectedArrangement());
            }
        });
        this.indexMapUserDef.set(colorType, ccList.indexOf(ccColor));
    }

    private Part[] getOnlyVisible(Part[] parts) {
        ArrayList<Part> visibleList = new ArrayList<Part>();
        int i = 0;
        while (i < parts.length) {
            if (!parts[i].isHidden()) {
                visibleList.add(parts[i]);
            }
            ++i;
        }
        return visibleList.toArray(new Part[visibleList.size()]);
    }

    protected void testChangedArrangement(Arrangement arrange) {
        if (!this.onChangeArrangement && this.indexOf("game.arrangement", true) >= 0 && !this.isGivenArrangement(arrange)) {
            GameConfig config = GameConfig.getInstance();
            int selIndex = -1;
            Arrangement[] all = config.getArrangements();
            int i = 0;
            while (all != null && i < all.length && selIndex == -1) {
                if (this.isGivenArrangement(all[i])) {
                    selIndex = i;
                }
                ++i;
            }
            if (all == null || selIndex == -1) {
                this.configComboList[this.indexOf("game.arrangement", true)].setSelectedItem(ARRANGE_USERDEFINED);
            } else {
                this.configComboList[this.indexOf("game.arrangement", true)].setSelectedItem(all[selIndex]);
            }
        }
    }

    private boolean isGivenArrangement(Arrangement arrange) {
        if (arrange == null) {
            return false;
        }
        Background back = arrange.getBackground();
        Board board = arrange.getBoard();
        PieceSet piece = arrange.getPieceSet();
        Cover cover = arrange.getCover();
        if (!(this.isPartOk(back, this.indexOf("game.background", true)) && this.isPartOk(board, this.indexOf("game.board", true)) && this.isPartOk(piece, this.indexOf("game.pieceset", true)) && this.isPartOk(cover, this.indexOf("game.cover", true)))) {
            return false;
        }
        int i = 0;
        while (i < this.cardSetTypes.length) {
            CardSet cards = arrange.getCardSet(this.cardSetTypes[i]);
            if (!this.isPartOk(cards, this.indexOf(this.cardSetTypes[i], true))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.userParts.length) {
            if (!this.isPartOk(arrange.getPart(this.userParts[i]), this.indexOf(this.userParts[i], false))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.userPartSets.length) {
            if (!this.isPartOk(arrange.getPartSet(this.userPartSets[i]), this.indexOf(this.userPartSets[i], false))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.colorTypes.length) {
            Color c = arrange.getColor(this.colorTypes[i]);
            if (c != null && !c.equals(this.configColorList[i].getColor())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isPartOk(Part arrangementPart, int index) {
        return arrangementPart == null || index <= 0 || arrangementPart.equals(this.configComboList[index].getSelectedItem());
    }

    protected void testBackColorButton(Background back) {
        this.newBackColor = null;
        if (back != null && this.btBackColor != null) {
            this.btBackColor.setEnabled(!back.isFixedColor() && back.getColor() != null);
        }
    }

    @Override
    protected void okPressed() {
        Background back;
        int i = 0;
        while (this.configComboList != null && i < this.configComboList.length) {
            this.configComboList[i].setEnabled(true);
            ++i;
        }
        super.okPressed();
        if (this.newBackColor != null && (back = this.getSelectedBackground()) != null) {
            int rgb = this.newBackColor.getRGB();
            HGBaseConfig.set("game.backcolor." + back.getName(), rgb);
        }
    }

    private static class PartsComboBox
    extends HGBaseConfigComboBox<Part> {
        public PartsComboBox(String id, String option, JComboBox<Part> box) {
            super(id, option, box);
        }
    }

    private static class UserDefinedArrangement
    extends Part {
        private static final String USERDEFINED = "arrangement.userdefined";

        public UserDefinedArrangement() {
            super(USERDEFINED, USERDEFINED, null, false);
        }
    }
}

