/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.xml.HGBaseXMLTools;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.completed.GameEngine;
import tjger.lib.AiMoveInformation;

public class AiAnalyzer {
    private Document doc = HGBaseXMLTools.createDocument();
    private static String additionalEvaluationInformation = "";

    public void writeXML(File file) {
        if (this.doc != null) {
            HGBaseXMLTools.writeXML(this.doc, file.getPath());
        }
    }

    protected String getRootNodeName() {
        return "analysis";
    }

    protected String getStepNodeName() {
        return "step";
    }

    protected String getEvaluationNodeName() {
        return "evaluation";
    }

    protected String getValidMoveNodeName() {
        return "vmove";
    }

    protected String getInvalidMoveNodeName() {
        return "imove";
    }

    protected String getDepthAttributeName() {
        return "depth";
    }

    protected String getStepAttributeName() {
        return "step";
    }

    protected String getMaximumAttributeName() {
        return "max";
    }

    protected String getPlayerAttributeName() {
        return "player";
    }

    protected String getMoveAttributeName() {
        return "move";
    }

    protected String getStateAttributeName() {
        return "state";
    }

    protected String getStateBeforeAttributeName() {
        return "stateBefore";
    }

    protected String getStateAfterAttributeName() {
        return "stateAfter";
    }

    protected String getEvaluationValueAttributeName() {
        return "value";
    }

    protected String getCountEvaluationsAttributeName() {
        return "countEvaluations";
    }

    protected String getDurationAttributeName() {
        return "duration";
    }

    protected String getStartTimestampAttributeName() {
        return "startTimestamp";
    }

    protected String getStopTimestampAttributeName() {
        return "stopTimestamp";
    }

    protected String getBestMoveAttributeName() {
        return "bestMove";
    }

    protected String getMoveShortInfoAttributeName() {
        return "moveShort";
    }

    public String getMoveIdAttributeName() {
        return "moveId";
    }

    protected String getBestMoveFlagAttributeName() {
        return "isBestMove";
    }

    protected String getChosenMoveFlagAttributeName() {
        return "isChosenMove";
    }

    protected String getAdditionalInformationAttributeName() {
        return "additionalInformation";
    }

    protected String getAlphaAttributeName() {
        return "alpha";
    }

    protected String getBetaAttributeName() {
        return "beta";
    }

    protected String getNoBestMovesAttributeName() {
        return "noBestMoves";
    }

    protected String getPlayerInformation(GamePlayer player) {
        return player.toString();
    }

    protected String getStateInformation(GameState state) {
        return state.toString();
    }

    protected String getMoveInformation(AiMoveInformation move) {
        return move != null ? move.toString() : "";
    }

    protected String getMoveShortInformation(AiMoveInformation move) {
        return this.getMoveInformation(move);
    }

    public String getMoveIdInformation(AiMoveInformation move) {
        return String.valueOf(move.hashCode());
    }

    public static void setAdditionalEvaluationInformation(String additionalInformation) {
        additionalEvaluationInformation = additionalInformation;
    }

    protected String getAdditionalEvaluationInformation() {
        return additionalEvaluationInformation;
    }

    protected String getTimestampFormat() {
        return "dd.MM.yyyy HH:mm:ss.SSS";
    }

    protected String formatTimestamp(Date timestamp) {
        return new SimpleDateFormat(this.getTimestampFormat()).format(timestamp);
    }

    private void appendChild(Node parentNode, Node childNode) {
        if (parentNode != null) {
            parentNode.appendChild(childNode);
        } else {
            this.doc.appendChild(childNode);
        }
    }

    protected void setRootNodeAttributes(Element rootNode, GamePlayer player) {
        rootNode.setAttribute(this.getPlayerAttributeName(), this.getPlayerInformation(player));
    }

    public Element createRootNode(GamePlayer player) {
        Element rootNode = this.doc.createElement(this.getRootNodeName());
        this.setRootNodeAttributes(rootNode, player);
        this.appendChild(null, rootNode);
        return rootNode;
    }

    protected void setStepNodeAttributes(Element stepNode, int depth, int step, boolean isMax, GamePlayer player, GameState state, Long alpha, Long beta) {
        stepNode.setAttribute(this.getDepthAttributeName(), String.valueOf(depth));
        stepNode.setAttribute(this.getStepAttributeName(), String.valueOf(step));
        stepNode.setAttribute(this.getMaximumAttributeName(), String.valueOf(isMax));
        stepNode.setAttribute(this.getPlayerAttributeName(), this.getPlayerInformation(player));
        stepNode.setAttribute(this.getStateAttributeName(), this.getStateInformation(state));
        stepNode.setAttribute(this.getAlphaAttributeName(), alpha == null ? "" : alpha.toString());
        stepNode.setAttribute(this.getBetaAttributeName(), beta == null ? "" : beta.toString());
    }

    public void setStepEvaluationValueAttribute(Element stepNode, long evaluationValue) {
        stepNode.setAttribute(this.getEvaluationValueAttributeName(), String.valueOf(evaluationValue));
    }

    protected void setStepNoBestMovesAttribute(Element stepNode, boolean hasNoBestMoves) {
        stepNode.setAttribute(this.getNoBestMovesAttributeName(), String.valueOf(hasNoBestMoves));
    }

    public void markStepBestMoves(Node stepNode, ArrayList<AiMoveInformation> bestMoves, AiMoveInformation chosenMove) {
        NodeList moveNodes = stepNode.getChildNodes();
        String chosenMoveId = this.getMoveIdInformation(chosenMove);
        if (bestMoves.isEmpty()) {
            this.setStepNoBestMovesAttribute((Element)stepNode, true);
            return;
        }
        ArrayList<String> bestMoveIds = new ArrayList<String>();
        for (AiMoveInformation bestMove : bestMoves) {
            bestMoveIds.add(this.getMoveIdInformation(bestMove));
        }
        int nodeIndex = 0;
        while (nodeIndex < moveNodes.getLength()) {
            Element moveNode = (Element)moveNodes.item(nodeIndex);
            String moveId = HGBaseXMLTools.getAttributeValue(moveNode, this.getMoveIdAttributeName());
            if (moveId.equals(chosenMoveId)) {
                this.setMoveChosenMoveAttribute(moveNode, true);
            }
            if (bestMoveIds.contains(moveId)) {
                this.setMoveIsBestMoveAttribute(moveNode, true);
            }
            ++nodeIndex;
        }
    }

    public Element appendStep(Element parentNode, int depth, int step, boolean isMax, GamePlayer player, GameState state, Long alpha, Long beta) {
        Element stepNode = this.doc.createElement(this.getStepNodeName());
        this.setStepNodeAttributes(stepNode, depth, step, isMax, player, state, alpha, beta);
        this.appendChild(parentNode, stepNode);
        return stepNode;
    }

    protected void setEvaluationNodeAttributes(Element evaluationNode, int step, GamePlayer player, AiMoveInformation move, GameState state, long evaluationValue) {
        evaluationNode.setAttribute(this.getStepAttributeName(), String.valueOf(step));
        evaluationNode.setAttribute(this.getPlayerAttributeName(), this.getPlayerInformation(player));
        evaluationNode.setAttribute(this.getMoveAttributeName(), this.getMoveInformation(move));
        evaluationNode.setAttribute(this.getMoveShortInfoAttributeName(), this.getMoveShortInformation(move));
        evaluationNode.setAttribute(this.getMoveIdAttributeName(), this.getMoveIdInformation(move));
        evaluationNode.setAttribute(this.getStateAttributeName(), this.getStateInformation(state));
        evaluationNode.setAttribute(this.getEvaluationValueAttributeName(), String.valueOf(evaluationValue));
        evaluationNode.setAttribute(this.getAdditionalInformationAttributeName(), this.getAdditionalEvaluationInformation());
    }

    public void appendEvaluation(Element parentNode, int step, GamePlayer player, AiMoveInformation move, GameState state, long evaluationValue) {
        Element evaluationNode = this.doc.createElement(this.getEvaluationNodeName());
        this.setEvaluationNodeAttributes(evaluationNode, step, player, move, state, evaluationValue);
        this.appendChild(parentNode, evaluationNode);
    }

    public void setMoveChangedStateAttribute(Element moveNode, GameState stateAfter) {
        moveNode.setAttribute(this.getStateAfterAttributeName(), this.getStateInformation(stateAfter));
    }

    public void setMoveEvaluationValueAttribute(Element moveNode, long evaluationValue) {
        moveNode.setAttribute(this.getEvaluationValueAttributeName(), String.valueOf(evaluationValue));
    }

    public void setMovePruningInformation(Element moveNode, Long alpha, Long beta) {
        moveNode.setAttribute(this.getAlphaAttributeName(), alpha == null ? "" : alpha.toString());
        moveNode.setAttribute(this.getBetaAttributeName(), beta == null ? "" : beta.toString());
        this.setMoveChosenMoveAttribute(moveNode, true);
    }

    protected void setMoveIsBestMoveAttribute(Element moveNode, boolean isBestMove) {
        moveNode.setAttribute(this.getBestMoveFlagAttributeName(), String.valueOf(isBestMove));
    }

    protected void setMoveChosenMoveAttribute(Element moveNode, boolean isChosenMove) {
        moveNode.setAttribute(this.getChosenMoveFlagAttributeName(), String.valueOf(isChosenMove));
    }

    protected void setValidMoveNodeAttributes(Element moveNode, AiMoveInformation move, GamePlayer player, GameState stateBefore) {
        moveNode.setAttribute(this.getMoveAttributeName(), this.getMoveInformation(move));
        moveNode.setAttribute(this.getMoveShortInfoAttributeName(), this.getMoveShortInformation(move));
        moveNode.setAttribute(this.getMoveIdAttributeName(), this.getMoveIdInformation(move));
        moveNode.setAttribute(this.getPlayerAttributeName(), this.getPlayerInformation(player));
        moveNode.setAttribute(this.getStateBeforeAttributeName(), this.getStateInformation(stateBefore));
    }

    public Element appendValidMove(Element parentNode, AiMoveInformation move, GamePlayer player, GameState stateBefore) {
        Element moveNode = this.doc.createElement(this.getValidMoveNodeName());
        this.setValidMoveNodeAttributes(moveNode, move, player, stateBefore);
        this.appendChild(parentNode, moveNode);
        return moveNode;
    }

    protected void setInvalidMoveNodeAttributes(Element moveNode, AiMoveInformation move) {
        moveNode.setAttribute(this.getMoveAttributeName(), this.getMoveInformation(move));
        moveNode.setAttribute(this.getMoveShortInfoAttributeName(), this.getMoveShortInformation(move));
        moveNode.setAttribute(this.getMoveIdAttributeName(), this.getMoveIdInformation(move));
    }

    public void appendInvalidMove(Element parentNode, AiMoveInformation move) {
        Element moveNode = this.doc.createElement(this.getInvalidMoveNodeName());
        this.setInvalidMoveNodeAttributes(moveNode, move);
        this.appendChild(parentNode, moveNode);
    }

    public void setAnalysisSummaryAttributes(Element rootNode, int countEvaluations, long duration, Date startTimestamp, Date stopTimestamp, AiMoveInformation bestMove) {
        rootNode.setAttribute(this.getCountEvaluationsAttributeName(), String.valueOf(countEvaluations));
        rootNode.setAttribute(this.getDurationAttributeName(), String.valueOf(duration));
        rootNode.setAttribute(this.getStartTimestampAttributeName(), this.formatTimestamp(startTimestamp));
        rootNode.setAttribute(this.getStopTimestampAttributeName(), this.formatTimestamp(stopTimestamp));
        rootNode.setAttribute(this.getBestMoveAttributeName(), this.getMoveInformation(bestMove));
        rootNode.setAttribute(this.getMoveShortInfoAttributeName(), this.getMoveShortInformation(bestMove));
        rootNode.setAttribute(this.getMoveIdAttributeName(), this.getMoveIdInformation(bestMove));
    }

    public static File getAnalyzerFile(String name, String extension) {
        File aiFolder = new File("AiAnalyzer");
        aiFolder.mkdir();
        int round = GameEngine.getInstance().getCurrentRound();
        int turn = GameEngine.getInstance().getCurrentTurn();
        int move = GameEngine.getInstance().getCurrentMove();
        return new File(aiFolder, String.format("%s_%02d%03d%02d.%s", name, round, turn, move, extension));
    }
}

