/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ImageUtil {
    private ImageUtil() {
    }

    public static boolean isEqualImage(ImageIcon img1, ImageIcon img2) {
        if (img1 != null && img2 != null) {
            return img1.getDescription().equals(img2.getDescription());
        }
        return false;
    }

    public static int getMaxImageHeight(ImageIcon[] imageList) {
        int max = 0;
        int i = 0;
        while (i < imageList.length) {
            if (imageList[i] != null && imageList[i].getIconHeight() > max) {
                max = imageList[i].getIconHeight();
            }
            ++i;
        }
        return max;
    }

    public static int getMaxImageWidth(ImageIcon[] imageList) {
        int max = 0;
        int i = 0;
        while (i < imageList.length) {
            if (imageList[i] != null && imageList[i].getIconWidth() > max) {
                max = imageList[i].getIconWidth();
            }
            ++i;
        }
        return max;
    }

    public static void setImageOnLabel(JLabel label, ImageIcon image) {
        if (label != null) {
            ImageUtil.setImageOnLabel(label, image, label.getWidth(), label.getHeight());
        }
    }

    public static void setImageOnLabel(JLabel label, ImageIcon image, int width, int height) {
        if (label != null) {
            if (image == null) {
                label.setIcon(null);
            } else {
                double lw = (double)width * 1.0;
                double lh = (double)height * 1.0;
                double iw = (double)image.getIconWidth() * 1.0;
                double ih = (double)image.getIconHeight() * 1.0;
                if (lw > 0.0 && lw < iw || lh > 0.0 && lh < ih) {
                    double factorW = lw / iw;
                    double factorH = lh / ih;
                    double f = factorW < factorH ? factorW : factorH;
                    image = new ImageIcon(image.getImage().getScaledInstance((int)(iw * f), (int)(ih * f), 4));
                }
                label.setIcon(image);
            }
        }
    }
}

