/*
 * Decompiled with CFR 0.152.
 */
package tjger.net;

import hgb.gui.HGBaseDialog;
import hgb.gui.ProgressPanel;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tjger.MainFrame;

public abstract class NetworkDialogAction {
    private final String message;
    private final MainFrame mainFrame;
    private int actionReturn = -2147483631;
    private boolean userCancel = false;
    private ProgressPanel waitProgressBar;

    public NetworkDialogAction(MainFrame mainFrame) {
        this(mainFrame, null);
    }

    public NetworkDialogAction(MainFrame mainFrame, String message) {
        this.message = message;
        this.mainFrame = mainFrame;
    }

    public static void run(NetworkDialogAction action) {
        action.actionReturn = -2147483631;
        action.waitProgressBar = null;
        if (action.message == null) {
            action.mainFrame.setStatusProgress(1);
            action.actionReturn = action.doAction();
            action.mainFrame.setStatusProgress(0);
        } else {
            new Thread(new ShowDialogThread(action)).start();
            action.waitProgressBar = new ProgressPanel();
            action.waitProgressBar.setState(1);
            action.waitProgressBar.setPreferredSize(new Dimension(250, 20));
            JPanel pnProgress = new JPanel(new BorderLayout());
            pnProgress.add((Component)action.waitProgressBar, "South");
            pnProgress.add((Component)new JLabel(" "), "Center");
            String text = HGBaseText.existsText(action.message) ? HGBaseText.getText(action.message, new String[0]) : action.message;
            pnProgress.add((Component)new JLabel(text), "North");
            Object[] options = new String[]{HGBaseText.getText("dlg.cancel", new String[0])};
            HGBaseDialog.showOptionDialog(action.mainFrame, (Object)pnProgress, HGBaseSettings.get("appName"), -1, -1, null, options, 0);
            action.userCancel = true;
        }
    }

    protected boolean wasCancelled() {
        return this.actionReturn == -2147483631;
    }

    protected void delay() {
        HGBaseTools.sleep(150L);
    }

    protected abstract int doAction();

    public int getReturnValue() {
        return this.actionReturn;
    }

    private static class ShowDialogThread
    implements Runnable {
        private final NetworkDialogAction action;

        public ShowDialogThread(NetworkDialogAction action) {
            this.action = action;
        }

        @Override
        public void run() {
            this.action.actionReturn = this.action.doAction();
            if (this.action.userCancel) {
                this.action.actionReturn = -2147483631;
            } else {
                JButton button = HGBaseDialog.getDialogButton(0);
                button.doClick();
            }
        }
    }
}

