/*
 * Decompiled with CFR 0.152.
 */
package tjger.net;

import hgb.gui.HGBaseDialog;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import tjger.game.NetworkPlayer;
import tjger.game.completed.GameConfig;
import tjger.net.NetworkClient;
import tjger.net.NetworkConnection;
import tjger.net.NetworkMessage;

public class NetworkServerConnection
extends NetworkConnection {
    private static NetworkServerConnection connection = new NetworkServerConnection();
    private List<NetworkClient> listClients;
    private ServerSocket servSock;
    private int lastClient;
    private int numInitialClients;

    private NetworkServerConnection() {
    }

    public static NetworkServerConnection getInstance() {
        return connection;
    }

    public int startServer() {
        this.listClients = new ArrayList<NetworkClient>();
        this.lastClient = 0;
        this.numInitialClients = 0;
        try {
            this.servSock = new ServerSocket(GameConfig.getInstance().getNetworkPort());
        }
        catch (IOException e) {
            this.servSock = null;
            HGBaseDialog.printError(-30218, (JFrame)this.getMainFrame());
            return -30218;
        }
        super.start();
        return 0;
    }

    @Override
    public int getId() {
        return -1;
    }

    public boolean isStarted() {
        return this.servSock != null;
    }

    public int getNumInitialClients() {
        return this.numInitialClients;
    }

    public void setNumInitialClients(int numInitialClients) {
        this.numInitialClients = numInitialClients;
    }

    @Override
    public void close() {
        super.close();
        if (this.servSock != null) {
            int i = this.getNumClients() - 1;
            while (i >= 0) {
                this.disconnect(i);
                --i;
            }
            HGBaseFileTools.closeStream(this.servSock);
            this.servSock = null;
        }
    }

    private synchronized boolean disconnect(int index) {
        NetworkClient client = this.getClient(index);
        if (client != null) {
            int id = client.getClientId();
            if (id >= 0) {
                this.removeMessagesWithClientId(id);
            }
            Socket sock = client.getSocket();
            PrintStream outStream = client.getOutStream();
            BufferedReader inStream = client.getInStream();
            this.putMessage(outStream, NetworkMessage.msgAbort());
            HGBaseFileTools.closeStream(sock);
            HGBaseFileTools.closeStream(outStream);
            HGBaseFileTools.closeStream(inStream);
            return this.removeClient(client);
        }
        return false;
    }

    public int putMessageAll(String msg) {
        return this.putMessageAll(msg, -1);
    }

    public int putMessageAll(String msg, int except) {
        int succ = 0;
        int i = 0;
        while (i < this.getNumClients()) {
            int res;
            if (i != except && (res = this.putMessage(i, msg)) != 0) {
                succ = res;
            }
            ++i;
        }
        return succ;
    }

    public boolean putMessageAllAndWait(String msg, String msgTypeToWait) {
        return this.putMessageAllAndWait(msg, msgTypeToWait, -1);
    }

    public boolean putMessageAllAndWait(String msg, String msgTypeToWait, int except) {
        if (this.putMessageAll(msg, except) == 0) {
            return this.waitForClientsGameOk(msgTypeToWait, except);
        }
        return false;
    }

    public int putMessage(int index, String msg) {
        PrintStream outStream;
        int state = this.getClientState(index);
        if ((state == 1 || state == 2) && (outStream = this.getClientOutput(index)) != null) {
            return this.putMessage(outStream, msg);
        }
        return -30221;
    }

    @Override
    protected String getMessage() {
        if (this.getNumClients() > 0) {
            this.lastClient = (this.lastClient + 1) % this.getNumClients();
            NetworkClient client = this.getClient(this.lastClient);
            if (client != null && (client.getState() == 1 || client.getState() == 2)) {
                int clientId = client.getClientId();
                BufferedReader inStream = client.getInStream();
                if (inStream != null) {
                    StringBuffer msg = new StringBuffer(32);
                    if (this.getMessage(inStream, msg) != 0) {
                        this.disconnect(this.getIndexOfId(clientId));
                    } else if (msg.length() > 0) {
                        msg = msg.append(";" + clientId);
                        return msg.toString();
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected boolean handleMessage(String msg) {
        String type = this.getMessagePart(0, msg);
        String param = this.getMessagePart(1, msg);
        if (type != null && type.equals("TJxERR") && param != null && param.equals("err.netabort")) {
            int id = HGBaseTools.toInt(this.getMessagePart(2, msg));
            if (id >= 0) {
                this.disconnect(this.getIndexOfId(id));
            }
            return true;
        }
        return false;
    }

    public int getNumClients() {
        if (this.listClients == null) {
            return 0;
        }
        return this.listClients.size();
    }

    public NetworkClient getClient(int index) {
        if (index >= 0 && index < this.getNumClients()) {
            return this.listClients.get(index);
        }
        return null;
    }

    public int getClientState(int index) {
        NetworkClient client = this.getClient(index);
        if (client != null) {
            return client.getState();
        }
        return -2147483631;
    }

    public PrintStream getClientOutput(int index) {
        NetworkClient client = this.getClient(index);
        if (client != null) {
            return client.getOutStream();
        }
        return null;
    }

    public int getNumConnected() {
        int conn = 0;
        int i = 0;
        while (i < this.getNumClients()) {
            if (this.getClientState(i) == 1) {
                ++conn;
            }
            ++i;
        }
        return conn;
    }

    private synchronized int getNextClientId() {
        int id = 10;
        boolean found = false;
        while (!found) {
            if (this.getIndexOfId(id) == -1) {
                found = true;
                continue;
            }
            id += 10;
        }
        return id;
    }

    public synchronized int getIndexOfId(int id) {
        if (id < 0) {
            return -1;
        }
        int i = 0;
        while (i < this.getNumClients()) {
            NetworkClient client = this.getClient(i);
            if (client != null && id == client.getClientId()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized int getIndexOfNr(int clientNr) {
        if (clientNr < 0) {
            return -1;
        }
        int i = 0;
        while (i < this.getNumClients()) {
            NetworkClient client = this.getClient(i);
            if (client != null && clientNr == client.getClientNr()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public NetworkClient addClient() {
        int id = this.getNextClientId();
        NetworkClient client = new NetworkClient();
        client.setClientId(id);
        this.listClients.add(client);
        this.startConnecting(id);
        return client;
    }

    private boolean removeClient(NetworkClient client) {
        if (client != null) {
            client.setClientId(-1);
            return this.listClients.remove(client);
        }
        return false;
    }

    public boolean removeClient(int index) {
        return this.disconnect(index);
    }

    private boolean removeLastClientByState(int state) {
        int i = this.getNumClients() - 1;
        while (i >= 0) {
            if ((state == -1 || this.getClientState(i) == state) && this.removeClient(i)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public synchronized void removeBestFitClient(int index) {
        if (!(this.removeLastClientByState(9) || this.removeLastClientByState(0) || this.removeLastClientByState(2) || index >= 0 && this.removeClient(index) || this.removeLastClientByState(1))) {
            this.removeLastClientByState(-1);
        }
    }

    public void startConnecting(final int clientId) {
        Thread t = new Thread(){

            @Override
            public void run() {
                block19: {
                    Socket sock = null;
                    try {
                        int index = NetworkServerConnection.this.getIndexOfId(clientId);
                        NetworkClient client = NetworkServerConnection.this.getClient(index);
                        if (client != null && client.getState() == 0) {
                            boolean releaseSocket = false;
                            client.setState(2);
                            sock = NetworkServerConnection.this.servSock.accept();
                            if (sock != null && client.getState() == 2 && client.getClientId() == clientId) {
                                PrintStream outStream = new PrintStream(sock.getOutputStream(), false, Charset.defaultCharset().displayName());
                                BufferedReader inStream = new BufferedReader(new InputStreamReader(sock.getInputStream(), Charset.defaultCharset()));
                                client.setSocket(sock);
                                client.setOutStream(outStream);
                                client.setInStream(inStream);
                                ArrayList<String> alOut = new ArrayList<String>();
                                boolean wasAbort = false;
                                while (!wasAbort && !NetworkServerConnection.this.messageClientData(alOut, clientId)) {
                                    wasAbort = NetworkServerConnection.this.messageClientAbort(clientId) || client.getClientId() != clientId || NetworkServerConnection.this.putMessage(outStream, NetworkMessage.msgTestS()) != 0;
                                    NetworkServerConnection.netWait();
                                }
                                if (!wasAbort && !alOut.isEmpty()) {
                                    String name = "";
                                    String ip = "";
                                    if (alOut.size() >= 1) {
                                        name = (String)alOut.get(0);
                                    }
                                    if (alOut.size() >= 2) {
                                        ip = (String)alOut.get(1);
                                    }
                                    if (HGBaseTools.hasContent(name)) {
                                        if (NetworkServerConnection.this.nameAlreadyExists(name)) {
                                            NetworkServerConnection.this.putMessage(outStream, NetworkMessage.msgNameExistsS());
                                            releaseSocket = true;
                                        } else {
                                            wasAbort = NetworkServerConnection.this.putMessage(outStream, NetworkMessage.msgShakehandS(clientId)) != 0;
                                            while (!wasAbort && !NetworkServerConnection.this.messageClientAcknowledge(clientId)) {
                                                wasAbort = NetworkServerConnection.this.messageClientAbort(clientId) || client.getClientId() != clientId || NetworkServerConnection.this.putMessage(outStream, NetworkMessage.msgTestS()) != 0;
                                                NetworkServerConnection.netWait();
                                            }
                                            if (!wasAbort) {
                                                if (NetworkServerConnection.this.nameAlreadyExists(name)) {
                                                    NetworkServerConnection.this.putMessage(outStream, NetworkMessage.msgNameExistsS());
                                                    releaseSocket = true;
                                                } else {
                                                    client.setState(1);
                                                    client.setClientName(name);
                                                    client.setClientIP(ip);
                                                    client.setServerIP(NetworkServerConnection.this.getIp());
                                                }
                                            } else {
                                                releaseSocket = true;
                                            }
                                        }
                                    }
                                } else {
                                    releaseSocket = true;
                                }
                            } else {
                                releaseSocket = true;
                            }
                            if (releaseSocket) {
                                NetworkServerConnection.this.disconnect(index);
                            }
                        }
                    }
                    catch (IOException e) {
                        int idx;
                        if (clientId < 0 || (idx = NetworkServerConnection.this.getIndexOfId(clientId)) < 0) break block19;
                        NetworkServerConnection.this.disconnect(idx);
                    }
                }
            }
        };
        t.start();
    }

    private synchronized boolean nameAlreadyExists(String name) {
        int i = 0;
        while (i < this.getNumClients()) {
            NetworkClient client = this.getClient(i);
            if (client != null && client.getState() == 1 && client.getClientName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String removeClientIdFromMessage(String msg) {
        int index = msg.lastIndexOf(59);
        return msg.substring(0, index);
    }

    public boolean messageClientAbort(int id) {
        String msg = this.getNextMessage("TJxERR", "err.netabort", id);
        return msg != null;
    }

    public boolean messageClientAcknowledge(int clientId) {
        String msg = this.getNextMessage("TJxCTRL", "CLACK", clientId);
        return msg != null;
    }

    public boolean messageClientData(List<String> al, int clientId) {
        al.clear();
        String msg = this.getNextMessage("TJxCTRL", "CLCON", clientId);
        if (msg != null) {
            String appName = this.getMessagePart(2, msg);
            if (appName != null && appName.equals(HGBaseSettings.get("appName"))) {
                al.add(this.getMessagePart(3, msg));
                al.add(this.getMessagePart(4, msg));
                return true;
            }
            this.putMessage(this.getIndexOfId(clientId), NetworkMessage.msgWrongApplicationS());
            return true;
        }
        return false;
    }

    public boolean messageClientsGameOk(String msgType) {
        String msg = this.getNextMessage(msgType, "GMOK");
        return msg != null;
    }

    public boolean messageClientsGameOk(String msgType, int clientId) {
        String msg = this.getNextMessage(msgType, "GMOK", clientId);
        return msg != null;
    }

    public boolean waitForClientsGameOk(String msgType) {
        return this.waitForClientsGameOk(msgType, -1);
    }

    /*
     * Unable to fully structure code
     */
    public boolean waitForClientsGameOk(String msgType, int except) {
        numClients = this.getNumInitialClients();
        if (except >= 0) {
            --numClients;
        }
        numOk = 0;
        ** GOTO lbl10
        {
            ++numOk;
            do {
                if (this.messageClientsGameOk(msgType)) continue block0;
                NetworkConnection.netWait();
lbl10:
                // 2 sources

            } while (this.getNumConnected() == this.getNumInitialClients() && numOk < numClients);
        }
        return numOk == numClients;
    }

    public boolean waitForClientMoveInformation(StringBuffer msgReceived, NetworkPlayer player) {
        String msg = null;
        while (player.isPlaying() && this.getNumConnected() == this.getNumInitialClients() && msg == null) {
            msg = this.messageGameInformation("TJxMI");
            NetworkConnection.netWait();
        }
        if (msg != null) {
            msgReceived.append(this.removeClientIdFromMessage(msg));
            return true;
        }
        return false;
    }
}

