/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.common;

import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.Vector;
import java.awt.Color;
import java.awt.Point;

public class CloneUtils {
    private CloneUtils() {
    }

    public static Point[] deepClonePoints(Point[] points) {
        if (points == null) {
            return null;
        }
        Point[] clone = new Point[points.length];
        int index = 0;
        while (index < points.length) {
            clone[index] = new Point(points[index]);
            ++index;
        }
        return clone;
    }

    public static Line deepCloneLine(Line line) {
        if (line == null) {
            return null;
        }
        return new Line(new Point(line.getStartPos()), new Point(line.getEndPos()));
    }

    public static Line[] deepCloneLines(Line[] lines) {
        if (lines == null) {
            return null;
        }
        Line[] clone = new Line[lines.length];
        int index = 0;
        while (index < lines.length) {
            clone[index] = CloneUtils.deepCloneLine(lines[index]);
            ++index;
        }
        return clone;
    }

    public static Vector cloneVector(Vector vector) {
        if (vector == null) {
            return null;
        }
        return new Vector(vector.getDeltaX(), vector.getDeltaY());
    }

    public static Color cloneColor(Color color) {
        if (color == null) {
            return null;
        }
        return new Color(color.getRGB());
    }

    public static byte[] cloneByteArray(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return (byte[])bytes.clone();
    }
}

