/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.common;

import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.common.Vector;
import hgb.gui.HGBaseDialog;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Set;
import javax.swing.JFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.completed.GameManager;

public class TrackLoader {
    private static final String CURRENT_FORMAT_VERSION = "1.0";
    public static final String TRACK_NODE = "track";
    private static final String DESCRIPTION_NODE = "description";
    private static final String OUTER_BORDER_NODE = "outerborder";
    private static final String INNER_BORDER_NODE = "innerborder";
    private static final String FINISH_LINE_NODE = "finishline";
    private static final String START_POSITIONS_NODE = "startpositions";
    private static final String START_VECTOR_NODE = "startvector";
    private static final String CHECK_LINES_NODE = "checklines";
    private static final String BACKGROUND_NODE = "background";
    private static final String POINT_NODE = "point";
    private static final String LINE_NODE = "line";
    private static final String FORMAT_VERSION = "formatversion";
    private static final String TRACK_NAME = "name";
    private static final String TRACK_VERSION = "trackversion";
    private static final String TRACK_AUTHOR = "author";
    private static final String GRID_SIZE = "gridsize";
    private static final int DEFAULT_GRID_SIZE = 10;
    private static final String GRID_COLOR = "gridcolor";
    private static final Color DEFAULT_GRID_COLOR = Color.LIGHT_GRAY;
    private static final String BORDER_COLOR = "bordercolor";
    private static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    private static final String FINISH_LINE_COLOR = "color";
    private static final Color DEFAULT_FINISH_LINE_COLOR = Color.RED;
    private static final String START_VECTOR_DELTA_X = "x";
    private static final int DEFAULT_START_VECTOR_DELTA_X = 0;
    private static final String START_VECTOR_DELTA_Y = "y";
    private static final int DEFAULT_START_VECTOR_DELTA_Y = 0;
    private static final String BACKGROUND_COLOR = "color";
    private static final String POINT_SEQ = "seq";
    private static final int DEFAULT_POINT_SEQ = 0;
    private static final String POINT_X = "x";
    private static final int DEFAULT_POINT_X = 0;
    private static final String POINT_Y = "y";
    private static final int DEFAULT_POINT_Y = 0;
    private static final String LINE_SEQ = "seq";
    private static final int DEFAULT_LINE_SEQ = 0;
    private static final String LANGUAGE = "lan";

    private TrackLoader() {
    }

    public static Track loadTrack(String filename) {
        Element root = HGBaseXMLTools.readXML(filename);
        if (root == null) {
            return null;
        }
        return TrackLoader.loadTrack(root);
    }

    public static Track loadTrack(Node node) {
        String formatVersion = HGBaseXMLTools.getAttributeValue(node, FORMAT_VERSION);
        if (!HGBaseTools.hasContent(formatVersion)) {
            formatVersion = CURRENT_FORMAT_VERSION;
        }
        if (CURRENT_FORMAT_VERSION.equals(formatVersion)) {
            return TrackLoader.parseFormat_1_0(node);
        }
        return null;
    }

    private static Track parseFormat_1_0(Node node) {
        String name = HGBaseXMLTools.getAttributeValue(node, TRACK_NAME);
        String version = HGBaseXMLTools.getAttributeValue(node, TRACK_VERSION);
        String author = HGBaseXMLTools.getAttributeValue(node, TRACK_AUTHOR);
        int gridSize = HGBaseXMLTools.getAttributeIntValue(node, GRID_SIZE, 10);
        Color gridColor = HGBaseXMLTools.getAttributeRGBColorValue(node, GRID_COLOR, DEFAULT_GRID_COLOR);
        Color borderColor = HGBaseXMLTools.getAttributeRGBColorValue(node, BORDER_COLOR, DEFAULT_BORDER_COLOR);
        final Track track = new Track();
        track.setName(name);
        track.setVersion(version);
        track.setAuthor(author);
        track.setGridSize(gridSize);
        track.setGridColor(gridColor);
        track.setBorderColor(borderColor);
        ChildNodeIterator.run(new ChildNodeIterator(node, TRACK_NODE, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                String nodeName = node.getNodeName();
                if (TrackLoader.DESCRIPTION_NODE.equals(nodeName)) {
                    String language = HGBaseXMLTools.getAttributeValue(node, TrackLoader.LANGUAGE);
                    if (!HGBaseTools.hasContent(language)) {
                        language = HGBaseText.getLanguage();
                    }
                    track.setDescription(language, HGBaseXMLTools.getNodeValue(node));
                } else if (TrackLoader.OUTER_BORDER_NODE.equals(nodeName)) {
                    track.setOuterPoints(TrackLoader.parsePoints(node, TrackLoader.OUTER_BORDER_NODE));
                } else if (TrackLoader.INNER_BORDER_NODE.equals(nodeName)) {
                    track.setInnerPoints(TrackLoader.parsePoints(node, TrackLoader.INNER_BORDER_NODE));
                } else if (TrackLoader.FINISH_LINE_NODE.equals(nodeName)) {
                    track.setFinishLineColor(HGBaseXMLTools.getAttributeRGBColorValue(node, "color", DEFAULT_FINISH_LINE_COLOR));
                    Point[] points = TrackLoader.parsePoints(node, TrackLoader.FINISH_LINE_NODE);
                    Line finishLine = points.length >= 2 ? new Line(points[0], points[1]) : new Line(new Point(0, 0), new Point(0, 0));
                    track.setFinishLine(finishLine);
                } else if (TrackLoader.START_POSITIONS_NODE.equals(nodeName)) {
                    track.setStartPositions(TrackLoader.parsePoints(node, TrackLoader.START_POSITIONS_NODE));
                } else if (TrackLoader.START_VECTOR_NODE.equals(nodeName)) {
                    int deltaX = HGBaseXMLTools.getAttributeIntValue(node, "x", 0);
                    int deltaY = HGBaseXMLTools.getAttributeIntValue(node, "y", 0);
                    track.setStartVector(new Vector(deltaX, deltaY));
                } else if (TrackLoader.CHECK_LINES_NODE.equals(nodeName)) {
                    track.setCheckLines(TrackLoader.parseLines(node, TrackLoader.CHECK_LINES_NODE));
                } else if (TrackLoader.BACKGROUND_NODE.equals(nodeName)) {
                    track.setBackgroundColor(HGBaseXMLTools.getAttributeRGBColorValue(node, "color"));
                    try {
                        String imgStr = HGBaseXMLTools.getNodeValue(node);
                        byte[] bytes = Base64.getDecoder().decode(imgStr);
                        track.setBackgroundImageData(bytes);
                    }
                    catch (Exception e) {
                        HGBaseDialog.printError("err_readbackgroundimage", (JFrame)GameManager.getInstance().getMainFrame());
                    }
                }
            }
        });
        return track;
    }

    private static Point[] parsePoints(Node parent, String nodeName) {
        final ArrayList points = new ArrayList();
        ChildNodeIterator.run(new ChildNodeIterator(parent, nodeName, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                String nodeName = node.getNodeName();
                if (TrackLoader.POINT_NODE.equals(nodeName)) {
                    int seq = HGBaseXMLTools.getAttributeIntValue(node, "seq", 0);
                    int x = HGBaseXMLTools.getAttributeIntValue(node, "x", 0);
                    int y = HGBaseXMLTools.getAttributeIntValue(node, "y", 0);
                    Point point = new Point(x, y);
                    HGBaseTools.ensureSize(points, seq + 1);
                    points.set(seq, point);
                }
            }
        });
        return points.toArray(new Point[0]);
    }

    private static Line[] parseLines(Node parent, String nodeName) {
        final ArrayList lines = new ArrayList();
        ChildNodeIterator.run(new ChildNodeIterator(parent, nodeName, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                String nodeName = node.getNodeName();
                if (TrackLoader.LINE_NODE.equals(nodeName)) {
                    int seq = HGBaseXMLTools.getAttributeIntValue(node, "seq", 0);
                    Point[] points = TrackLoader.parsePoints(node, TrackLoader.LINE_NODE);
                    Line line = points.length >= 2 ? new Line(points[0], points[1]) : new Line(new Point(0, 0), new Point(0, 0));
                    HGBaseTools.ensureSize(lines, seq + 1);
                    lines.set(seq, line);
                }
            }
        });
        return lines.toArray(new Line[0]);
    }

    private static String toStringColor(Color color) {
        if (color == null) {
            return "";
        }
        return String.format("%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String toStringBytes(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    private static void appendPoints(Point[] points, Document doc, Node parent) {
        if (points == null) {
            return;
        }
        int pointIndex = 0;
        while (pointIndex < points.length) {
            Element pointNode = doc.createElement(POINT_NODE);
            pointNode.setAttribute("seq", String.valueOf(pointIndex));
            pointNode.setAttribute("x", String.valueOf(points[pointIndex].x));
            pointNode.setAttribute("y", String.valueOf(points[pointIndex].y));
            parent.appendChild(pointNode);
            ++pointIndex;
        }
    }

    private static void appendLines(Line[] lines, Document doc, Node parent) {
        if (lines == null) {
            return;
        }
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            Element lineNode = doc.createElement(LINE_NODE);
            lineNode.setAttribute("seq", String.valueOf(lineIndex));
            TrackLoader.appendPoints(lines[lineIndex].getPositions(), doc, lineNode);
            parent.appendChild(lineNode);
            ++lineIndex;
        }
    }

    public static void saveTrack(Track track, Document doc, Element root) {
        if (track == null || doc == null || root == null) {
            return;
        }
        root.setAttribute(FORMAT_VERSION, CURRENT_FORMAT_VERSION);
        root.setAttribute(TRACK_NAME, track.getName());
        root.setAttribute(TRACK_VERSION, track.getVersion());
        root.setAttribute(TRACK_AUTHOR, track.getAuthor());
        root.setAttribute(GRID_SIZE, String.valueOf(track.getGridSize()));
        root.setAttribute(GRID_COLOR, TrackLoader.toStringColor(track.getGridColor()));
        root.setAttribute(BORDER_COLOR, TrackLoader.toStringColor(track.getBorderColor()));
        Set<String> languages = track.getDescriptions().keySet();
        for (String language : languages) {
            Element descriptionNode = doc.createElement(DESCRIPTION_NODE);
            descriptionNode.setAttribute(LANGUAGE, language);
            descriptionNode.setTextContent(track.getDescription(language));
            root.appendChild(descriptionNode);
        }
        Element outerBorderNode = doc.createElement(OUTER_BORDER_NODE);
        TrackLoader.appendPoints(track.getOuterPoints(), doc, outerBorderNode);
        root.appendChild(outerBorderNode);
        Element innerBorderNode = doc.createElement(INNER_BORDER_NODE);
        TrackLoader.appendPoints(track.getInnerPoints(), doc, innerBorderNode);
        root.appendChild(innerBorderNode);
        Element finishLineNode = doc.createElement(FINISH_LINE_NODE);
        finishLineNode.setAttribute("color", TrackLoader.toStringColor(track.getFinishLineColor()));
        TrackLoader.appendPoints(track.getFinishLine().getPositions(), doc, finishLineNode);
        root.appendChild(finishLineNode);
        Element startPositionsNode = doc.createElement(START_POSITIONS_NODE);
        TrackLoader.appendPoints(track.getStartPositions(), doc, startPositionsNode);
        root.appendChild(startPositionsNode);
        Element startVectorNode = doc.createElement(START_VECTOR_NODE);
        startVectorNode.setAttribute("x", String.valueOf(track.getStartVector().getDeltaX()));
        startVectorNode.setAttribute("y", String.valueOf(track.getStartVector().getDeltaY()));
        root.appendChild(startVectorNode);
        Element checkLineNode = doc.createElement(CHECK_LINES_NODE);
        TrackLoader.appendLines(track.getCheckLines(), doc, checkLineNode);
        root.appendChild(checkLineNode);
        Element backgroundNode = doc.createElement(BACKGROUND_NODE);
        backgroundNode.setAttribute("color", TrackLoader.toStringColor(track.getBackgroundColor()));
        backgroundNode.setTextContent(TrackLoader.toStringBytes(track.getBackgroundImageData()));
        root.appendChild(backgroundNode);
    }
}

