/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.common;

import java.awt.Point;

public class Vector {
    private int deltaX;
    private int deltaY;

    public Vector(int deltaX, int deltaY) {
        this.deltaX = deltaX;
        this.deltaY = deltaY;
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public boolean isVertical() {
        return this.deltaX == 0;
    }

    public boolean isHorizontal() {
        return this.deltaY == 0;
    }

    public boolean isZero() {
        return this.isVertical() && this.isHorizontal();
    }

    public Point calcEndPos(Point startPos) {
        if (startPos == null) {
            return null;
        }
        return new Point(startPos.x + this.deltaX, startPos.y + this.deltaY);
    }

    public static Vector calcVector(Point pos1, Point pos2) {
        if (pos1 == null || pos2 == null) {
            return null;
        }
        return new Vector(pos2.x - pos1.x, pos2.y - pos1.y);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)obj;
        if (this == other) {
            return true;
        }
        return this.deltaX == other.deltaX && this.deltaY == other.deltaY;
    }

    public Vector rotate(double angle) {
        double cosAngle = Math.cos(Math.toRadians(angle));
        double sinAngle = Math.sin(Math.toRadians(angle));
        return new Vector((int)((double)this.deltaX * cosAngle - (double)this.deltaY * sinAngle), (int)((double)this.deltaX * sinAngle + (double)this.deltaY * cosAngle));
    }

    public double getAngleRad() {
        return Math.atan2(this.deltaY, this.deltaX);
    }

    public double getAngle() {
        return Math.toDegrees(this.getAngleRad());
    }
}

