/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.game;

import java.awt.Point;
import java.util.ArrayList;

public class DrivePosition {
    Point pos;
    boolean possible;
    boolean collision;

    public DrivePosition(Point pos, boolean possible, boolean collision) {
        this.pos = pos;
        this.possible = possible;
        this.collision = collision;
    }

    public Point getPos() {
        return this.pos;
    }

    public boolean isPossible() {
        return this.possible;
    }

    public boolean causesCollision() {
        return this.collision;
    }

    private static Point[] getPositions(DrivePosition[] positions, boolean possible) {
        if (positions == null) {
            return null;
        }
        ArrayList<Point> returnPositions = new ArrayList<Point>();
        DrivePosition[] drivePositionArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            DrivePosition pos = drivePositionArray[n2];
            if (pos.isPossible() == possible) {
                returnPositions.add(pos.getPos());
            }
            ++n2;
        }
        return returnPositions.toArray(new Point[0]);
    }

    public static Point[] getPossiblePositions(DrivePosition[] positions) {
        return DrivePosition.getPositions(positions, true);
    }

    public static Point[] getNotPossiblePositions(DrivePosition[] positions) {
        return DrivePosition.getPositions(positions, false);
    }
}

