/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.game;

import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.common.Vector;
import com.tjger.lineracer.desktop.game.DriveMove;
import com.tjger.lineracer.desktop.game.DrivePosition;
import com.tjger.lineracer.desktop.game.LineRacerState;
import java.awt.Point;
import java.util.ArrayList;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.SimpleGameRules;

public class LineRacerRules
extends SimpleGameRules {
    public static final String GAMEINFO_COLLISION_SKIP_NUMBER = "gameinfo.collisionskipnumber";
    public static final int DEFAULT_COLLISION_SKIP_NUMBER = 2;
    public static final String GAMEINFO_DAMAGE_ON_COLLISION = "gameinfo.damageoncollision";
    public static final String DEFAULT_DAMAGE_ON_COLLISION = "1";
    public static final String GAMEINFO_MAX_COLLISIONS_NUMBER = "gameinfo.maxcollisionsnumber";
    public static final int DEFAULT_MAX_COLLISIONS_NUMBER = 2;

    @Override
    public GamePlayer getNextPlayer(GamePlayer currentPlayer, GameState gameState) {
        LineRacerState state = (LineRacerState)gameState;
        GamePlayer nextPlayer = super.getNextPlayer(currentPlayer, gameState);
        int skipMoveCounter = state.getPlayerSkipMoveCounter(nextPlayer);
        if (skipMoveCounter > 0) {
            state.decreasePlayerSkipMoveCounter(nextPlayer);
            return this.getNextPlayer(nextPlayer, gameState);
        }
        return nextPlayer;
    }

    @Override
    public boolean isRoundFinished(GameState gameState) {
        return this.getGameEngine().getActivePlayers(true).length == 0;
    }

    @Override
    public boolean isGameFinished(GameState gameState) {
        return this.isRoundFinished(gameState);
    }

    @Override
    public void doScoring(GamePlayer[] playerToScore, GameState gameState) {
    }

    @Override
    public boolean isValidMove(MoveInformation move, GameState gameState) {
        if (move instanceof DriveMove) {
            DriveMove driveMove = (DriveMove)move;
            LineRacerState state = (LineRacerState)gameState;
            return driveMove.getPos() != null && LineRacerUtils.isGridPosValid(driveMove.getPos(), LineRacerUtils.calcMaxGridPos(state.getGridSize(), 1600, 900));
        }
        return false;
    }

    private Point[] getSurroundingPositions(Point pos) {
        if (pos == null) {
            return null;
        }
        Point[] positions = new Point[9];
        int posIndex = 0;
        int x = pos.x - 1;
        while (x <= pos.x + 1) {
            int y = pos.y - 1;
            while (y <= pos.y + 1) {
                positions[posIndex++] = new Point(x, y);
                ++y;
            }
            ++x;
        }
        return positions;
    }

    private boolean crossedBorder(Track track, Line testLane, boolean hadCollision, Line lastLane) {
        boolean crossedBorder = false;
        if (hadCollision) {
            if (track.isPosInside(testLane.getStartPos())) {
                crossedBorder = track.crossesBorder(testLane);
            } else {
                Line lastCrossedBorderLine = track.getCrossedBorderLine(lastLane);
                Line[] crossedBorderLines = track.getCrossedBorderLines(testLane);
                if (crossedBorderLines != null) {
                    Line[] lineArray = crossedBorderLines;
                    int n = crossedBorderLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Line crossedBorderLine = lineArray[n2];
                        if (!crossedBorderLine.equals(lastCrossedBorderLine) && !LineRacerUtils.isPointInArray(crossedBorderLine.getPositions(), testLane.getStartPos())) {
                            crossedBorder = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
        } else {
            crossedBorder = track.crossesBorder(testLane);
        }
        return crossedBorder;
    }

    private DrivePosition getCollisionPosition(Track track, Line lane) {
        return new DrivePosition(track.getBorderLineCollisionPosition(lane), true, true);
    }

    public DrivePosition[] getPossiblePositions(GamePlayer player, LineRacerState state, Track track) {
        int countPos;
        Point[] lanePositions = state.getPlayerLanePositions(player);
        int n = countPos = lanePositions == null ? 0 : lanePositions.length;
        if (countPos == 0) {
            return null;
        }
        Point lastPos = lanePositions[countPos - 1];
        ArrayList<DrivePosition> possiblePositions = new ArrayList<DrivePosition>();
        if (countPos == 1) {
            Vector vector = track.getStartVector();
            possiblePositions.add(new DrivePosition(vector.calcEndPos(lastPos), true, false));
        } else {
            Point[] surroundings;
            Vector vector = Vector.calcVector(lanePositions[countPos - 2], lastPos);
            Point nextPos = vector.calcEndPos(lastPos);
            boolean hadCollision = vector.isZero();
            int countPossible = 0;
            Point[] pointArray = surroundings = this.getSurroundingPositions(nextPos);
            int n2 = surroundings.length;
            int n3 = 0;
            while (n3 < n2) {
                Point pos = pointArray[n3];
                Line testLane = new Line(lastPos, pos);
                boolean possible = !state.isPosOccupied(pos) && track.isPosInside(pos);
                possible &= !this.crossedBorder(track, testLane, hadCollision, hadCollision ? new Line(lanePositions[countPos - 3], lanePositions[countPos - 2]) : new Line(lanePositions[countPos - 2], lastPos));
                countPossible += (possible &= hadCollision || !LineRacerUtils.isPosNextToPos(pos, lastPos, vector)) ? 1 : 0;
                possiblePositions.add(new DrivePosition(pos, possible, false));
                ++n3;
            }
            if (countPossible == 0) {
                possiblePositions.clear();
                possiblePositions.add(this.getCollisionPosition(track, new Line(lastPos, nextPos)));
            }
        }
        return possiblePositions.toArray(new DrivePosition[0]);
    }

    public int getCollisionSkipNumber() {
        return this.getGameManager().getNewGameInformationInt(GAMEINFO_COLLISION_SKIP_NUMBER, 2);
    }

    public boolean isDamageOnCollisionActive() {
        return this.getGameManager().getNewGameInformationBoolean(GAMEINFO_DAMAGE_ON_COLLISION, DEFAULT_DAMAGE_ON_COLLISION.equals(DEFAULT_DAMAGE_ON_COLLISION));
    }

    public int getMaxCollisionsNumber() {
        return this.getGameManager().getNewGameInformationInt(GAMEINFO_MAX_COLLISIONS_NUMBER, 2);
    }
}

