/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.game;

import com.tjger.lineracer.desktop.common.AbstractLineRacerGameState;
import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.TrackLoader;
import com.tjger.lineracer.desktop.game.DriveMove;
import com.tjger.lineracer.desktop.game.LineRacerRules;
import com.tjger.lineracer.desktop.ui.dialog.LineRacerNewGameDialog;
import com.tjger.lineracer.desktop.ui.frame.LineRacerStatusBar;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import tjger.MainFrame;
import tjger.game.GamePlayer;
import tjger.game.MoveInformation;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;

public class LineRacerState
extends AbstractLineRacerGameState {
    private static final String XMLKEY_GAMESTATE_NODE = "state";
    private static final String XMLKEY_PLAYER_LANE_POSITIONS_NODE = "playerlanepositions";
    private static final String XMLKEY_PLAYER_LANE_POSITION_NODE = "playerlaneposition";
    private static final String XMLKEY_PLAYER_CROSSED_CHECK_LINES_NODE = "playercrossedchecklines";
    private static final String XMLKEY_PLAYER_CROSSED_CHECK_LINE_NODE = "playercrossedcheckline";
    private static final String XMLKEY_PLAYER_SKIP_MOVE_COUNTERS_NODE = "playerskipmovecounters";
    private static final String XMLKEY_PLAYER_SKIP_MOVE_COUNTER_NODE = "playerskipmovecounter";
    private static final String XMLKEY_PLAYERS_HAS_FINISHED_NODE = "playerhasfinished";
    private static final String XMLKEY_PLAYER_HAS_FINISHED_NODE = "player";
    private static final String XMLKEY_PLAYER_COLLISION_COUNTERS_NODE = "playercollisioncounters";
    private static final String XMLKEY_PLAYER_COLLISION_COUNTER_NODE = "playercollisioncounter";
    private static final String XMLKEY_BACKGROUND_IMAGE_HIDDEN = "backgroundimagehidden";
    private static final String XMLKEY_PLAYER_INDEX = "player";
    private static final String XMLKEY_POSITION_INDEX = "seq";
    private static final String XMLKEY_POSITION_X = "x";
    private static final String XMLKEY_POSITION_Y = "y";
    private static final String XMLKEY_COUNT_LINES = "count";
    private static final String XMLKEY_LINE_INDEX = "seq";
    private static final String XMLKEY_CROSSED = "crossed";
    private static final String XMLKEY_SKIP_MOVE_COUNTER = "counter";
    private static final String XMLKEY_COLLISION_COUNTER = "counter";
    private static final String NEWLINE_REPLACEMENT = "#x1E;";
    private static final String SOUND_COLLISION = "collision";
    private static final String SOUND_FINISH = "finish";
    private static final String SOUND_MOVE = "move";
    private static final String SOUND_START = "start";
    private HashMap<GamePlayer, ArrayList<Point>> playerLanePositions;
    private HashMap<GamePlayer, boolean[]> playerCrossedCheckLines;
    private HashMap<GamePlayer, Integer> playerSkipMoveCounter;
    private ArrayList<GamePlayer> playerHasFinished;
    private HashMap<GamePlayer, Integer> playerCollisionCounter;
    private int loadErrorCode;

    public Point[] getPlayerLanePositions(GamePlayer player) {
        ArrayList lanePositions = this.playerLanePositions.getOrDefault(player, new ArrayList());
        return lanePositions.toArray(new Point[0]);
    }

    private Point getLaneLastPosition(ArrayList<Point> lane) {
        if (lane == null) {
            return null;
        }
        return lane.get(lane.size() - 1);
    }

    public Point getPlayerLastLanePosition(GamePlayer player) {
        return this.getLaneLastPosition(this.playerLanePositions.get(player));
    }

    private Line getPlayerLastLaneLine(GamePlayer player) {
        int countPos;
        ArrayList<Point> lanePositions = this.playerLanePositions.get(player);
        int n = countPos = lanePositions == null ? 0 : lanePositions.size();
        if (countPos < 2) {
            return null;
        }
        return new Line(lanePositions.get(countPos - 2), lanePositions.get(countPos - 1));
    }

    public boolean isPosOccupied(Point pos) {
        if (pos == null) {
            return false;
        }
        Set<GamePlayer> players = this.playerLanePositions.keySet();
        for (GamePlayer player : players) {
            ArrayList<Point> lane;
            if (player.isDropOut() || (lane = this.playerLanePositions.get(player)) == null || lane.size() <= 0 || !pos.equals(this.getLaneLastPosition(lane))) continue;
            return true;
        }
        return false;
    }

    private void addPlayerLanePosition(GamePlayer player, Point pos) {
        this.playerLanePositions.get(player).add(pos);
    }

    private void setPlayerCrossedCheckLine(GamePlayer player, int lineIndex, boolean crossedFlag) {
        this.playerCrossedCheckLines.get((Object)player)[lineIndex] = crossedFlag;
    }

    private boolean hasPlayerCrossedAllCheckLines(GamePlayer player) {
        boolean[] flags;
        boolean[] blArray = flags = this.playerCrossedCheckLines.get(player);
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            boolean crossed = blArray[n2];
            if (!crossed) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void resetGame(GameEngine engine) {
        this.playAudio(SOUND_START);
        this.track = LineRacerNewGameDialog.getSelectedTrack();
        this.initPlayerLanePositions(this.track.getStartPositions());
        this.initPlayerCrossedCheckLines(this.track.getCheckLines().length);
        this.playerSkipMoveCounter = new HashMap();
        this.playerHasFinished = new ArrayList();
        this.playerCollisionCounter = new HashMap();
    }

    private Point getPlayerStartPosition(Point[] startPositions, int playerIndex) {
        if (startPositions == null || playerIndex < 0 || playerIndex >= startPositions.length) {
            return null;
        }
        return startPositions[playerIndex];
    }

    private Point getPlayerStartPosition(GamePlayer player) {
        return this.getPlayerStartPosition(this.getTrack().getStartPositions(), GameEngine.getInstance().getIndexOfPlayer(player));
    }

    private void initPlayerLanePositions(Point[] startPositions) {
        if (startPositions == null) {
            startPositions = new Point[]{};
        }
        this.playerLanePositions = new HashMap();
        GamePlayer[] activePlayers = GameEngine.getInstance().getActivePlayers();
        int playerIndex = 0;
        while (playerIndex < activePlayers.length) {
            ArrayList<Point> lanePositions = new ArrayList<Point>();
            Point startPos = this.getPlayerStartPosition(startPositions, playerIndex);
            if (startPos != null) {
                lanePositions.add(startPos);
            }
            this.playerLanePositions.put(activePlayers[playerIndex], lanePositions);
            ++playerIndex;
        }
    }

    private void initPlayerCrossedCheckLines(int countCheckLines) {
        GamePlayer[] activePlayers;
        this.playerCrossedCheckLines = new HashMap();
        GamePlayer[] gamePlayerArray = activePlayers = GameEngine.getInstance().getActivePlayers();
        int n = activePlayers.length;
        int n2 = 0;
        while (n2 < n) {
            GamePlayer player = gamePlayerArray[n2];
            boolean[] flags = new boolean[countCheckLines];
            Arrays.fill(flags, false);
            this.playerCrossedCheckLines.put(player, flags);
            ++n2;
        }
    }

    private void setPlayerSkipMoveCounter(GamePlayer player, int counter) {
        this.playerSkipMoveCounter.put(player, counter);
    }

    public int getPlayerSkipMoveCounter(GamePlayer player) {
        return this.playerSkipMoveCounter.getOrDefault(player, 0);
    }

    public void decreasePlayerSkipMoveCounter(GamePlayer player) {
        this.setPlayerSkipMoveCounter(player, Math.max(this.getPlayerSkipMoveCounter(player) - 1, 0));
    }

    private void setPlayerHasFinished(GamePlayer player) {
        if (this.playerHasFinished.contains(player)) {
            return;
        }
        this.playerHasFinished.add(player);
    }

    public boolean hasPlayerFinished(GamePlayer player) {
        return this.playerHasFinished.contains(player);
    }

    private void setPlayerCollsionCounter(GamePlayer player, int counter) {
        this.playerCollisionCounter.put(player, counter);
    }

    public int getPlayerCollisionCounter(GamePlayer player) {
        return this.playerCollisionCounter.getOrDefault(player, 0);
    }

    private void increasePlayerCollisionCounter(GamePlayer player) {
        this.setPlayerCollsionCounter(player, this.getPlayerCollisionCounter(player) + 1);
    }

    @Override
    public void resetRound(GameEngine engine) {
    }

    @Override
    public void resetTurn(GameEngine engine) {
    }

    @Override
    public void stopGame() {
    }

    private LineRacerRules getLineRacerGameRules(GameEngine engine) {
        return (LineRacerRules)engine.getGameManager().getGameRules();
    }

    @Override
    public void changeState(GamePlayer player, MoveInformation move, GameEngine engine) {
        if (move instanceof DriveMove) {
            DriveMove driveMove = (DriveMove)move;
            this.addPlayerLanePosition(player, driveMove.getPos());
            Line lastLine = this.getPlayerLastLaneLine(player);
            if (lastLine != null) {
                this.checkCrossedCheckLine(player, lastLine);
                this.checkCrossedFinishLine(player, lastLine);
            }
            if (driveMove.causesCollision()) {
                LineRacerRules rules = this.getLineRacerGameRules(engine);
                this.increasePlayerCollisionCounter(player);
                this.addPlayerLanePosition(player, driveMove.getPos());
                this.setPlayerSkipMoveCounter(player, rules.getCollisionSkipNumber());
                if (rules.isDamageOnCollisionActive() && this.getPlayerCollisionCounter(player) > rules.getMaxCollisionsNumber()) {
                    this.dropOutPlayer(player);
                }
            }
            this.playMoveAudio(this.hasPlayerFinished(player), driveMove.causesCollision());
            this.increaseMoveCounter(player);
            LineRacerStatusBar.setVectorInfo(null);
        }
    }

    private void increaseMoveCounter(GamePlayer player) {
        player.setScore(player.getScore(2) + 1, 2);
    }

    @Override
    public void undoMove(GamePlayer player, MoveInformation move) {
    }

    @Override
    public int save(Document doc, Element root) {
        GameEngine engine = GameEngine.getInstance();
        root.setAttribute(XMLKEY_BACKGROUND_IMAGE_HIDDEN, String.valueOf(this.isBackgroundImageHidden()));
        this.savePlayerLanePositions(doc, root, engine);
        this.savePlayerCrossedCheckLines(doc, root, engine);
        this.savePlayerSkipMoveCounter(doc, root, engine);
        this.savePlayerHasFinished(doc, root, engine);
        this.savePlayerCollisionCounter(doc, root, engine);
        this.saveTrack(doc, root);
        return 0;
    }

    private void savePlayerLanePositions(Document doc, Element parent, GameEngine engine) {
        Element node = doc.createElement(XMLKEY_PLAYER_LANE_POSITIONS_NODE);
        parent.appendChild(node);
        Set<GamePlayer> players = this.playerLanePositions.keySet();
        for (GamePlayer player : players) {
            this.saveLanePositions(doc, node, player, engine);
        }
    }

    private void saveLanePositions(Document doc, Element parent, GamePlayer player, GameEngine engine) {
        String playerIndex = String.valueOf(engine.getIndexOfPlayer(player));
        ArrayList<Point> positions = this.playerLanePositions.get(player);
        int posIndex = 0;
        while (posIndex < positions.size()) {
            this.saveLanePosition(doc, parent, playerIndex, posIndex, positions.get(posIndex));
            ++posIndex;
        }
    }

    private void saveLanePosition(Document doc, Element parent, String playerIndex, int posIndex, Point position) {
        Element node = doc.createElement(XMLKEY_PLAYER_LANE_POSITION_NODE);
        node.setAttribute("player", playerIndex);
        node.setAttribute("seq", String.valueOf(posIndex));
        node.setAttribute(XMLKEY_POSITION_X, String.valueOf(position.x));
        node.setAttribute(XMLKEY_POSITION_Y, String.valueOf(position.y));
        parent.appendChild(node);
    }

    private void savePlayerCrossedCheckLines(Document doc, Element parent, GameEngine engine) {
        Element node = doc.createElement(XMLKEY_PLAYER_CROSSED_CHECK_LINES_NODE);
        parent.appendChild(node);
        node.setAttribute(XMLKEY_COUNT_LINES, String.valueOf(this.track.getCheckLines().length));
        Set<GamePlayer> players = this.playerCrossedCheckLines.keySet();
        for (GamePlayer player : players) {
            this.saveCrossedCheckLines(doc, node, player, engine);
        }
    }

    private void saveCrossedCheckLines(Document doc, Element parent, GamePlayer player, GameEngine engine) {
        String playerIndex = String.valueOf(engine.getIndexOfPlayer(player));
        boolean[] crossedCheckLines = this.playerCrossedCheckLines.get(player);
        int lineIndex = 0;
        while (lineIndex < crossedCheckLines.length) {
            this.saveCrossedCheckLine(doc, parent, playerIndex, lineIndex, crossedCheckLines[lineIndex]);
            ++lineIndex;
        }
    }

    private void saveCrossedCheckLine(Document doc, Element parent, String playerIndex, int lineIndex, boolean crossed) {
        Element node = doc.createElement(XMLKEY_PLAYER_CROSSED_CHECK_LINE_NODE);
        node.setAttribute("player", playerIndex);
        node.setAttribute("seq", String.valueOf(lineIndex));
        node.setAttribute(XMLKEY_CROSSED, String.valueOf(crossed));
        parent.appendChild(node);
    }

    private void savePlayerSkipMoveCounter(Document doc, Element parent, GameEngine engine) {
        Element node = doc.createElement(XMLKEY_PLAYER_SKIP_MOVE_COUNTERS_NODE);
        parent.appendChild(node);
        Set<GamePlayer> players = this.playerSkipMoveCounter.keySet();
        for (GamePlayer player : players) {
            String playerIndex = String.valueOf(engine.getIndexOfPlayer(player));
            this.saveSkipMoveCounter(doc, node, playerIndex, this.getPlayerSkipMoveCounter(player));
        }
    }

    private void saveSkipMoveCounter(Document doc, Element parent, String playerIndex, int counter) {
        Element node = doc.createElement(XMLKEY_PLAYER_SKIP_MOVE_COUNTER_NODE);
        node.setAttribute("player", playerIndex);
        node.setAttribute("counter", String.valueOf(counter));
        parent.appendChild(node);
    }

    private void savePlayerHasFinished(Document doc, Element parent, GameEngine engine) {
        Element node = doc.createElement(XMLKEY_PLAYERS_HAS_FINISHED_NODE);
        parent.appendChild(node);
        for (GamePlayer player : this.playerHasFinished) {
            String playerIndex = String.valueOf(engine.getIndexOfPlayer(player));
            this.saveHasFinished(doc, node, playerIndex);
        }
    }

    private void saveHasFinished(Document doc, Element parent, String playerIndex) {
        Element node = doc.createElement("player");
        node.setAttribute("player", playerIndex);
        parent.appendChild(node);
    }

    private void savePlayerCollisionCounter(Document doc, Element parent, GameEngine engine) {
        Element node = doc.createElement(XMLKEY_PLAYER_COLLISION_COUNTERS_NODE);
        parent.appendChild(node);
        Set<GamePlayer> players = this.playerCollisionCounter.keySet();
        for (GamePlayer player : players) {
            String playerIndex = String.valueOf(engine.getIndexOfPlayer(player));
            this.saveCollisionCounter(doc, node, playerIndex, this.getPlayerCollisionCounter(player));
        }
    }

    private void saveCollisionCounter(Document doc, Element parent, String playerIndex, int counter) {
        Element node = doc.createElement(XMLKEY_PLAYER_COLLISION_COUNTER_NODE);
        node.setAttribute("player", playerIndex);
        node.setAttribute("counter", String.valueOf(counter));
        parent.appendChild(node);
    }

    private void saveTrack(Document doc, Element parent) {
        Element trackNode = doc.createElement("track");
        parent.appendChild(trackNode);
        TrackLoader.saveTrack(this.track, doc, trackNode);
    }

    @Override
    public int load(Node node) {
        this.loadErrorCode = 0;
        final GameEngine engine = GameEngine.getInstance();
        this.playerLanePositions = new HashMap();
        this.playerCrossedCheckLines = new HashMap();
        this.playerSkipMoveCounter = new HashMap();
        this.playerHasFinished = new ArrayList();
        this.playerCollisionCounter = new HashMap();
        this.setBackgroundImageHidden(HGBaseXMLTools.getAttributeBooleanValue(node, XMLKEY_BACKGROUND_IMAGE_HIDDEN));
        ChildNodeIterator.run(new ChildNodeIterator(node, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                String nodeName = node.getNodeName();
                if (LineRacerState.XMLKEY_PLAYER_LANE_POSITIONS_NODE.equals(nodeName)) {
                    LineRacerState.this.loadPlayerLanePositions(node, engine);
                } else if (LineRacerState.XMLKEY_PLAYER_CROSSED_CHECK_LINES_NODE.equals(nodeName)) {
                    LineRacerState.this.loadPlayerCrossedCheckLines(node, HGBaseXMLTools.getAttributeIntValue(node, LineRacerState.XMLKEY_COUNT_LINES), engine);
                } else if (LineRacerState.XMLKEY_PLAYER_SKIP_MOVE_COUNTERS_NODE.equals(nodeName)) {
                    LineRacerState.this.loadPlayerSkipMoveCounter(node, engine);
                } else if (LineRacerState.XMLKEY_PLAYERS_HAS_FINISHED_NODE.equals(nodeName)) {
                    LineRacerState.this.loadPlayerHasFinished(node, engine);
                } else if (LineRacerState.XMLKEY_PLAYER_COLLISION_COUNTERS_NODE.equals(nodeName)) {
                    LineRacerState.this.loadPlayerCollisionCounter(node, engine);
                } else if ("track".equals(nodeName)) {
                    LineRacerState.this.track = TrackLoader.loadTrack(node);
                    LineRacerState.this.loadErrorCode = LineRacerState.this.track.getTrackProblems().length > 0 ? -10706 : LineRacerState.this.loadErrorCode;
                }
            }
        });
        return this.loadErrorCode;
    }

    private void loadPlayerLanePositions(Node parent, final GameEngine engine) {
        ChildNodeIterator.run(new ChildNodeIterator(parent, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (LineRacerState.XMLKEY_PLAYER_LANE_POSITION_NODE.equals(node.getNodeName())) {
                    int playerIndex = HGBaseXMLTools.getAttributeIntValue(node, "player");
                    int posIndex = HGBaseXMLTools.getAttributeIntValue(node, "seq");
                    int x = HGBaseXMLTools.getAttributeIntValue(node, LineRacerState.XMLKEY_POSITION_X);
                    int y = HGBaseXMLTools.getAttributeIntValue(node, LineRacerState.XMLKEY_POSITION_Y);
                    GamePlayer player = engine.getPlayerWithIndex(playerIndex);
                    ArrayList<Point> positions = LineRacerState.this.playerLanePositions.getOrDefault(player, new ArrayList());
                    HGBaseTools.ensureSize(positions, posIndex + 1);
                    positions.set(posIndex, new Point(x, y));
                    LineRacerState.this.playerLanePositions.put(player, positions);
                }
            }
        });
    }

    private void loadPlayerCrossedCheckLines(Node parent, final int countCheckLines, final GameEngine engine) {
        ChildNodeIterator.run(new ChildNodeIterator(parent, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (LineRacerState.XMLKEY_PLAYER_CROSSED_CHECK_LINE_NODE.equals(node.getNodeName())) {
                    int playerIndex = HGBaseXMLTools.getAttributeIntValue(node, "player");
                    int lineIndex = HGBaseXMLTools.getAttributeIntValue(node, "seq");
                    boolean crossed = HGBaseXMLTools.getAttributeBooleanValue(node, LineRacerState.XMLKEY_CROSSED);
                    GamePlayer player = engine.getPlayerWithIndex(playerIndex);
                    boolean[] crossedLines = LineRacerState.this.playerCrossedCheckLines.getOrDefault(player, new boolean[countCheckLines]);
                    crossedLines[lineIndex] = crossed;
                    LineRacerState.this.playerCrossedCheckLines.put(player, crossedLines);
                }
            }
        });
    }

    private void loadPlayerSkipMoveCounter(Node parent, final GameEngine engine) {
        ChildNodeIterator.run(new ChildNodeIterator(parent, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (LineRacerState.XMLKEY_PLAYER_SKIP_MOVE_COUNTER_NODE.equals(node.getNodeName())) {
                    int playerIndex = HGBaseXMLTools.getAttributeIntValue(node, "player");
                    int counter = HGBaseXMLTools.getAttributeIntValue(node, "counter");
                    GamePlayer player = engine.getPlayerWithIndex(playerIndex);
                    LineRacerState.this.setPlayerSkipMoveCounter(player, counter);
                }
            }
        });
    }

    private void loadPlayerHasFinished(Node parent, final GameEngine engine) {
        ChildNodeIterator.run(new ChildNodeIterator(parent, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if ("player".equals(node.getNodeName())) {
                    int playerIndex = HGBaseXMLTools.getAttributeIntValue(node, "player");
                    GamePlayer player = engine.getPlayerWithIndex(playerIndex);
                    LineRacerState.this.setPlayerHasFinished(player);
                }
            }
        });
    }

    private void loadPlayerCollisionCounter(Node parent, final GameEngine engine) {
        ChildNodeIterator.run(new ChildNodeIterator(parent, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (LineRacerState.XMLKEY_PLAYER_COLLISION_COUNTER_NODE.equals(node.getNodeName())) {
                    int playerIndex = HGBaseXMLTools.getAttributeIntValue(node, "player");
                    int counter = HGBaseXMLTools.getAttributeIntValue(node, "counter");
                    GamePlayer player = engine.getPlayerWithIndex(playerIndex);
                    LineRacerState.this.setPlayerCollsionCounter(player, counter);
                }
            }
        });
    }

    @Override
    public String toNetworkString() {
        Document doc = HGBaseXMLTools.createDocument();
        Element root = doc.createElement(XMLKEY_GAMESTATE_NODE);
        doc.appendChild(root);
        this.save(doc, root);
        try {
            String str = HGBaseXMLTools.transformDocument(doc, false).replace("\n", NEWLINE_REPLACEMENT);
            return str;
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            return null;
        }
    }

    @Override
    public boolean fromNetworkString(String data) {
        try {
            DocumentBuilder build = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = build.parse(new ByteArrayInputStream(data.replace(NEWLINE_REPLACEMENT, "\n").getBytes()));
            this.load(doc.getDocumentElement());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
        return true;
    }

    @Override
    public String toNetworkStringMove(MoveInformation move) {
        String networkString = null;
        if (move instanceof DriveMove) {
            DriveMove driveMove = (DriveMove)move;
            StringBuffer sb = new StringBuffer();
            sb.append(driveMove.getPos().x);
            sb.append(";");
            sb.append(driveMove.getPos().y);
            sb.append(";");
            sb.append(driveMove.causesCollision());
            networkString = sb.toString();
        }
        return networkString;
    }

    @Override
    public MoveInformation fromNetworkStringMove(String data) {
        StringTokenizer tokens = new StringTokenizer(data, ";");
        if (tokens.countTokens() != 3) {
            return null;
        }
        return new DriveMove(new Point(Integer.valueOf(tokens.nextToken()), Integer.valueOf(tokens.nextToken())), Boolean.valueOf(tokens.nextToken()));
    }

    @Override
    public Object clone() {
        return null;
    }

    private int calcScore(GamePlayer player) {
        return GameEngine.getInstance().getActivePlayers(true).length * (this.hasPlayerFinished(player) ? 1 : -1);
    }

    private void checkCrossedCheckLine(GamePlayer player, Line drivenLine) {
        Line[] checkLines = this.track.getCheckLines();
        int lineIndex = 0;
        while (lineIndex < checkLines.length) {
            if (drivenLine.intersectsLine(checkLines[lineIndex])) {
                this.setPlayerCrossedCheckLine(player, lineIndex, true);
            }
            ++lineIndex;
        }
    }

    private void checkCrossedFinishLine(GamePlayer player, Line drivenLine) {
        Point playerStartPosition = this.getPlayerStartPosition(player);
        if (playerStartPosition == null || playerStartPosition.equals(drivenLine.getStartPos())) {
            return;
        }
        if (drivenLine.intersectsLine(this.track.getFinishLine()) && this.hasPlayerCrossedAllCheckLines(player)) {
            this.setPlayerHasFinished(player);
            this.dropOutPlayer(player);
        }
    }

    private void playAudio(String media) {
        MainFrame frame = GameManager.getInstance().getMainFrame();
        frame.playAudio(media);
    }

    private void playMoveAudio(boolean finished, boolean collision) {
        String media = finished ? SOUND_FINISH : (collision ? SOUND_COLLISION : SOUND_MOVE);
        this.playAudio(media);
    }

    private void dropOutPlayer(GamePlayer player) {
        player.setDropOut(true);
        player.setScore(this.calcScore(player), 4);
    }
}

