/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.ui.dialog;

import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.game.LineRacerState;
import hgb.lib.HGBaseText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;
import tjger.gui.GameDialogs;
import tjger.gui.internal.PartsDlg;
import tjger.gui.internal.PreviewPanel;

public class LineRacerGameDialogs
extends GameDialogs {
    @Override
    public PreviewPanel getPreviewPanel(PartsDlg dlg, int width, int height) {
        return null;
    }

    @Override
    protected void createPlayerScorePanel(JPanel pnInfo, int rank, GamePlayer p, int scoreType) {
        GameEngine engine = GameEngine.getInstance();
        LineRacerState state = (LineRacerState)engine.getGameState();
        JPanel pnDummy = new JPanel(new BorderLayout());
        pnDummy.add((Component)this.createPlayerScorePanelRank(rank), "West");
        JPanel pnPlayer = new JPanel(new BorderLayout());
        pnPlayer.add((Component)this.createPlayerScorePanelIconName(engine, p), "Center");
        pnPlayer.add((Component)this.createPlayerScorePanelTrophy(rank, state.hasPlayerFinished(p)), "East");
        pnDummy.add((Component)pnPlayer, "Center");
        pnInfo.add(pnDummy);
    }

    protected JComponent createPlayerScorePanelIconName(GameEngine engine, GamePlayer player) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.createPlayerScorePanelIcon(engine, player));
        panel.add(this.createPlayerScorePanelName(player));
        return panel;
    }

    protected JComponent createPlayerScorePanelIcon(GameEngine engine, GamePlayer player) {
        return new JLabel(LineRacerUtils.createPlayerColorIcon(LineRacerUtils.getPlayerLaneColor(engine, player)));
    }

    private JPanel createPlayerScorePanelTrophy(int rank, boolean playerHasFinished) {
        String text = null;
        Icon icon = null;
        if (!playerHasFinished) {
            text = HGBaseText.getText("label_did_not_finish", new String[0]);
        } else {
            icon = LineRacerUtils.getRankIcon(rank);
        }
        if (text == null && icon == null) {
            return new JPanel();
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(text, icon, 0), "Center");
        return panel;
    }
}

