/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.ui.dialog;

import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.common.TrackLoader;
import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import hgb.gui.config.HGBaseConfigCheckBox;
import hgb.gui.config.HGBaseConfigSlider;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import hgb.lib.XmlFilesFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tjger.game.completed.GameManager;
import tjger.gui.NewGameDialog;

public class LineRacerNewGameDialog
extends NewGameDialog {
    private static final String TRACKS_FOLDER_NAME = "tracks";
    private static final String CONFIGKEY_TRACKS_FOLDER = "tracksfolder";
    private static Track selectedTrack;
    private JList<Track> trackList;
    private JTextArea trackDescription;
    private JLabel trackAuthor;
    private HGBaseConfigSlider collisionSkipNumber;
    private HGBaseConfigCheckBox damageOnCollision;
    private HGBaseConfigSlider maxCollisions;

    public LineRacerNewGameDialog(HGBaseFrame mainFrame, String askToSave) {
        super(mainFrame, askToSave);
        selectedTrack = null;
        this.trackDescription = new JTextArea(5, 30);
        this.trackDescription.setEditable(false);
        this.trackAuthor = new JLabel();
        this.trackList = this.createTrackList();
        this.collisionSkipNumber = new HGBaseConfigSlider("gameinfo.collisionskipnumber", 0, 5, 2);
        this.damageOnCollision = new HGBaseConfigCheckBox("label_damage_on_collision", "gameinfo.damageoncollision", "1");
        this.damageOnCollision.addActionListener(this);
        this.maxCollisions = new HGBaseConfigSlider("gameinfo.maxcollisionsnumber", 0, 5, 2);
        boolean isNetworkClient = this.isNetworkClient();
        this.enableTrackSelection(!isNetworkClient);
        this.enableRulesConfig(!isNetworkClient);
    }

    private void setSelectedTrack(Track track) {
        selectedTrack = track;
        if (selectedTrack == null) {
            this.trackDescription.setText(null);
            this.trackAuthor.setText(null);
        } else {
            this.trackDescription.setText(selectedTrack.isDescriptionAvailable(HGBaseText.getLanguage()) ? selectedTrack.getDescription(HGBaseText.getLanguage()) : selectedTrack.getFirstDescription());
            this.trackDescription.setCaretPosition(0);
            this.trackAuthor.setText(selectedTrack.getAuthor());
        }
        this.checkState();
    }

    public static Track getSelectedTrack() {
        return selectedTrack;
    }

    public static void setTrack(Track selectedTrack) {
        LineRacerNewGameDialog.selectedTrack = selectedTrack;
    }

    @Override
    protected void createComponents(HGBasePanel pnDialog) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getDefaultPanel(), "Center");
        panel.add((Component)this.createAddConfigTabSetPanel(), "South");
        pnDialog.add(panel);
    }

    private JPanel createAddConfigTabSetPanel() {
        JTabbedPane tabSet = new JTabbedPane();
        tabSet.add(HGBaseText.getText("label_track_selection", new String[0]), this.createTrackSelectionPanel());
        tabSet.add(HGBaseText.getText("label_rules", new String[0]), this.createRulesPanel());
        JPanel panel = new JPanel();
        panel.add(tabSet);
        return panel;
    }

    private JPanel createTrackSelectionPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JScrollPane scrollPane = new JScrollPane(this.trackList, 22, 32);
        scrollPane.setPreferredSize(new Dimension(300, 0));
        panel.add((Component)scrollPane, "West");
        panel.add((Component)this.createTrackDetailsPanel(), "Center");
        return panel;
    }

    private JPanel createRulesPanel() {
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 1);
        panel.setLayout(layout);
        panel.add(this.createCollisionSkipNumberPanel());
        panel.add(this.createDamageOnCollisionPanel());
        return panel;
    }

    private JPanel createCollisionSkipNumberPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(HGBaseText.getText("label_collisionskipnumber", new String[0])));
        panel.add(this.collisionSkipNumber);
        return panel;
    }

    private JPanel createDamageOnCollisionPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.damageOnCollision);
        panel.add(new JLabel(HGBaseText.getText("label_max_collisions_number", new String[0])));
        panel.add(this.maxCollisions);
        return panel;
    }

    private JList<Track> createTrackList() {
        JList<Track> trackList = new JList<Track>(this.getAvailableTracks());
        trackList.setCellRenderer(new TrackListCellRenderer());
        trackList.setSelectionMode(0);
        trackList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (!ev.getValueIsAdjusting()) {
                    LineRacerNewGameDialog.this.setSelectedTrack((Track)((JList)ev.getSource()).getSelectedValue());
                }
            }
        });
        return trackList;
    }

    private JPanel createTrackDetailsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.trackDescription, 22, 32), "Center");
        panel.add((Component)this.createTrackAuthorPanel(), "South");
        return panel;
    }

    private JPanel createTrackAuthorPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(HGBaseText.getText("label_author", new String[0])));
        panel.add(this.trackAuthor);
        return panel;
    }

    private Path getTracksFolder() {
        Path trackFolder;
        String folderPath = HGBaseConfig.get(CONFIGKEY_TRACKS_FOLDER);
        Path path = trackFolder = HGBaseTools.hasContent(folderPath) ? Paths.get(folderPath, new String[0]) : null;
        if (!HGBaseFileTools.isFolder(trackFolder)) {
            trackFolder = Paths.get(HGBaseFileTools.getCurrentDir(), TRACKS_FOLDER_NAME);
        }
        if (!HGBaseFileTools.isFolder(trackFolder)) {
            trackFolder = Paths.get(HGBaseFileTools.getExecutionDir(this), TRACKS_FOLDER_NAME);
        }
        if (!HGBaseFileTools.isFolder(trackFolder)) {
            HGBaseDialog.printError("err_tracks_folder_not_found", (JFrame)this.getMainFrame());
            JFileChooser folderChooser = HGBaseGuiTools.createFolderChooser(null);
            int result = folderChooser.showOpenDialog(this.getMainFrame());
            trackFolder = result == 0 ? folderChooser.getSelectedFile().toPath() : null;
        }
        HGBaseConfig.set(CONFIGKEY_TRACKS_FOLDER, trackFolder != null ? trackFolder.toString() : "");
        return trackFolder;
    }

    private Track[] getAvailableTracks() {
        Vector<Path> trackFiles = HGBaseFileTools.getFolderEntries(this.getTracksFolder(), new XmlFilesFilter(), true);
        if (trackFiles == null) {
            return new Track[0];
        }
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (Path trackFile : trackFiles) {
            tracks.add(TrackLoader.loadTrack(trackFile.toString()));
        }
        return tracks.toArray(new Track[0]);
    }

    @Override
    protected boolean canLeave() {
        if (!super.canLeave()) {
            return false;
        }
        if (!this.isNetworkClient()) {
            if (selectedTrack == null) {
                this.setErrorMessage(HGBaseText.getText("err_no_track_selected", new String[0]));
                return false;
            }
            if (selectedTrack.getTrackProblems().length > 0) {
                this.setErrorMessage(HGBaseText.getText("err_invalid_track_selected", new String[0]));
                return false;
            }
        }
        return true;
    }

    @Override
    protected JPanel getNetworkPanel() {
        JPanel networkPanel = super.getNetworkPanel();
        boolean isNetworkClient = this.isNetworkClient();
        this.enableTrackSelection(!isNetworkClient);
        this.enableRulesConfig(!isNetworkClient);
        return networkPanel;
    }

    @Override
    protected void onNetworkModeChanged() {
        super.onNetworkModeChanged();
        boolean isNetworkClient = this.isNetworkClient();
        this.enableTrackSelection(!isNetworkClient);
        this.enableRulesConfig(!isNetworkClient);
    }

    private void enableTrackSelection(boolean enable) {
        this.trackList.setEnabled(enable);
        if (!enable) {
            this.trackList.clearSelection();
        }
    }

    private void enableRulesConfig(boolean enable) {
        this.collisionSkipNumber.setEnabled(enable);
        this.damageOnCollision.setEnabled(enable);
        this.maxCollisions.setEnabled(enable && this.damageOnCollision.isSelected());
    }

    @Override
    protected void okPressed() {
        super.okPressed();
        GameManager manager = GameManager.getInstance();
        manager.setNewGameInformation("gameinfo.collisionskipnumber", this.collisionSkipNumber.getValue());
        manager.setNewGameInformation("gameinfo.damageoncollision", this.damageOnCollision.getValue());
        manager.setNewGameInformation("gameinfo.maxcollisionsnumber", this.maxCollisions.getValue());
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource().equals(this.damageOnCollision)) {
            this.maxCollisions.setEnabled(!this.isNetworkClient() && this.damageOnCollision.isSelected());
        }
        super.actionPerformed(ev);
    }

    private class TrackListCellRenderer
    extends DefaultListCellRenderer {
        private TrackListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (renderer instanceof JLabel && value instanceof Track) {
                JLabel label = (JLabel)renderer;
                Track track = (Track)value;
                label.setText(HGBaseText.getText("track_list_entry", track.getName(), track.getVersion()));
                label.setHorizontalTextPosition(4);
                label.setVerticalTextPosition(0);
                label.setIcon(HGBaseGuiTools.loadImage(track.getTrackProblems().length > 0 ? "/gfx/error.png" : "/gfx/no_error.png"));
            }
            return renderer;
        }
    }
}

