/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.ui.frame;

import com.tjger.lineracer.desktop.common.AbstractLineRacerGameState;
import com.tjger.lineracer.desktop.common.ShowHideBackgroundImage;
import com.tjger.lineracer.desktop.ui.dialog.LineRacerNewGameDialog;
import com.tjger.lineracer.desktop.ui.frame.LineRacerStatusBar;
import com.tjger.lineracer.desktop.ui.game.LineRacerGamePanel;
import com.tjger.lineracer.desktop.ui.game.LineRacerMainPanel;
import com.tjger.lineracer.desktop.ui.menu.LineRacerMainMenu;
import com.tjger.lineracer.desktop.ui.menu.LineRacerShowPartsDlgAction;
import hgb.lib.HGBaseLog;
import java.io.File;
import tjger.MainFrame;
import tjger.lib.GameConfigurationException;

public class LineRacerMainFrame
extends MainFrame {
    public static final String MENU_ID_SHOW_HIDE_BACKGROUND_IMAGE = "settings.showhidebackgroundimage";

    public LineRacerMainFrame() throws GameConfigurationException {
        super("/xml/settings.xml");
        this.setStatusBar(new LineRacerStatusBar(this));
        LineRacerMainMenu menu = new LineRacerMainMenu(this);
        this.setMenu(menu);
        this.setPanels(new LineRacerMainPanel(), new LineRacerGamePanel());
        menu.registerAction("settings.parts", new LineRacerShowPartsDlgAction(menu));
        menu.registerAction(MENU_ID_SHOW_HIDE_BACKGROUND_IMAGE, new ShowHideBackgroundImage(menu));
        menu.setItemEnabled(MENU_ID_SHOW_HIDE_BACKGROUND_IMAGE, false);
    }

    public static void main(String[] args) {
        try {
            LineRacerMainFrame main = new LineRacerMainFrame();
            main.testCommandLineForFile(args);
        }
        catch (GameConfigurationException e) {
            HGBaseLog.logError("Could not start the game: " + e.getMessage());
        }
    }

    private void enableMenuItems(boolean enabled) {
        AbstractLineRacerGameState state = this.getLineRacerState();
        this.getMainMenu().setItemEnabled(MENU_ID_SHOW_HIDE_BACKGROUND_IMAGE, enabled && state.isShowHideBackgroundImageAllowed());
    }

    private AbstractLineRacerGameState getLineRacerState() {
        return (AbstractLineRacerGameState)this.getGameManager().getGameState();
    }

    @Override
    public int onFileNew() {
        int ret = super.onFileNew();
        if (ret == 0) {
            this.enableMenuItems(true);
        }
        return ret;
    }

    @Override
    public int onFileClose() {
        int ret = super.onFileClose();
        if (ret == 0) {
            this.enableMenuItems(false);
        }
        return ret;
    }

    @Override
    public int onFileOpen(File file) {
        int ret = super.onFileOpen(file);
        if (ret == 0) {
            LineRacerNewGameDialog.setTrack(this.getLineRacerState().getTrack());
            this.enableMenuItems(true);
        }
        return ret;
    }

    public void onFileNext() {
        this.enableMenuItems(true);
    }
}

