/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.ui.frame;

import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.common.Vector;
import java.awt.Point;
import javax.swing.Icon;
import tjger.MainFrame;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.lib.SimpleStatusBar;

public class LineRacerStatusBar
extends SimpleStatusBar {
    private static final int GRID_POS_PANEL_INDEX = 0;
    private static final int VECTOR_PANEL_INDEX = 1;
    private static final int INFO_PANEL_INDEX = 2;
    private static final int ZOOM_PANEL_INDEX = 3;
    private static final int PROGRESS_PANEL_INDEX = 4;
    private static final String ARROW_LEFT = "\u2190";
    private static final String ARROW_RIGHT = "\u2192";
    private static final String ARROW_LEFT_RIGHT = "\u21c4";
    private static final String ARROW_UP = "\u2191";
    private static final String ARROW_DOWN = "\u2193";
    private static final String ARROW_UP_DOWN = "\u21c5";

    public LineRacerStatusBar(MainFrame frame) {
        int[] nArray = new int[5];
        nArray[0] = 50;
        nArray[1] = 70;
        nArray[3] = 50;
        nArray[4] = 100;
        super(nArray, frame);
        this.setZoomPanel(3);
        this.setProgressPanel(4);
    }

    public static void setPositionInfo(Point gridPos) {
        GameManager.getInstance().getMainFrame().setStatusText(0, gridPos == null ? "" : String.valueOf(gridPos.x) + "/" + gridPos.y);
    }

    public static void setVectorInfo(Vector vector) {
        GameManager.getInstance().getMainFrame().setStatusText(1, vector == null ? "" : String.valueOf(vector.getDeltaX() < 0 ? ARROW_LEFT : (vector.getDeltaX() > 0 ? ARROW_RIGHT : ARROW_LEFT_RIGHT)) + Math.abs(vector.getDeltaX()) + " " + (vector.getDeltaY() < 0 ? ARROW_UP : (vector.getDeltaY() > 0 ? ARROW_DOWN : ARROW_UP_DOWN)) + Math.abs(vector.getDeltaY()));
    }

    private Icon createPlayerColorIcon() {
        GameEngine gameEngine = GameEngine.getInstance();
        if (!gameEngine.isActiveGame() || !gameEngine.isActiveRound()) {
            return null;
        }
        return LineRacerUtils.createPlayerColorIcon(LineRacerUtils.getCurrentPlayerLaneColor());
    }

    @Override
    public void actualizeText() {
        super.actualizeText();
        this.getLabel(2).setIcon(this.createPlayerColorIcon());
    }
}

