/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.ui.game;

import com.tjger.lineracer.desktop.game.DriveMove;
import com.tjger.lineracer.desktop.game.DrivePosition;
import com.tjger.lineracer.desktop.ui.game.LineRacerGamePanel;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import tjger.game.completed.GameEngine;

public class GamePanelKeyListener
extends KeyAdapter {
    private static final int INDEX_POS_TOP_LEFT = 0;
    private static final int INDEX_POS_TOP_CENTER = 3;
    private static final int INDEX_POS_TOP_RIGHT = 6;
    private static final int INDEX_POS_MIDDLE_LEFT = 1;
    private static final int INDEX_POS_MIDDLE_CENTER = 4;
    private static final int INDEX_POS_MIDDLE_RIGHT = 7;
    private static final int INDEX_POS_BOTTOM_LEFT = 2;
    private static final int INDEX_POS_BOTTOM_CENTER = 5;
    private static final int INDEX_POS_BOTTOM_RIGHT = 8;
    private LineRacerGamePanel gamePanel;
    private GameEngine gameEngine;

    public GamePanelKeyListener(LineRacerGamePanel gamePanel, GameEngine gameEngine) {
        this.gamePanel = gamePanel;
        this.gameEngine = gameEngine;
    }

    @Override
    public void keyPressed(KeyEvent ev) {
        super.keyPressed(ev);
        if (!this.gamePanel.isRunningGame() || !this.gamePanel.isHumanActionAllowed()) {
            return;
        }
        if (ev.getKeyCode() == 10) {
            if (this.gamePanel.isPositionPossible(this.gamePanel.getPointedGridPos())) {
                this.performDriveMove(this.gamePanel.getPointedGridPos());
            }
            return;
        }
        if (this.handlePositionKey(ev.getKeyCode())) {
            return;
        }
    }

    private boolean handlePositionKey(int keyCode) {
        int posIndex = this.getPositionIndex(keyCode);
        if (posIndex == -1) {
            return false;
        }
        DrivePosition drivePosition = this.getDrivePosition(posIndex);
        if (drivePosition != null && drivePosition.isPossible()) {
            if (drivePosition.getPos().equals(this.gamePanel.getPointedGridPos())) {
                this.performDriveMove(drivePosition);
                return true;
            }
            this.gamePanel.setPointedGridPos(drivePosition.getPos());
            this.gamePanel.repaint();
            return true;
        }
        return false;
    }

    private int getPositionIndex(int keyCode) {
        switch (keyCode) {
            case 49: 
            case 97: {
                return 2;
            }
            case 50: 
            case 98: {
                return 5;
            }
            case 51: 
            case 99: {
                return 8;
            }
            case 52: 
            case 100: {
                return 1;
            }
            case 53: 
            case 101: {
                return 4;
            }
            case 54: 
            case 102: {
                return 7;
            }
            case 55: 
            case 103: {
                return 0;
            }
            case 56: 
            case 104: {
                return 3;
            }
            case 57: 
            case 105: {
                return 6;
            }
        }
        return -1;
    }

    private DrivePosition getDrivePosition(int index) {
        DrivePosition[] drivePositions = this.gamePanel.getDrivePositions();
        if (drivePositions.length == 1) {
            if (index == 4) {
                return drivePositions[0];
            }
            return null;
        }
        if (index < drivePositions.length) {
            return drivePositions[index];
        }
        return null;
    }

    private void performDriveMove(DrivePosition drivePosition) {
        this.performDriveMove(drivePosition.getPos(), drivePosition.causesCollision());
    }

    private void performDriveMove(Point pos) {
        this.performDriveMove(pos, this.gamePanel.causesCollision(pos));
    }

    private void performDriveMove(Point pos, boolean causesCollision) {
        this.gameEngine.getCurrentPlayer().performMove(new DriveMove(pos, causesCollision));
    }
}

