/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.ui.game;

import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.game.DriveMove;
import com.tjger.lineracer.desktop.game.LineRacerState;
import com.tjger.lineracer.desktop.ui.game.LineRacerGamePanel;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;

public class GamePanelMouseListener
extends MouseAdapter {
    private LineRacerGamePanel gamePanel;
    private GameEngine gameEngine;
    private LineRacerState gameState;

    public GamePanelMouseListener(LineRacerGamePanel gamePanel, GameEngine gameEngine, LineRacerState gameState) {
        this.gamePanel = gamePanel;
        this.gameEngine = gameEngine;
        this.gameState = gameState;
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        super.mouseClicked(ev);
        if (!this.gamePanel.isRunningGame() || !this.gamePanel.isHumanActionAllowed()) {
            return;
        }
        if (ev.getClickCount() == 1 && ev.getButton() == 1) {
            Point pos = this.gamePanel.getPointedGridPos();
            GamePlayer currentPlayer = this.gameEngine.getCurrentPlayer();
            if (LineRacerUtils.isPointInArray(this.gamePanel.getPossiblePositions(), pos)) {
                currentPlayer.performMove(new DriveMove(pos, this.gamePanel.causesCollision(pos)));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        super.mouseMoved(ev);
        if (this.gamePanel.isRunningGame()) {
            this.setPointedGridPos();
        }
    }

    private void setPointedGridPos() {
        Point pos = this.gamePanel.convertScreenPosToGridPos(new Point(this.gamePanel.getMouseX(), this.gamePanel.getMouseY()), this.gameState.getTrack().getGridSize());
        if (pos != null && !pos.equals(this.gamePanel.getPointedGridPos())) {
            this.gamePanel.setPointedGridPos(pos);
            this.gamePanel.repaint();
        }
    }
}

