/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.ui.game;

import com.tjger.lineracer.desktop.common.AbstractLineRacerGamePanel;
import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.game.DrivePosition;
import com.tjger.lineracer.desktop.game.LineRacerRules;
import com.tjger.lineracer.desktop.game.LineRacerState;
import com.tjger.lineracer.desktop.ui.frame.LineRacerStatusBar;
import com.tjger.lineracer.desktop.ui.game.GamePanelKeyListener;
import com.tjger.lineracer.desktop.ui.game.GamePanelMouseListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.GameStateListener;
import tjger.game.completed.GameEngine;

public class LineRacerGamePanel
extends AbstractLineRacerGamePanel
implements GameStateListener {
    private static final int POINTED_GRID_POS_DOT_SIZE = 6;
    private static final int PLAYER_LANE_DOT_SIZE = 8;
    private static final int POSSIBLE_POSITION_DOT_SIZE = 6;
    private static final Color NOT_POSSIBLE_POSITION_DOT_COLOR = new Color(220, 220, 220);
    private DrivePosition[] drivePositions;

    public LineRacerGamePanel() {
        GameEngine engine = this.getGameEngine();
        GamePanelMouseListener mouseListener = new GamePanelMouseListener(this, engine, this.getLineRacerGameState());
        this.addMouseMotionListener(mouseListener);
        this.addMouseListener(mouseListener);
        this.addKeyListener(new GamePanelKeyListener(this, engine));
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        engine.addGameStateListener(this);
    }

    @Override
    public void setPointedGridPos(Point pointedGridPos) {
        super.setPointedGridPos(pointedGridPos);
        LineRacerStatusBar.setPositionInfo(pointedGridPos);
        if (LineRacerGamePanel.isPositionPossible(this.drivePositions, pointedGridPos)) {
            LineRacerState state = this.getLineRacerGameState();
            GamePlayer currentPlayer = this.getGameEngine().getCurrentPlayer();
            LineRacerStatusBar.setVectorInfo(new Line(state.getPlayerLastLanePosition(currentPlayer), pointedGridPos).getVector());
        } else {
            LineRacerStatusBar.setVectorInfo(null);
        }
    }

    public DrivePosition[] getDrivePositions() {
        return this.drivePositions;
    }

    public Point[] getPossiblePositions() {
        return DrivePosition.getPossiblePositions(this.drivePositions);
    }

    public boolean causesCollision(Point pos) {
        if (pos == null) {
            return false;
        }
        DrivePosition[] drivePositionArray = this.drivePositions;
        int n = this.drivePositions.length;
        int n2 = 0;
        while (n2 < n) {
            DrivePosition drivePos = drivePositionArray[n2];
            if (pos.equals(drivePos.getPos())) {
                return drivePos.causesCollision();
            }
            ++n2;
        }
        return false;
    }

    private LineRacerState getLineRacerGameState() {
        return (LineRacerState)this.getGameState();
    }

    private LineRacerRules getLineRacerGameRules() {
        return (LineRacerRules)this.getGameRules();
    }

    public boolean isHumanActionAllowed() {
        return this.isHumanPlayer();
    }

    @Override
    public void newGameStarted(GameState state, GameEngine engine) {
        this.setPointedGridPos(null);
        LineRacerState lineRacerState = (LineRacerState)state;
        int gridSize = lineRacerState.getTrack().getGridSize();
        this.calcMaxGridPos(gridSize);
    }

    @Override
    public void newRoundStarted(GameState state, GameEngine engine) {
    }

    @Override
    public void newTurnStarted(GameState state, GameEngine engine) {
    }

    @Override
    public void gameFinished(boolean normal) {
        this.setPointedGridPos(null);
    }

    @Override
    public void gameStateBeforeMove(GameState state, GameEngine engine) {
        LineRacerState lineRacerState = (LineRacerState)state;
        Track track = lineRacerState.getTrack();
        this.drivePositions = this.getLineRacerGameRules().getPossiblePositions(engine.getCurrentPlayer(), lineRacerState, track);
    }

    @Override
    public void gameStateAfterMove(GameState state, GameEngine engine) {
    }

    @Override
    public boolean isPaintingAllowed() {
        GameEngine gameEngine = this.getGameEngine();
        return gameEngine.isActiveGame() || !gameEngine.isStoppedGame();
    }

    public boolean isRunningGame() {
        return this.isPaintingAllowed();
    }

    @Override
    protected void paintParts(Graphics g) {
        super.paintParts(g);
        if (this.isPaintingAllowed()) {
            LineRacerState state = this.getLineRacerGameState();
            int gridSize = state.getGridSize();
            GamePlayer[] players = this.getGameEngine().getActivePlayers();
            GamePlayer currentPlayer = this.getGameEngine().getCurrentPlayer();
            Point lastLanePosition = state.getPlayerLastLanePosition(currentPlayer);
            this.paintPlayerLanes(players, state, gridSize, g);
            if (this.isHumanPlayer()) {
                this.paintPlayerPointedGridPosLane(lastLanePosition, this.drivePositions, this.getPointedGridPos(), this.getPlayerPointedLaneColor(currentPlayer), gridSize, g);
                this.paintDrivePositions(this.drivePositions, gridSize, g);
            }
            this.paintPointedGridPos(this.getPointedGridPos(), gridSize, g);
        }
    }

    private Color getPlayerLaneColor(int playerIndex) {
        return LineRacerUtils.getPlayerLaneColor(this.getGameConfig(), playerIndex);
    }

    private Color getPlayerLaneColor(GamePlayer player) {
        return LineRacerUtils.getPlayerLaneColor(this.getGameEngine(), player);
    }

    private Color getPlayerPointedLaneColor(GamePlayer player) {
        return this.getPlayerLaneColor(player);
    }

    public boolean isPositionPossible(Point position) {
        return LineRacerGamePanel.isPositionPossible(this.drivePositions, position);
    }

    private static boolean isPositionPossible(DrivePosition[] positions, Point position) {
        Point[] possiblePoints = DrivePosition.getPossiblePositions(positions);
        return LineRacerUtils.isPointInArray(possiblePoints, position);
    }

    private void paintPlayerLanes(GamePlayer[] players, LineRacerState state, int gridSize, Graphics g) {
        int currentPlayerIndex = this.getGameEngine().getCurrentPlayerIndex();
        int playerIndex = 0;
        while (playerIndex < players.length) {
            if (playerIndex != currentPlayerIndex) {
                this.paintPlayerLane(state.getPlayerLanePositions(players[playerIndex]), this.getPlayerLaneColor(playerIndex), gridSize, g);
            }
            ++playerIndex;
        }
        if (currentPlayerIndex >= 0) {
            this.paintPlayerLane(state.getPlayerLanePositions(players[currentPlayerIndex]), this.getPlayerLaneColor(currentPlayerIndex), gridSize, g);
        }
    }

    private void paintPlayerLane(Point[] lanePositions, Color color, int gridSize, Graphics g) {
        Color oldColor = this.changeColor(color, g);
        Point lastPosition = null;
        Point[] pointArray = lanePositions;
        int n = lanePositions.length;
        int n2 = 0;
        while (n2 < n) {
            Point position = pointArray[n2];
            this.paintGridDot(position, 8, gridSize, g);
            if (lastPosition != null) {
                this.paintGridLine(lastPosition, position, gridSize, g);
            }
            lastPosition = position;
            ++n2;
        }
        this.changeColor(oldColor, g);
    }

    private void paintPlayerPointedGridPosLane(Point lastLanePosition, DrivePosition[] possiblePositions, Point pointedGridPos, Color laneColor, int gridSize, Graphics g) {
        if (pointedGridPos == null || possiblePositions == null) {
            return;
        }
        if (LineRacerGamePanel.isPositionPossible(possiblePositions, pointedGridPos)) {
            Color oldColor = this.changeColor(laneColor, g);
            this.paintGridLine(lastLanePosition, pointedGridPos, gridSize, g);
            this.changeColor(oldColor, g);
        }
    }

    private void paintDrivePositions(DrivePosition[] drivePositions, int gridSize, Graphics g) {
        if (drivePositions == null) {
            return;
        }
        Point[] possiblePoints = DrivePosition.getPossiblePositions(drivePositions);
        Point[] notPossiblePoints = DrivePosition.getNotPossiblePositions(drivePositions);
        this.paintGridDots(possiblePoints, 6, this.getGameConfig().getActiveColor("color_possible_pos_dot"), gridSize, g);
        this.paintGridDots(notPossiblePoints, 6, NOT_POSSIBLE_POSITION_DOT_COLOR, gridSize, g);
    }

    private void paintPointedGridPos(Point pos, int gridSize, Graphics g) {
        if (pos == null) {
            return;
        }
        Color oldColor = this.changeColor(Color.RED.darker(), g);
        this.paintGridDot(pos, 6, gridSize, g);
        this.changeColor(oldColor, g);
    }
}

