/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.ui.game;

import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.game.LineRacerState;
import hgb.lib.HGBaseText;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;
import tjger.gui.completed.PlayerStatePanel;
import tjger.lib.ScoreUtil;

public class LineRacerPlayerStatePanel
extends PlayerStatePanel {
    public LineRacerPlayerStatePanel() {
        super(true, PlayerStatePanel.Info.PLAYER_TYPE, PlayerStatePanel.Info.PLAYER_ICON, PlayerStatePanel.Info.PLAYER_NAME, PlayerStatePanel.Info.SCORE_ROUND, PlayerStatePanel.Info.SCORE_TURN, PlayerStatePanel.Info.PLAYER_PIECE);
    }

    @Override
    protected Dimension getInfoPreferredSize(PlayerStatePanel.Info info, int rowHeight) {
        if (PlayerStatePanel.Info.PLAYER_ICON.equals((Object)info)) {
            return new Dimension(15, rowHeight);
        }
        if (PlayerStatePanel.Info.PLAYER_PIECE.equals((Object)info)) {
            return new Dimension(40, rowHeight);
        }
        return null;
    }

    @Override
    protected int getHorizontalAlignment(PlayerStatePanel.Info info) {
        if (PlayerStatePanel.Info.PLAYER_PIECE.equals((Object)info)) {
            return 11;
        }
        return super.getHorizontalAlignment(info);
    }

    @Override
    protected Object getInfoData(PlayerStatePanel.Info info, GamePlayer player, GameEngine engine) {
        if (PlayerStatePanel.Info.PLAYER_ICON.equals((Object)info)) {
            return LineRacerUtils.createPlayerColorIcon(LineRacerUtils.getPlayerLaneColor(engine, player));
        }
        if (PlayerStatePanel.Info.PLAYER_PIECE.equals((Object)info)) {
            LineRacerState state = (LineRacerState)engine.getGameState();
            if (state.hasPlayerFinished(player)) {
                int rank = ScoreUtil.getPlayerRank(4, engine.getActivePlayers(), player);
                Icon rankIcon = LineRacerUtils.getRankIcon(rank);
                return rankIcon != null ? rankIcon : String.valueOf(rank);
            }
            if (player.isDropOut()) {
                return HGBaseText.getText("label_did_not_finish", new String[0]);
            }
            return null;
        }
        if (PlayerStatePanel.Info.SCORE_TURN.equals((Object)info)) {
            LineRacerState state = (LineRacerState)engine.getGameState();
            return String.valueOf(state.getPlayerCollisionCounter(player));
        }
        return super.getInfoData(info, player, engine);
    }

    @Override
    protected void renderInfo(PlayerStatePanel.Info info, JComponent comp, Object data) {
        if (PlayerStatePanel.Info.PLAYER_PIECE.equals((Object)info)) {
            Icon icon = null;
            String text = null;
            if (data instanceof Icon) {
                icon = (Icon)data;
            } else if (data instanceof String) {
                text = (String)data;
            }
            ((JLabel)comp).setIcon(icon);
            ((JLabel)comp).setText(text);
        } else {
            super.renderInfo(info, comp, data);
        }
    }
}

