/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.config.HGBaseConfigItem;
import hgb.gui.util.fontchooser.HGBaseFontChooser;
import hgb.gui.util.fontchooser.HGBaseFontStyle;
import hgb.lib.HGBaseConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HGBaseConfigFontChooser
extends JPanel
implements HGBaseConfigItem {
    private static final long serialVersionUID = -8637992688334220915L;
    private static final String FONT_STRING_SEPARATOR = ", ";
    private static final String FONT_ATTRIBUTE_SEPARATOR = Character.toString('\u001e');
    private static final int GAP = 5;
    public static final String PROPERTY_FONT = "hgbfont";
    private JLabel lbFont;
    private JButton btFont;
    private Frame parent;
    private String option;
    private Font font;

    public HGBaseConfigFontChooser(Frame parent, String option, Font defaultFont) {
        this(parent, option, defaultFont, "...");
    }

    public HGBaseConfigFontChooser(Frame parent, String option, Font defaultFont, String btLabel) {
        this(parent, option, defaultFont, btLabel, null);
    }

    public HGBaseConfigFontChooser(Frame parent, String option, Font defaultFont, Icon btIcon) {
        this(parent, option, defaultFont, null, btIcon);
    }

    private HGBaseConfigFontChooser(Frame parent, String option, Font defaultFont, String btLabel, Icon btIcon) {
        super(new BorderLayout());
        this.createFontDisplayField();
        this.createFontChooserButton(btLabel, btIcon);
        this.setParentFrame(parent);
        this.setOption(option);
        this.add((Component)this.createFontChooserPanel(), "Center");
        this.loadOption(defaultFont);
    }

    private void propertyChange(Font oldFont, Font newFont) {
        PropertyChangeListener[] listeners = super.getPropertyChangeListeners(PROPERTY_FONT);
        PropertyChangeEvent ev = new PropertyChangeEvent(this, PROPERTY_FONT, oldFont, newFont);
        PropertyChangeListener[] propertyChangeListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            l.propertyChange(ev);
            ++n2;
        }
    }

    protected void setParentFrame(Frame parent) {
        this.parent = parent;
    }

    protected Frame getParentFrame() {
        return this.parent;
    }

    protected void createFontDisplayField() {
        this.lbFont = new JLabel();
    }

    protected JLabel getFontDisplayField() {
        return this.lbFont;
    }

    protected void createFontChooserButton(String btLabel, Icon btIcon) {
        this.btFont = btLabel != null ? new JButton(btLabel) : new JButton(btIcon);
        this.btFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Font oldFont = HGBaseConfigFontChooser.this.getSelectedFont();
                Font newFont = HGBaseFontChooser.showDialog(HGBaseConfigFontChooser.this.getParentFrame(), HGBaseConfigFontChooser.this.getSelectedFont());
                if (newFont != null) {
                    HGBaseConfigFontChooser.this.setSelectedFont(newFont);
                    HGBaseConfigFontChooser.this.propertyChange(oldFont, newFont);
                }
            }
        });
    }

    protected JButton getButton() {
        return this.btFont;
    }

    protected JPanel createFontChooserPanel() {
        JPanel pnFontChooser = new JPanel(new BorderLayout(5, 0));
        pnFontChooser.add((Component)this.getFontDisplayField(), "Center");
        pnFontChooser.add((Component)this.getButton(), "East");
        return pnFontChooser;
    }

    protected void setSelectedFont(Font font) {
        this.font = font;
        this.getFontDisplayField().setText(HGBaseConfigFontChooser.getFontString(font));
    }

    public Font getSelectedFont() {
        return this.font;
    }

    protected static String getFontString(Font font) {
        return font != null ? String.valueOf(font.getFamily()) + FONT_STRING_SEPARATOR + (Object)((Object)HGBaseFontStyle.valueOf(font.getStyle())) + FONT_STRING_SEPARATOR + font.getSize() : null;
    }

    protected void setOption(String option) {
        this.option = option;
    }

    @Override
    public String getOption() {
        return this.option;
    }

    @Override
    public String getValue() {
        return HGBaseConfigFontChooser.getValue(this.getSelectedFont());
    }

    protected static String getValue(Font font) {
        return font != null ? String.valueOf(font.getFamily()) + FONT_ATTRIBUTE_SEPARATOR + font.getStyle() + FONT_ATTRIBUTE_SEPARATOR + font.getSize() : null;
    }

    @Override
    public void setValue(String value) {
        Font font = null;
        String[] attributes = value.split(FONT_ATTRIBUTE_SEPARATOR);
        if (attributes.length >= 3) {
            try {
                String family = attributes[0];
                int style = Integer.parseInt(attributes[1]);
                int size = Integer.parseInt(attributes[2]);
                font = new Font(family, style, size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setSelectedFont(font);
    }

    @Override
    public void saveOption() {
        if (this.isEnabled()) {
            HGBaseConfig.set(this.getOption(), this.getSelectedFont());
        }
    }

    protected void loadOption(Font defaultFont) {
        this.setSelectedFont(HGBaseConfig.getFont(this.getOption(), defaultFont));
    }
}

