/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.menu;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGui;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseItem;
import hgb.gui.config.HGBaseConfigCheckBox;
import hgb.gui.config.HGBaseConfigItem;
import hgb.gui.config.HGBaseConfigMenuCheckBox;
import hgb.gui.config.HGBaseConfigRadioGroup;
import hgb.gui.menu.HGBaseMenuItem;
import hgb.gui.menu.HGBaseMenuRadioButton;
import hgb.gui.menu.HGBaseSubMenu;
import hgb.gui.menu.IMenuAction;
import hgb.gui.menu.MenuBuilder;
import hgb.gui.menu.actions.EditCopyAction;
import hgb.gui.menu.actions.EditCutAction;
import hgb.gui.menu.actions.EditPasteAction;
import hgb.gui.menu.actions.EditSelectAllAction;
import hgb.gui.menu.actions.FileCloseAction;
import hgb.gui.menu.actions.FileExitAction;
import hgb.gui.menu.actions.FileNewAction;
import hgb.gui.menu.actions.FileOpenAction;
import hgb.gui.menu.actions.FilePrintAction;
import hgb.gui.menu.actions.FileSaveAction;
import hgb.gui.menu.actions.FileSaveAsAction;
import hgb.gui.menu.actions.HelpAboutAction;
import hgb.gui.menu.actions.HelpUpdateCheckAction;
import hgb.gui.menu.actions.LinkAction;
import hgb.gui.menu.actions.SettingsLoggingAction;
import hgb.gui.menu.actions.SettingsMenuIconsAction;
import hgb.gui.menu.actions.SettingsToolbarAction;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseStringBuilder;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.HGBaseXMLTools;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.w3c.dom.Element;

public class HGBaseMenu
extends JMenuBar
implements HGBaseGui,
ActionListener {
    public static final String MENU_ID_FILE_NEW = "file.new";
    public static final String MENU_ID_FILE_OPEN = "file.open";
    public static final String MENU_ID_FILE_SAVE = "file.save";
    public static final String MENU_ID_FILE_SAVE_AS = "file.saveas";
    public static final String MENU_ID_FILE_CLOSE = "file.close";
    public static final String MENI_ID_FILE_PRINT = "file.print";
    public static final String MENU_ID_FILE_RECENT = "file.recent";
    public static final String MENU_ID_FILE_EXIT = "file.exit";
    public static final String MENU_ID_EDIT_SELECTALL = "edit.selectall";
    public static final String MENU_ID_EDIT_PASTE = "edit.paste";
    public static final String MENU_ID_EDIT_COPY = "edit.copy";
    public static final String MENU_ID_EDIT_CUT = "edit.cut";
    public static final String MENU_ID_HELP_UPDATE_CHECK = "help.update.check";
    public static final String MENU_ID_HELP_ABOUT = "help.about";
    public static final String MENU_ID_SETTINGS_LOGGING = "settings.logging";
    public static final String MENU_ID_SETTINGS_TOOLBAR = "settings.toolbar";
    public static final String MENU_ID_SETTINGS_MENUICONS = "settings.menuicons";
    private static final long serialVersionUID = 424781084L;
    static final String LAF_MENU = "laf";
    private HGBaseFrame frame;
    private Map<String, IMenuAction> menuActionMap = new HashMap<String, IMenuAction>();
    private Map<String, ImageIcon> imageItems = new HashMap<String, ImageIcon>();
    private List<HGBaseConfigItem> configItems = new ArrayList<HGBaseConfigItem>();
    private Map<Integer, List<String>> mnemonicList;
    private int menuKey = 0;
    private File currentDir;
    private int maxRecentFiles = 4;
    private List<String> recentFileList;
    Map<String, JComponent> menuItems = new HashMap<String, JComponent>();
    Map<JMenuItem, Integer> menuIndex = new HashMap<JMenuItem, Integer>();
    Map<String, JComponent> toolbarItems = new HashMap<String, JComponent>();
    Map<String, HGBaseConfigRadioGroup> radioMenus = new HashMap<String, HGBaseConfigRadioGroup>();
    Set<String> linkItems = new LinkedHashSet<String>();
    JToolBar toolbar = new JToolBar();
    boolean addSeparatorToToolbar;
    HGBaseSubMenu recentFileMenu;

    public HGBaseMenu(HGBaseFrame frame) {
        this.frame = frame;
        this.initRecentFileList();
        this.toolbar.setBorderPainted(false);
        this.toolbar.setFocusable(false);
        Element root = HGBaseXMLTools.readXML(HGBaseSettings.get("fileMenu"));
        MenuBuilder mBuilder = new MenuBuilder(this);
        mBuilder.buildImages(root);
        mBuilder.buildMenu(root);
        mBuilder.buildToolbar(root);
        mBuilder.setImages();
        this.actualizeText();
        this.setFileMenuStates();
        this.setRecentFileMenuList();
        this.registerDefaultMenuActions();
    }

    private void registerDefaultMenuActions() {
        this.registerAction(MENU_ID_FILE_EXIT, new FileExitAction(this));
        this.registerAction(MENU_ID_FILE_NEW, new FileNewAction(this));
        this.registerAction(MENU_ID_FILE_OPEN, new FileOpenAction(this));
        this.registerAction(MENU_ID_FILE_CLOSE, new FileCloseAction(this));
        this.registerAction(MENU_ID_FILE_SAVE, new FileSaveAction(this));
        this.registerAction(MENU_ID_FILE_SAVE_AS, new FileSaveAsAction(this));
        this.registerAction(MENI_ID_FILE_PRINT, new FilePrintAction(this));
        this.registerAction(MENU_ID_SETTINGS_MENUICONS, new SettingsMenuIconsAction(this));
        this.registerAction(MENU_ID_SETTINGS_TOOLBAR, new SettingsToolbarAction(this));
        this.registerAction(MENU_ID_SETTINGS_LOGGING, new SettingsLoggingAction(this));
        this.registerAction(MENU_ID_HELP_ABOUT, new HelpAboutAction(this));
        this.registerAction(MENU_ID_HELP_UPDATE_CHECK, new HelpUpdateCheckAction(this));
        this.registerAction(MENU_ID_EDIT_CUT, new EditCutAction(this));
        this.registerAction(MENU_ID_EDIT_COPY, new EditCopyAction(this));
        this.registerAction(MENU_ID_EDIT_PASTE, new EditPasteAction(this));
        this.registerAction(MENU_ID_EDIT_SELECTALL, new EditSelectAllAction(this));
        for (String linkId : this.getLinkItems()) {
            this.registerAction(linkId, new LinkAction(this));
        }
    }

    private void initRecentFileList() {
        int length = HGBaseSettings.getInt("fileRecentList");
        if (length >= 0) {
            this.maxRecentFiles = length;
        }
        this.recentFileList = new ArrayList<String>(this.maxRecentFiles);
        boolean found = true;
        int i = 1;
        while (found && i <= this.maxRecentFiles) {
            String recentFileId = this.calculateFileRecentId(i);
            String fileName = HGBaseConfig.get(recentFileId);
            if (fileName != null && fileName.length() > 0) {
                if (this.recentFileList.contains(fileName)) {
                    HGBaseConfig.remove(recentFileId);
                } else {
                    this.recentFileList.add(fileName);
                }
                found = true;
            }
            ++i;
        }
    }

    private void setRecentFileMenuList() {
        if (this.recentFileMenu != null) {
            this.recentFileMenu.removeAll();
            int i = 1;
            for (String fileName : this.recentFileList) {
                HGBaseMenuItem m = new HGBaseMenuItem(this.calculateFileRecentId(i));
                m.setText(String.valueOf(i) + ": " + HGBaseFileTools.shortenFileName(fileName));
                m.setMnemonic(48 + i);
                m.addActionListener(this);
                this.recentFileMenu.add(m);
                ++i;
            }
        }
    }

    private void addRecentFileToMenu(File f) {
        String fileName;
        if (this.maxRecentFiles > 0 && !this.recentFileList.contains(fileName = f.toString())) {
            if (this.recentFileList.size() == this.maxRecentFiles) {
                this.recentFileList.remove(this.maxRecentFiles - 1);
            }
            this.recentFileList.add(0, fileName);
            this.setRecentFileMenuList();
        }
    }

    public HGBaseFrame getMainFrame() {
        return this.frame;
    }

    public void onExit() {
        if (this.onFileClose()) {
            this.writeConfigToFile();
            this.exitApplication();
        }
    }

    protected void exitApplication() {
        System.exit(0);
    }

    public void writeConfigToFile() {
        int err;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Container c = this.getTopLevelAncestor();
        int state = this.getMainFrame().getExtendedState();
        HGBaseConfig.set("last_state", state);
        if ((double)c.getWidth() < screen.getWidth() && (double)c.getHeight() < screen.getHeight() && state != 6) {
            HGBaseConfig.set("last_width", c.getWidth());
            HGBaseConfig.set("last_height", c.getHeight());
            HGBaseConfig.set("last_x", (int)c.getLocation().getX());
            HGBaseConfig.set("last_y", (int)c.getLocation().getY());
        }
        this.saveOptions();
        this.saveRecentList();
        if (HGBaseTools.hasContent(HGBaseSettings.get("fileConfig")) && (err = HGBaseConfig.toFile()) != 0 && err != -2147483631) {
            HGBaseDialog.printError(err, (JFrame)this.frame);
        }
    }

    @Override
    public void actualizeText() {
        this.mnemonicList = new HashMap<Integer, List<String>>();
        for (Map.Entry<String, JComponent> entry : this.menuItems.entrySet()) {
            JComponent t;
            String k = entry.getKey();
            JComponent m = entry.getValue();
            if (m instanceof JMenuItem) {
                ((JMenuItem)m).setText(HGBaseText.getText(k, new String[0]));
                this.setMenuMnemonic((JMenuItem)m);
            }
            if ((t = this.toolbarItems.get(k)) == null) continue;
            if (t instanceof HGBaseConfigCheckBox) {
                ((HGBaseConfigCheckBox)t).setText(HGBaseText.getText(k, new String[0]));
                continue;
            }
            t.setToolTipText(HGBaseText.getText(k, new String[0]));
        }
    }

    @Override
    public void actualizeLaf() {
        try {
            SwingUtilities.updateComponentTreeUI(this);
            this.refreshIcons();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void refreshIcons() {
        if (HGBaseConfig.getBoolean("menuicons")) {
            this.setMenuIcons();
        }
        this.setToolbarIcons();
    }

    public void setMenuIcons() {
        for (Map.Entry<String, JComponent> entry : this.menuItems.entrySet()) {
            String k = entry.getKey();
            JComponent o = entry.getValue();
            if (!(o instanceof JMenuItem)) continue;
            JMenuItem m = (JMenuItem)o;
            this.setMenuIcon(m, k);
            HGBaseConfigRadioGroup rGroup = this.radioMenus.get(k);
            if (rGroup == null || this.getItemImage(k) != null) continue;
            this.setMenuIcon(m, rGroup.getValue());
        }
    }

    private void setMenuMnemonic(JMenuItem menu) {
        Integer key = this.menuIndex.get(menu);
        if (key != null) {
            List<String> al = this.mnemonicList.get(key);
            if (al == null) {
                al = new ArrayList<String>();
                this.mnemonicList.put(key, al);
            }
            String name = menu.getText().toUpperCase();
            int i = 0;
            while (i < name.length()) {
                char ch = name.charAt(i);
                if (!al.contains(String.valueOf(ch))) {
                    menu.setMnemonic(ch);
                    al.add(String.valueOf(ch));
                    return;
                }
                ++i;
            }
        }
    }

    public void setFileMenuStates() {
        if (this.frame != null) {
            boolean hasFile = this.frame.getFile() != null;
            HGBaseGuiTools.setEnabledNullSafe(this.menuItems.get(MENU_ID_FILE_CLOSE), hasFile);
            HGBaseGuiTools.setEnabledNullSafe(this.menuItems.get(MENU_ID_FILE_SAVE_AS), hasFile);
            HGBaseGuiTools.setEnabledNullSafe(this.toolbarItems.get(MENU_ID_FILE_CLOSE), hasFile);
            HGBaseGuiTools.setEnabledNullSafe(this.toolbarItems.get(MENU_ID_FILE_SAVE_AS), hasFile);
            HGBaseGuiTools.setEnabledNullSafe(this.toolbarItems.get(MENI_ID_FILE_PRINT), hasFile);
            HGBaseGuiTools.setEnabledNullSafe(this.menuItems.get(MENI_ID_FILE_PRINT), hasFile);
            HGBaseGuiTools.setEnabledNullSafe(this.menuItems.get(MENU_ID_FILE_SAVE), hasFile && this.frame.isChanged());
            HGBaseGuiTools.setEnabledNullSafe(this.toolbarItems.get(MENU_ID_FILE_SAVE), hasFile && this.frame.isChanged());
            this.frame.setTitle();
        }
    }

    public JComponent getMenuItem(String id) {
        return this.menuItems.get(id);
    }

    public String[] getMenuItemIds() {
        return this.menuItems.keySet().toArray(new String[this.menuItems.size()]);
    }

    public void setItemEnabled(String id, boolean enable) {
        JComponent m = this.menuItems.get(id);
        if (m instanceof JMenuItem) {
            ((JMenuItem)m).setEnabled(enable);
        }
        HGBaseGuiTools.setEnabledNullSafe(this.toolbarItems.get(id), enable);
    }

    public void addConfigItem(HGBaseConfigItem item) {
        if (this.configItems != null) {
            this.configItems.add(item);
        }
    }

    public final void registerAction(String id, IMenuAction action) {
        this.menuActionMap.put(id, action);
    }

    public final IMenuAction getAction(String id) {
        return this.menuActionMap.get(id);
    }

    public void onAction(String id, ActionEvent e) {
        String laf;
        IMenuAction action = this.getAction(id);
        if (action != null) {
            action.perform(id, e);
        } else if (id.startsWith(MENU_ID_FILE_RECENT)) {
            this.onFileOpenRecent(id);
        } else if (id.startsWith("lan.")) {
            HGBaseText.setLanguage();
            this.getMainFrame().actualizeText();
        } else if (id.startsWith("laf.") && (laf = HGBaseSettings.getLaf(id)) != null) {
            this.getMainFrame().actualizeLaf(laf);
        }
        this.setFileMenuStates();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HGBaseConfigItem ci;
        Object o = e.getSource();
        if (o instanceof HGBaseConfigItem && o instanceof HGBaseItem) {
            ci = (HGBaseConfigItem)o;
            HGBaseItem bi = (HGBaseItem)o;
            String value = ci.getValue();
            int i = 0;
            while (i < this.configItems.size()) {
                HGBaseItem bi2;
                HGBaseConfigItem ci2 = this.configItems.get(i);
                if (ci2 instanceof HGBaseItem && (bi2 = (HGBaseItem)((Object)ci2)).getId().equals(bi.getId())) {
                    ci2.setValue(value);
                }
                ++i;
            }
        }
        if (o instanceof HGBaseConfigItem || o instanceof HGBaseMenuRadioButton) {
            this.saveOptions();
        }
        if (o instanceof HGBaseItem) {
            HGBaseItem bi = (HGBaseItem)o;
            this.onAction(bi.getId(), e);
        } else if (o instanceof HGBaseConfigItem) {
            ci = (HGBaseConfigItem)o;
            this.onAction(ci.getOption(), e);
        }
    }

    protected boolean handleSpecialMenu(String menuType, HGBaseSubMenu subMenu, String shortcut) {
        if (LAF_MENU.equals(menuType)) {
            HGBaseStringBuilder lafOptions = new HGBaseStringBuilder(";");
            int numLafOptions = HGBaseSettings.getLafInfo().size();
            int i = 0;
            while (i < numLafOptions) {
                lafOptions.append("laf." + i);
                ++i;
            }
            new MenuBuilder(this).buildRadioGroup(subMenu, lafOptions.toString(), LAF_MENU, shortcut);
            return true;
        }
        return false;
    }

    int getNextMenuKey() {
        ++this.menuKey;
        return this.menuKey;
    }

    public JComponent getToolbarItem(String id) {
        return this.toolbarItems.get(id);
    }

    protected Map<String, JComponent> getToolbarItemMap() {
        return this.toolbarItems;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public void setMenuIcon(JMenuItem m, String id) {
        ImageIcon imgNull = this.getItemImage("null");
        ImageIcon imgNullX = this.getItemImage("nullx");
        try {
            ImageIcon img;
            if (id != null && id.equals("asdf")) {
                img = null;
            } else {
                img = this.getItemImage(id);
                if (img == null && m.getParent() != this) {
                    if (m instanceof HGBaseConfigMenuCheckBox || m instanceof HGBaseMenuRadioButton) {
                        LookAndFeel laf = UIManager.getLookAndFeel();
                        if (laf.getName() == "Windows") {
                            if (imgNull != null) {
                                img = imgNull;
                            }
                        } else if (imgNullX != null) {
                            img = imgNullX;
                        }
                    } else if (imgNull != null) {
                        img = imgNull;
                    }
                }
            }
            m.setIcon(img);
            this.applyStateImagesToButton(m, img);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeMenuIcons() {
        for (Map.Entry<String, JComponent> entry : this.menuItems.entrySet()) {
            JComponent o = entry.getValue();
            if (!(o instanceof JMenuItem)) continue;
            this.removeMenuIcon((JMenuItem)o);
        }
    }

    public void removeMenuIcon(JMenuItem menuItem) {
        if (menuItem != null) {
            menuItem.setIcon(null);
        }
    }

    public void setToolbarIcons() {
        for (Map.Entry<String, JComponent> entry : this.toolbarItems.entrySet()) {
            String k = entry.getKey();
            JComponent o = entry.getValue();
            if (!(o instanceof JButton)) continue;
            JButton b = (JButton)o;
            this.setToolbarIcon(b, k);
            HGBaseConfigRadioGroup rGroup = this.radioMenus.get(k);
            if (rGroup == null || this.getItemImage(k) != null) continue;
            this.setToolbarIcon(b, rGroup.getValue());
        }
    }

    public void setToolbarIcon(JButton button, String id) {
        ImageIcon imgNull = this.getItemImage("null");
        ImageIcon img = this.getItemImage(id);
        if (img == null && imgNull != null) {
            img = imgNull;
        }
        button.setIcon(img);
        this.applyStateImagesToButton(button, img);
    }

    private void applyStateImagesToButton(AbstractButton button, ImageIcon img) {
        if (img != null) {
            button.setRolloverEnabled(true);
            ImageIcon imgBrighter = HGBaseGuiTools.getBrighterImage(this, img);
            button.setRolloverIcon(imgBrighter);
            button.setRolloverSelectedIcon(imgBrighter);
            ImageIcon imgDarker = HGBaseGuiTools.getDarkerImage(this, img);
            button.setSelectedIcon(imgDarker);
        }
    }

    private void saveOptions() {
        for (HGBaseConfigItem ci : this.configItems) {
            ci.saveOption();
        }
    }

    private void saveRecentList() {
        Iterator<String> it = this.recentFileList.iterator();
        int i = 1;
        while (i <= this.maxRecentFiles) {
            String fileRecentId = this.calculateFileRecentId(i);
            if (it.hasNext()) {
                HGBaseConfig.set(fileRecentId, it.next());
            } else {
                HGBaseConfig.remove(fileRecentId);
            }
            ++i;
        }
    }

    private String calculateFileRecentId(int index) {
        return "file.recent." + index;
    }

    boolean isPossibleLaf(String laf) {
        try {
            Class<?> lnfClass = Class.forName(laf);
            LookAndFeel newLaf = (LookAndFeel)lnfClass.newInstance();
            return newLaf.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean onFileNew() {
        if (this.onFileClose() && this.frame != null) {
            this.frame.setCursorWait();
            this.frame.setFile(new File(""));
            int err = this.frame.onFileNew();
            this.frame.setCursorDefault();
            if (err < 0) {
                this.frame.setFile(null);
                if (err != -2147483631) {
                    HGBaseDialog.printError(err, (JFrame)this.frame);
                }
                return false;
            }
            if (err > 0) {
                HGBaseDialog.printInfo(err, (JFrame)this.frame);
            }
            return true;
        }
        return false;
    }

    public boolean onFileClose() {
        if (this.frame == null) {
            return false;
        }
        if (this.frame.isChanged() && !HGBaseConfig.getBoolean("noconfirm") && !this.askForSaving()) {
            return false;
        }
        if (this.frame.getFile() != null) {
            this.frame.setCursorWait();
            int err = this.frame.onFileClose();
            this.frame.setCursorDefault();
            if (err < 0) {
                if (err != -2147483631) {
                    HGBaseDialog.printError(err, (JFrame)this.frame);
                }
                return false;
            }
            if (err > 0) {
                HGBaseDialog.printInfo(err, (JFrame)this.frame);
            }
        }
        this.frame.setFile(null);
        return true;
    }

    protected boolean askForSaving(int initial) {
        int result = HGBaseDialog.showConfirmSaveDialog(this.frame, HGBaseText.getText("dlg.filesave", new String[0]), HGBaseSettings.get("appName"), initial);
        return !(result == 0 ? !this.onFileSave() : result == 2);
    }

    protected boolean askForSaving() {
        return this.askForSaving(0);
    }

    public boolean onFileSave() {
        File f;
        if (this.frame != null && (f = this.frame.getFile()) != null) {
            if (f.getName().equals("")) {
                return this.onFileSaveAs();
            }
            return this.saveFile(f);
        }
        return false;
    }

    private File checkExtension(File f) {
        return HGBaseFileTools.checkExtension(f, HGBaseSettings.get("fileExtensions"));
    }

    public boolean onFileSaveAs(File f) {
        return this.saveFile(f);
    }

    private boolean saveFile(File f) {
        this.frame.setCursorWait();
        int err = this.frame.onFileSave(f);
        this.frame.setCursorDefault();
        if (err < 0) {
            if (err != -2147483631) {
                HGBaseDialog.printError(err, (JFrame)this.frame);
            }
            return false;
        }
        if (err > 0) {
            HGBaseDialog.printInfo(err, (JFrame)this.frame);
        }
        this.frame.setFile(f);
        return true;
    }

    public boolean onFileSaveAs() {
        int result;
        JFileChooser fc = HGBaseGuiTools.createFileChooser(HGBaseSettings.get("fileDescription"), HGBaseSettings.get("fileExtensions"), HGBaseSettings.get("filePath"));
        if (this.currentDir != null) {
            fc.setCurrentDirectory(this.currentDir);
        }
        if ((result = HGBaseDialog.showSaveDialog(fc, HGBaseSettings.get("appName"), this.frame)) == 0) {
            File f = fc.getSelectedFile();
            if (this.onFileSaveAs(f = this.checkExtension(f))) {
                this.currentDir = fc.getCurrentDirectory();
                this.addRecentFileToMenu(f);
                return true;
            }
        }
        return false;
    }

    public boolean onFileOpen(File f) {
        if (!f.exists()) {
            HGBaseDialog.printError(-10709, (JFrame)this.frame);
            return false;
        }
        this.frame.setCursorWait();
        this.frame.setFile(f);
        int err = this.frame.onFileOpen(f);
        this.frame.setCursorDefault();
        if (err < 0) {
            this.frame.setFile(null);
            if (err != -2147483631) {
                this.showFileOpenError(err);
            }
            return false;
        }
        if (err > 0) {
            HGBaseDialog.printInfo(err, (JFrame)this.frame);
        }
        this.currentDir = f.getParentFile();
        this.addRecentFileToMenu(f);
        return true;
    }

    protected void showFileOpenError(int errorCode) {
        HGBaseDialog.printError(errorCode, (JFrame)this.frame);
    }

    public boolean onFileOpen() {
        File f;
        int result;
        JFileChooser fc = HGBaseGuiTools.createFileChooser(HGBaseSettings.get("fileDescription"), HGBaseSettings.get("fileExtensions"), HGBaseSettings.get("filePath"));
        if (this.currentDir != null) {
            fc.setCurrentDirectory(this.currentDir);
        }
        return (result = fc.showOpenDialog(this.frame)) == 0 && this.onFileClose() && this.onFileOpen(f = fc.getSelectedFile());
    }

    private void onFileOpenRecent(String id) {
        String indexText = id.substring(MENU_ID_FILE_RECENT.length() + 1, id.length());
        int index = HGBaseTools.toInt(indexText) - 1;
        if (index >= 0 && index < this.recentFileList.size()) {
            File f;
            String fileName = this.recentFileList.get(index);
            if (this.onFileClose() && !this.onFileOpen(f = new File(fileName))) {
                this.recentFileList.remove(fileName);
                this.setRecentFileMenuList();
            }
        }
    }

    public boolean onFilePrint() {
        if (this.frame != null) {
            this.frame.setCursorWait();
            Printable p = this.frame.onFilePrint();
            this.frame.setCursorDefault();
            if (p != null) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(p, printerJob.defaultPage());
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                        return true;
                    }
                    catch (PrinterException printerException) {}
                }
            } else {
                HGBaseDialog.printError(-10711, (JFrame)this.frame);
            }
        }
        return false;
    }

    public boolean onCheckUpdate() {
        if (this.frame != null) {
            this.frame.onCheckUpdate();
            return true;
        }
        return false;
    }

    protected void setItemImage(String id, ImageIcon img) {
        if (img != null) {
            this.imageItems.put(id, img);
        }
    }

    public ImageIcon getItemImage(String id) {
        return this.imageItems.get(id);
    }

    public void addLinkItem(String id) {
        this.linkItems.add(id);
    }

    public Collection<String> getLinkItems() {
        return Collections.unmodifiableCollection(this.linkItems);
    }

    void addRadioGroupMenu(String menuId, HGBaseConfigRadioGroup radioGroup) {
        this.radioMenus.put(menuId, radioGroup);
    }
}

