/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.util;

import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public abstract class AbstractDialog
implements WindowListener,
ActionListener {
    private static final String ENTER_COMMAND = "enter";
    private static final String ESCAPE_COMMAND = "escape";
    private static final String SETTING_KEY_APP_NAME = "appName";
    public static final String MSG_BTN_OK = "dlg.ok";
    public static final String MSG_BTN_CANCEL = "dlg.cancel";
    protected Frame parent;
    private JDialog dlg;
    private String titleMsgKey;
    private boolean resizable;
    private boolean returnValue;
    private JButton btOK;
    private JButton btCancel;

    public AbstractDialog(Frame parent, String titleMsgKey, boolean resizable) {
        this.setParent(parent);
        this.setTitleMsgKey(titleMsgKey);
        this.setResizable(resizable);
        this.setOkButton(this.createOkButton());
        this.setCancelButton(this.createCancelButton());
    }

    protected Frame getParent() {
        return this.parent;
    }

    protected void setParent(Frame parent) {
        this.parent = parent;
    }

    protected JDialog getDlg() {
        return this.dlg;
    }

    protected void setDlg(JDialog dlg) {
        this.dlg = dlg;
    }

    protected String getTitleMsgKey() {
        return this.titleMsgKey;
    }

    protected String getTitle() {
        String msgKey = this.getTitleMsgKey();
        if (msgKey == null) {
            return HGBaseSettings.get(SETTING_KEY_APP_NAME);
        }
        return HGBaseText.existsText(msgKey) ? HGBaseText.getText(msgKey, new String[0]) : msgKey;
    }

    protected void setTitleMsgKey(String titleMsgKey) {
        this.titleMsgKey = titleMsgKey;
    }

    protected boolean isResizable() {
        return this.resizable;
    }

    protected void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    protected boolean getReturnValue() {
        return this.returnValue;
    }

    protected void setReturnValue(boolean returnValue) {
        this.returnValue = returnValue;
    }

    protected JButton getOkButton() {
        return this.btOK;
    }

    protected void setOkButton(JButton btOK) {
        this.btOK = btOK;
    }

    protected JButton getCancelButton() {
        return this.btCancel;
    }

    protected void setCancelButton(JButton btCancel) {
        this.btCancel = btCancel;
    }

    protected JButton createOkButton() {
        JButton button = new JButton(HGBaseText.getText(MSG_BTN_OK, new String[0]));
        button.addActionListener(this);
        return button;
    }

    protected JButton createCancelButton() {
        JButton button = new JButton(HGBaseText.getText(MSG_BTN_CANCEL, new String[0]));
        button.addActionListener(this);
        return button;
    }

    protected Container createContentPane() {
        JOptionPane contentPane = new JOptionPane(this.createContentPanel(), -1, 2, null, this.getOptionButtons(), this.getDefaultButton());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.getViewport().add(contentPane);
        return scrollPane;
    }

    protected void createDialog(Container contentPane) {
        JDialog dlg = new JDialog(this.getParent(), this.getTitle(), true);
        dlg.setContentPane(contentPane);
        dlg.pack();
        dlg.setLocationRelativeTo(this.getParent());
        dlg.setResizable(this.isResizable());
        dlg.addWindowListener(this);
        this.addEnterListener(dlg);
        this.addEscapeListener(dlg);
        this.setDlg(dlg);
    }

    protected void addKeyActionListener(JDialog dlg, int keyCode, String keyCommand, Action action) {
        JRootPane rootPane = dlg.getRootPane();
        rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(keyCode, 0), keyCommand);
        rootPane.getActionMap().put(keyCommand, action);
    }

    protected void addEnterListener(JDialog dlg) {
        Action action = new Action(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AbstractDialog.this.onOK();
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public Object getValue(String key) {
                return null;
            }

            @Override
            public boolean isEnabled() {
                return AbstractDialog.this.isOkAllowed();
            }

            @Override
            public void putValue(String key, Object value) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void setEnabled(boolean b) {
            }
        };
        this.addKeyActionListener(dlg, 10, ENTER_COMMAND, action);
    }

    protected void addEscapeListener(JDialog dlg) {
        Action action = new Action(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AbstractDialog.this.onCancel();
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public Object getValue(String key) {
                return null;
            }

            @Override
            public boolean isEnabled() {
                return AbstractDialog.this.isCancelAllowed();
            }

            @Override
            public void putValue(String key, Object value) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void setEnabled(boolean b) {
            }
        };
        this.addKeyActionListener(dlg, 27, ESCAPE_COMMAND, action);
    }

    public final boolean show() {
        this.createDialog(this.createContentPane());
        this.enableButtons();
        this.additionalInit();
        this.getDlg().setVisible(true);
        return this.getReturnValue();
    }

    protected abstract JPanel createContentPanel();

    protected abstract Object[] getOptionButtons();

    protected abstract Object getDefaultButton();

    protected abstract boolean isOkAllowed();

    protected abstract boolean isCancelAllowed();

    protected void additionalInit() {
    }

    protected void additionalDeinit() {
    }

    protected final void enableButtons() {
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(this.isOkAllowed());
        }
        if (this.getCancelButton() != null) {
            this.getCancelButton().setEnabled(this.isCancelAllowed());
        }
    }

    protected void onCancel() {
        this.closeDialog(false);
    }

    protected void onOK() {
        this.closeDialog(true);
    }

    protected final void closeDialog(boolean returnValue) {
        this.additionalDeinit();
        this.setReturnValue(returnValue);
        this.getDlg().setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source.equals(this.getOkButton())) {
            this.onOK();
        } else if (source.equals(this.getCancelButton())) {
            this.onCancel();
        }
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        if (ev.getSource().equals(this.getDlg())) {
            this.onCancel();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowOpened(WindowEvent ev) {
    }
}

