/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib;

class HGBaseVersionPart
implements Comparable<HGBaseVersionPart> {
    private String part;
    private String prefix;
    private Integer number;
    private String suffix;

    public HGBaseVersionPart(String part) {
        this.setPart(part);
    }

    private void setPart(String part) {
        if (part == null) {
            throw new IllegalArgumentException("version part is null");
        }
        this.part = part;
        this.analyze();
    }

    protected String getPart() {
        return this.part;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected Integer getNumber() {
        return this.number;
    }

    protected String getSuffix() {
        return this.suffix;
    }

    private void analyze() {
        this.prefix = null;
        this.number = null;
        this.suffix = null;
        int num = 0;
        int cntDigits = 0;
        StringBuffer str = new StringBuffer();
        int length = this.part.length();
        int index = 0;
        while (index < length) {
            char ch = this.part.charAt(index);
            if (Character.isDigit(ch) && this.number == null) {
                if (str.length() > 0 && this.prefix == null) {
                    this.prefix = str.toString();
                    str.setLength(0);
                }
                num = num * 10 + (ch - 48);
                ++cntDigits;
            } else {
                if (cntDigits > 0) {
                    this.number = num;
                    num = 0;
                    cntDigits = 0;
                }
                str.append(ch);
            }
            ++index;
        }
        if (str.length() > 0) {
            if (this.prefix == null && this.number == null) {
                this.prefix = str.toString();
            } else {
                this.suffix = str.toString();
            }
        } else if (cntDigits > 0) {
            this.number = num;
        }
    }

    protected int comparePrefix(String otherPrefix) {
        int result = 0;
        if (this.getPrefix() != null && otherPrefix != null) {
            result = this.getPrefix().compareTo(otherPrefix);
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        } else {
            result = this.getPrefix() != null && otherPrefix == null ? 1 : (this.getPrefix() == null && otherPrefix != null ? -1 : 0);
        }
        return result;
    }

    protected int compareNumber(Integer otherNumber) {
        int result = 0;
        if (this.getNumber() != null && otherNumber != null) {
            result = this.getNumber().compareTo(otherNumber);
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        } else {
            result = this.getNumber() != null && otherNumber == null ? 1 : (this.getNumber() == null && otherNumber != null ? -1 : 0);
        }
        return result;
    }

    protected int compareSuffix(String otherSuffix) {
        int result = 0;
        if (this.getSuffix() != null && otherSuffix != null) {
            result = this.getSuffix().compareTo(otherSuffix);
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        } else {
            result = this.getSuffix() != null && otherSuffix == null ? 1 : (this.getSuffix() == null && otherSuffix != null ? -1 : 0);
        }
        return result;
    }

    public boolean equals(Object o2) {
        return o2 instanceof HGBaseVersionPart && this.compareTo((HGBaseVersionPart)o2) == 0;
    }

    public int hashCode() {
        return this.part.hashCode();
    }

    @Override
    public int compareTo(HGBaseVersionPart otherPart) {
        if (otherPart == null) {
            throw new IllegalArgumentException("other version part is null");
        }
        if (this.getPart().equals(otherPart.getPart())) {
            return 0;
        }
        int result = 0;
        result = this.comparePrefix(otherPart.getPrefix());
        if (result != 0) {
            return result;
        }
        result = this.compareNumber(otherPart.getNumber());
        if (result != 0) {
            return result;
        }
        result = this.compareSuffix(otherPart.getSuffix());
        return result;
    }
}

