/*
 * Decompiled with CFR 0.152.
 */
package hgb.lib.internal;

import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IntBooleanStringMap {
    private static final String INCLUDE_TAG = "include";
    private static final String FILE_ATTRIBUTE = "file";
    private Map<String, String> textOptions = new HashMap<String, String>();

    public int fromFile(String file, String rootName, String nodeName, String attrKey, String attrValue) {
        this.textOptions.clear();
        Element root = HGBaseXMLTools.readXML(file);
        return this.fromDomElement(root, rootName, nodeName, attrKey, attrValue);
    }

    public int fromFile(InputStream stream, String rootName, String nodeName, String attrKey, String attrValue) {
        this.textOptions.clear();
        Element root = HGBaseXMLTools.readXML(stream);
        return this.fromDomElement(root, rootName, nodeName, attrKey, attrValue);
    }

    private int fromDomElement(Element root, String rootName, String nodeName, String attrKey, String attrValue) {
        if (root != null) {
            this.readNodes(root, rootName, nodeName, attrKey, attrValue);
            return 0;
        }
        return -1;
    }

    private void readNodes(Element root, final String rootName, final String nodeName, final String attrKey, final String attrValue) {
        ChildNodeIterator.run(new ChildNodeIterator(root, rootName, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                Element includeRoot;
                String includeFile;
                String currNodeName = node.getNodeName();
                if (nodeName.equals(currNodeName)) {
                    String code = HGBaseXMLTools.getAttributeValue(node, attrKey);
                    String value = HGBaseXMLTools.getAttributeValue(node, attrValue);
                    if (code != null && code.length() > 0 && value != null && value.length() > 0) {
                        IntBooleanStringMap.this.set(code, value);
                    }
                } else if (IntBooleanStringMap.INCLUDE_TAG.equals(currNodeName) && HGBaseTools.hasContent(includeFile = HGBaseXMLTools.getAttributeValue(node, IntBooleanStringMap.FILE_ATTRIBUTE)) && (includeRoot = HGBaseXMLTools.readXML(includeFile)) != null) {
                    IntBooleanStringMap.this.readNodes(includeRoot, rootName, nodeName, attrKey, attrValue);
                }
            }
        });
    }

    public int toFile(String file, String rootName, String nodeName, String attrKey, String attrValue) {
        try {
            Document newDoc = HGBaseXMLTools.createDocument();
            Element root = newDoc.createElement(rootName);
            newDoc.appendChild(root);
            String[] s = this.getKeys();
            if (s != null) {
                int i = 0;
                while (i < s.length) {
                    Element elem = newDoc.createElement(nodeName);
                    elem.setAttribute(attrKey, s[i]);
                    elem.setAttribute(attrValue, this.get(s[i]));
                    root.appendChild(elem);
                    ++i;
                }
            }
            if (HGBaseXMLTools.writeXML(newDoc, file)) {
                return 0;
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return -1;
    }

    public boolean existsKey(String key) {
        return this.textOptions.containsKey(key);
    }

    public String[] getKeys() {
        return this.textOptions.keySet().toArray(new String[this.textOptions.size()]);
    }

    public String get(String key, String defaultValue) {
        String value = this.textOptions.get(key);
        return value == null ? defaultValue : value;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.textOptions.get(key);
        return value == null ? defaultValue : HGBaseTools.toInt(value);
    }

    public int getInt(String key) {
        return this.getInt(key, -2147483631);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.textOptions.get(key);
        return value == null ? defaultValue : HGBaseTools.toBoolean(value);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean remove(String key) {
        if (!this.textOptions.containsKey(key)) {
            return false;
        }
        this.textOptions.remove(key);
        return true;
    }

    public void set(String key, String option) {
        this.textOptions.put(key, option);
    }

    public void set(String key, int option) {
        this.set(key, String.valueOf(option));
    }

    public void set(String key, boolean option) {
        int iOption = option ? 1 : 0;
        this.set(key, iOption);
    }
}

