/*
 * Decompiled with CFR 0.152.
 */
package tjger.game;

import hgb.lib.HGBaseTools;
import javax.swing.ImageIcon;
import tjger.game.GameRules;
import tjger.game.GameState;
import tjger.game.HumanPlayer;
import tjger.game.MoveInformation;
import tjger.game.NetworkPlayer;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.game.completed.PlayerType;
import tjger.game.internal.GameRecorder;
import tjger.game.internal.PlayerFactory;
import tjger.game.internal.PlayerKey;

public abstract class GamePlayer
implements Comparable<GamePlayer>,
Cloneable {
    public static final int SCORE_TURN = 1;
    public static final int SCORE_ROUND = 2;
    public static final int SCORE_GAME = 4;
    private String playerName;
    private ImageIcon playerImage;
    private String playerType;
    private String pieceColor;
    private boolean dropOut = false;
    private boolean playing = false;

    public GamePlayer(String playerType, String playerName, ImageIcon playerImage, String pieceColor) {
        this.playerType = playerType;
        this.setName(playerName);
        this.setImage(playerImage);
        this.setPieceColor(pieceColor);
    }

    protected GameManager getGameManager() {
        return GameManager.getInstance();
    }

    protected GameRules getGameRules() {
        return this.getGameManager().getGameRules();
    }

    protected GameState getGameState() {
        return this.getGameEngine().getGameState();
    }

    protected GameEngine getGameEngine() {
        return this.getGameManager().getGameEngine();
    }

    public String getName() {
        return this.playerName;
    }

    public void setName(String playerName) {
        this.playerName = playerName == null ? "" : playerName;
    }

    public ImageIcon getImage() {
        return this.playerImage;
    }

    public void setImage(ImageIcon playerImage) {
        this.playerImage = playerImage;
    }

    public String getPieceColor() {
        if (this.pieceColor == null) {
            return "";
        }
        return this.pieceColor;
    }

    public void setPieceColor(String pieceColor) {
        this.setPieceColor(pieceColor, false);
    }

    public void setPieceColor(String pieceColor, boolean considerOthers) {
        String oldColor = this.pieceColor;
        this.pieceColor = pieceColor;
        if (considerOthers && HGBaseTools.hasContent(oldColor)) {
            GamePlayer[] gamePlayerArray = GameManager.getInstance().getPlayerManager().getPlayers();
            int n = gamePlayerArray.length;
            int n2 = 0;
            while (n2 < n) {
                GamePlayer otherPlayer = gamePlayerArray[n2];
                if (!this.equals(otherPlayer) && this.pieceColor.equals(otherPlayer.getPieceColor())) {
                    otherPlayer.setPieceColor(oldColor);
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean isDropOut() {
        return this.dropOut;
    }

    public void setDropOut(boolean dropOut) {
        this.dropOut = dropOut;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isHuman() {
        return this instanceof HumanPlayer;
    }

    public boolean isNetwork() {
        return this instanceof NetworkPlayer;
    }

    public void startMove() {
        this.playing = true;
        MoveInformation debugMove = GameRecorder.getInstance().getNextRecordedMove(this.getGameState(), this);
        if (debugMove != null) {
            this.performMove(debugMove);
        } else {
            if (!this.isHuman()) {
                this.getGameManager().getMainFrame().setStatusProgress(1);
                this.getGameManager().getMainFrame().setCursorWait();
            }
            this.considerMove();
        }
    }

    public abstract void considerMove();

    public void performMove(MoveInformation move) {
        this.getGameManager().getMainFrame().setCursorDefault();
        if (this.isPlaying()) {
            this.stopPlaying();
            this.getGameEngine().performMove(move);
        }
    }

    public void stopPlaying() {
        this.playing = false;
    }

    public boolean isPlaying() {
        return this.playing && this.getGameEngine().isActiveRound();
    }

    public GamePlayer getPrevPlayer(boolean withoutDropOut) {
        return this.getGameEngine().getPrevPlayer(this, withoutDropOut);
    }

    public GamePlayer getPrevPlayer() {
        return this.getGameEngine().getPrevPlayer(this);
    }

    public GamePlayer getNextPlayer(boolean withoutDropOut) {
        return this.getGameEngine().getNextPlayer(this, withoutDropOut);
    }

    public GamePlayer getNextPlayer() {
        return this.getGameEngine().getNextPlayer(this);
    }

    public int getScore(int scoreType) {
        return this.getGameManager().getGameStatistics().getScore(this, scoreType);
    }

    public void addScore(int score, int scoreTypes) {
        this.getGameManager().getGameStatistics().addScore(this, score, scoreTypes);
    }

    public void setScore(int score, int scoreTypes) {
        this.getGameManager().getGameStatistics().setScore(this, score, scoreTypes);
    }

    public int getGamesPlayed() {
        return this.getGameManager().getGameStatistics().getGamesPlayed(this);
    }

    public int getGamesWon() {
        return this.getGameManager().getGameStatistics().getGamesWon(this);
    }

    @Override
    public int compareTo(GamePlayer o2) {
        return new PlayerKey(this).compareTo(new PlayerKey(o2));
    }

    public boolean equals(Object o2) {
        if (o2 instanceof GamePlayer) {
            return new PlayerKey(this).equals(new PlayerKey((GamePlayer)o2));
        }
        return false;
    }

    public int hashCode() {
        return new PlayerKey(this).hashCode();
    }

    public GamePlayer clone() {
        try {
            return (GamePlayer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public PlayerType getType() {
        return PlayerFactory.getInstance().getPlayerType(this.playerType);
    }
}

