/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.completed.playingfield;

import hgb.lib.HGBaseTools;
import hgb.lib.internal.SimpleHGBaseItem;
import java.awt.Point;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import tjger.game.completed.playingfield.ShapeType;

public class SingleField
extends SimpleHGBaseItem
implements Comparable<SingleField> {
    private final ShapeType shape;
    private final Map<String, String> properties = new TreeMap<String, String>();
    private Point gridPosition;
    private Point[] pixelPositions;
    private Object data;

    private SingleField(String id, ShapeType shape) {
        super(id);
        this.shape = shape;
    }

    public SingleField(String id, ShapeType shape, Point gridPosition) {
        this(id, shape);
        if (shape == ShapeType.POLYGON) {
            throw new IllegalArgumentException("A single field in a grid must not be a polygon!");
        }
        this.gridPosition = Objects.requireNonNull(gridPosition, "The grid position must not be null!");
    }

    public SingleField(String id, ShapeType shape, Point[] pixelPositions) {
        this(id, shape);
        this.checkValidPixelPositionsForShape(shape, pixelPositions);
        this.pixelPositions = HGBaseTools.clone(pixelPositions);
    }

    private void checkValidPixelPositionsForShape(ShapeType shape, Point[] pixelPositions) {
        if (!shape.validPositions(pixelPositions)) {
            throw new IllegalArgumentException("The shape type does not fit to the given points!");
        }
    }

    public ShapeType getShape() {
        return this.shape;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    public String getProperty(String key) {
        return HGBaseTools.toString(this.properties.get(key));
    }

    public void setProperty(String key, String value) {
        if (HGBaseTools.hasContent(key)) {
            if (HGBaseTools.hasContent(value)) {
                this.properties.put(key, value);
            } else {
                this.properties.remove(key);
            }
        }
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void clearData() {
        this.setData(null);
    }

    public Object getData() {
        return this.data;
    }

    public Point getGridPosition() {
        return this.gridPosition;
    }

    public void setGridPosition(Point gridPosition) {
        this.gridPosition = Objects.requireNonNull(gridPosition, "The grid position must not be null!");
    }

    public Point[] getPixelPositions() {
        return HGBaseTools.clone(this.pixelPositions);
    }

    public void setPixelPositions(Point[] pixelPositions) {
        this.checkValidPixelPositionsForShape(this.shape, pixelPositions);
        this.pixelPositions = HGBaseTools.clone(pixelPositions);
        this.gridPosition = null;
    }

    @Override
    public int compareTo(SingleField field) {
        if (field == null) {
            return -1;
        }
        if (this.gridPosition != null) {
            return field.gridPosition == null ? -1 : this.comparePoints(this.gridPosition, field.gridPosition);
        }
        Point pos1 = HGBaseTools.getElementOrNull(this.pixelPositions, 0);
        Point pos2 = HGBaseTools.getElementOrNull(field.pixelPositions, 0);
        return this.comparePoints(pos1, pos2);
    }

    @Override
    public String toString() {
        return "[ID=" + this.getId() + ", Shape=" + (Object)((Object)this.shape) + ", Properties=" + this.properties + "]";
    }

    private int comparePoints(Point point1, Point point2) {
        if (point1 == null && point2 == null) {
            return 0;
        }
        if (point1 != null && point2 == null) {
            return -1;
        }
        if (point1 == null && point2 != null) {
            return 1;
        }
        int res = Integer.valueOf(point1.x).compareTo(point2.x);
        return res != 0 ? res : Integer.valueOf(point1.y).compareTo(point2.y);
    }
}

