/*
 * Decompiled with CFR 0.152.
 */
package tjger.game.internal;

import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseTools;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.game.completed.PlayerManager;
import tjger.game.completed.PlayerType;
import tjger.game.internal.GameStatistics;
import tjger.game.internal.PlayerFactory;
import tjger.game.internal.PlayerKey;
import tjger.lib.XmlUtil;

public class PlayerProfiles {
    private static final PlayerProfiles PROFILES_INSTANCE = new PlayerProfiles();
    private final Map<String, GamePlayer> profileMap = new HashMap<String, GamePlayer>();
    private boolean rememberProfiles;

    private PlayerProfiles() {
        this.loadProfiles();
    }

    public static PlayerProfiles getInstance() {
        return PROFILES_INSTANCE;
    }

    public void saveProfiles() {
        if (this.rememberProfiles) {
            String fileName = HGBaseSettings.get("fileProfile");
            Document newDoc = HGBaseXMLTools.createDocument();
            Element root = newDoc.createElement("profile");
            Element playersRoot = newDoc.createElement("players");
            GamePlayer[] players = this.getPlayers();
            int i = 0;
            while (i < players.length) {
                if (!players[i].getType().isNetwork()) {
                    Element pE = XmlUtil.savePlayer(newDoc, "player", players[i]);
                    playersRoot.appendChild(pE);
                }
                ++i;
            }
            root.appendChild(playersRoot);
            newDoc.appendChild(root);
            if (!HGBaseXMLTools.writeXML(newDoc, fileName)) {
                HGBaseLog.logWarn("Could not write profile file.");
            }
        }
    }

    private void loadProfiles() {
        String fileName = HGBaseSettings.get("fileProfile");
        this.rememberProfiles = HGBaseTools.hasContent(fileName);
        if (this.rememberProfiles) {
            Element root = HGBaseXMLTools.readXML(fileName);
            if (root != null) {
                ChildNodeIterator.run(new ChildNodeIterator(root, "profile", this){

                    @Override
                    public void performNode(Node node, int index, Object obj) {
                        if (node.getNodeName().equals("players")) {
                            ChildNodeIterator.run(new ChildNodeIterator(node, "players", obj){

                                @Override
                                public void performNode(Node node, int index, Object obj) {
                                    GamePlayer player = XmlUtil.loadPlayer(node);
                                    if (player != null) {
                                        PlayerProfiles.this.profileMap.put(new PlayerKey(player).toString(), player);
                                    }
                                }
                            });
                        }
                    }
                });
            } else {
                HGBaseLog.logWarn("Could not read profile file.");
            }
        }
    }

    public boolean existsPlayer(GamePlayer player) {
        return this.existsPlayer(new PlayerKey(player));
    }

    public boolean existsPlayer(PlayerKey key) {
        PlayerType pt = PlayerFactory.getInstance().getPlayerType(key.getPlayerType());
        if (pt != null && pt.isNetwork()) {
            return false;
        }
        return this.profileMap.containsKey(key.toString());
    }

    public void createProfile(GamePlayer player) {
        if (this.rememberProfiles) {
            this.removePlayerStatistics(player);
            this.putPlayerIntoMap(player);
        }
    }

    private void removePlayerStatistics(GamePlayer player) {
        GameStatistics statistics = GameStatistics.getInstance();
        statistics.removeGamesPlayedWon(player);
        statistics.removeGameScore(player);
    }

    private void putPlayerIntoMap(GamePlayer player) {
        GamePlayer newPlayer = PlayerFactory.getInstance().createPlayer(player.getType().getId(), player.getName(), player.getImage(), player.getPieceColor());
        this.profileMap.put(new PlayerKey(newPlayer).toString(), newPlayer);
    }

    public void updateProfile(GamePlayer player) {
        if (this.existsPlayer(player)) {
            this.putPlayerIntoMap(player);
        }
    }

    public void removeProfile(GamePlayer player) {
        this.removePlayerStatistics(player);
        this.profileMap.remove(new PlayerKey(player).toString());
    }

    public GamePlayer[] getPlayers() {
        GameEngine engine;
        GamePlayer[] players = null;
        players = this.rememberProfiles ? this.profileMap.values().toArray(new GamePlayer[0]) : ((engine = GameManager.getInstance().getGameEngine()).isActiveGame() ? engine.getActivePlayers() : PlayerManager.getInstance().getPlayers());
        HGBaseTools.orderList(players);
        return players;
    }

    public GamePlayer getPlayer(PlayerKey key) {
        return this.profileMap.get(key.toString());
    }

    public boolean isRememberProfiles() {
        return this.rememberProfiles;
    }
}

