/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed.playingfield;

import java.awt.Graphics;
import java.awt.Point;
import javax.swing.ImageIcon;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.gui.GamePanel;
import tjger.gui.completed.playingfield.PlayingFieldPaintUtil;
import tjger.gui.completed.playingfield.SingleFieldPainter;

public class SingleFieldImagePainter
implements SingleFieldPainter {
    protected ImageIcon image;
    protected int percentSize;

    public SingleFieldImagePainter(ImageIcon image, int percentSize) {
        this.image = image;
    }

    @Override
    public void drawSingleField(PlayingField playField, SingleField field, GamePanel panel, Graphics g) {
        if (this.image != null) {
            int zoom = this.percentSize > 0 ? this.percentSize : this.calculateZoomFactor(playField, field, this.image);
            PlayingFieldPaintUtil.drawSingleField(playField, field, zoom, this.image, panel, g);
        }
    }

    protected int calculateZoomFactor(PlayingField playField, SingleField field, ImageIcon image) {
        if (image == null) {
            return 0;
        }
        Point[] pixels = playField.getPixelPositions(field);
        int minX = -1;
        int minY = -1;
        int maxX = -1;
        int maxY = -1;
        Point[] pointArray = pixels;
        int n = pixels.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            minX = minX == -1 || minX > p.x ? p.x : minX;
            minY = minY == -1 || minY > p.y ? p.y : minY;
            maxX = maxX == -1 || maxX < p.x ? p.x : maxX;
            maxY = maxY == -1 || maxY < p.y ? p.y : maxY;
            ++n2;
        }
        double zoomX = ((double)(maxX - minX) + 1.0) / (double)image.getIconWidth();
        double zoomY = ((double)(maxY - minY) + 1.0) / (double)image.getIconHeight();
        return (int)(Math.min(zoomX, zoomY) * 100.0);
    }
}

