/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed.playingfield;

import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseTools;
import java.awt.Graphics;
import tjger.game.completed.GameManager;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.gui.GamePanel;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.playingfield.PlayingFieldPaintUtil;
import tjger.gui.completed.playingfield.SingleFieldImagePainter;

public class SingleFieldPartPainter
extends SingleFieldImagePainter {
    private String partSet;
    private String defaultPart;

    public SingleFieldPartPainter(String partSet, int percentSize) {
        this(partSet, null, percentSize);
    }

    public SingleFieldPartPainter(String partSet, String defaultPart, int percentSize) {
        super(null, percentSize);
        this.partSet = partSet;
        this.defaultPart = defaultPart;
    }

    @Override
    public void drawSingleField(PlayingField playField, SingleField field, GamePanel panel, Graphics g) {
        String partName;
        String property = field.getProperty(this.partSet);
        String string = partName = HGBaseTools.hasContent(property) ? property : this.defaultPart;
        if (HGBaseTools.hasContent(partName)) {
            PartSet parts = GameManager.getInstance().getGameConfig().getActivePartSet(this.partSet);
            Part part = HGBaseTools.getFirstOrNull(parts.getParts(partName));
            if (part != null) {
                int zoom = this.percentSize > 0 ? this.percentSize : this.calculateZoomFactor(playField, field, part.getImage());
                PlayingFieldPaintUtil.drawSingleField(playField, field, zoom, part, panel, g);
            } else {
                HGBaseLog.logWarn("The part '" + partName + "' was not found in part set '" + this.partSet + "'!");
            }
        } else {
            HGBaseLog.logWarn("No part information found for field " + field.getId());
        }
    }
}

