/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import hgb.gui.config.HGBaseConfigStateDialog;
import hgb.lib.HGBaseText;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import tjger.lib.ImageUtil;

public class ImageChooserDlg
extends HGBaseConfigStateDialog {
    private ImageIcon[] imageList;
    private int selectedIndex;
    private ImageIcon selectedImage;
    private JList<ImageIcon> list;

    public ImageChooserDlg(HGBaseFrame mainFrame, ImageIcon[] imageList) {
        super(mainFrame, HGBaseText.getText("dlg.chooseimage", new String[0]));
        this.imageList = imageList != null ? imageList : new ImageIcon[]{};
        this.selectedIndex = -1;
    }

    public ImageIcon getSelectedImage() {
        int index;
        if (this.selectedImage == null && this.list != null && (index = this.list.getSelectedIndex()) >= 0 && index < this.imageList.length) {
            return this.imageList[index];
        }
        return this.selectedImage;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    protected boolean canLeave() {
        return this.getSelectedImage() != null;
    }

    @Override
    protected void createComponents(HGBasePanel pnDialog) {
        int height = ImageUtil.getMaxImageHeight(this.imageList) + 20;
        int width = ImageUtil.getMaxImageWidth(this.imageList) + 20;
        this.list = new JList<ImageIcon>(this.imageList);
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        this.list.setFixedCellHeight(height);
        this.list.setFixedCellWidth(width);
        this.list.setCellRenderer(new ListCellRenderer<ImageIcon>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends ImageIcon> list, ImageIcon value, int index, boolean isSelected, boolean cellHasFocus) {
                ImageIcon img = value;
                JLabel lbImg = new JLabel(img);
                if (isSelected) {
                    lbImg.setBackground(HGBaseGuiTools.getSelectColor());
                    lbImg.setOpaque(true);
                }
                return lbImg;
            }
        });
        this.list.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setHorizontalScrollBarPolicy(32);
        listScroller.setPreferredSize(new Dimension(250, height + 18));
        pnDialog.add(listScroller);
    }

    @Override
    protected void okPressed() {
        super.okPressed();
        this.selectedImage = this.getSelectedImage();
        this.selectedIndex = this.list != null ? this.list.getSelectedIndex() : -1;
    }
}

