/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import java.util.Arrays;
import tjger.lib.ShortestPathMethods;

public abstract class AbstractShortestPathMethods<T>
implements ShortestPathMethods<T> {
    protected T startField;
    protected T targetField;
    protected int maxSearchDepth;

    public AbstractShortestPathMethods(T startField, T targetField) {
        this(startField, targetField, 0);
    }

    public AbstractShortestPathMethods(T startField, T targetField, int maxSearchDepth) {
        this.startField = startField;
        this.targetField = targetField;
        this.maxSearchDepth = maxSearchDepth;
    }

    @Override
    public T getStartField() {
        return this.startField;
    }

    @Override
    public T getTargetField() {
        return this.targetField;
    }

    @Override
    public int getWeight(T from, T to) {
        return 1;
    }

    @Override
    public int getMaxWeightToSearch() {
        return this.maxSearchDepth;
    }

    protected int getIndexOfField(T[] fieldList, T field, boolean sortedList) {
        if (sortedList) {
            int index = Arrays.binarySearch(fieldList, field);
            if (index >= 0 && field.equals(fieldList[index])) {
                return index;
            }
            return -1;
        }
        return Arrays.asList(fieldList).indexOf(field);
    }
}

