/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import tjger.game.GamePlayer;
import tjger.gui.completed.Card;
import tjger.lib.ArrayUtil;
import tjger.lib.PlayerCardMap;

public class CardUtil {
    private static Random cardRandom = new Random(new Date().getTime());

    private CardUtil() {
    }

    public static Card[] mixCards(Card[] cards) {
        List<Card> list = Arrays.asList(cards);
        Collections.shuffle(list, cardRandom);
        return list.toArray(new Card[cards.length]);
    }

    public static void mixCards(List<Card> cards) {
        Collections.shuffle(cards, cardRandom);
    }

    public static Card[] addCard(Card[] cards, Card addCard) {
        Card[] newCards = new Card[cards.length + 1];
        System.arraycopy(cards, 0, newCards, 0, cards.length);
        newCards[cards.length] = addCard;
        return newCards;
    }

    public static Card[] addCards(Card[] cards, Card[] addCards) {
        return (Card[])HGBaseTools.sumArrays(cards, addCards);
    }

    public static Card[] removeCard(Card[] cards, Card removeCard) {
        ArrayList<Card> listCard = new ArrayList<Card>(Arrays.asList(cards));
        listCard.remove(removeCard);
        return ArrayUtil.toCard(listCard);
    }

    public static Card[] removeCards(Card[] cards, Card[] removeCards) {
        ArrayList<Card> listCard = new ArrayList<Card>(Arrays.asList(cards));
        int i = 0;
        while (i < removeCards.length) {
            listCard.remove(removeCards[i]);
            ++i;
        }
        return ArrayUtil.toCard(listCard);
    }

    public static Card[] dealCards(Card[] cards, int numCards, GamePlayer[] players, PlayerCardMap cardMap) {
        Card[] remainCards = (Card[])cards.clone();
        int cardCounter = 0;
        int p = 0;
        while (p < players.length) {
            if (players[p] != null) {
                int c = 0;
                while (c < numCards) {
                    if (cardCounter < cards.length) {
                        cardMap.addCard(players[p], cards[cardCounter]);
                        remainCards = CardUtil.removeCard(remainCards, cards[cardCounter]);
                        ++cardCounter;
                    }
                    ++c;
                }
            }
            ++p;
        }
        return remainCards;
    }

    public static void dealCards(List<Card> cards, int numCards, GamePlayer[] players, PlayerCardMap cardMap) {
        if (numCards <= 0) {
            return;
        }
        int p = 0;
        while (p < players.length) {
            if (players[p] != null) {
                int cardSize = cards.size();
                if (cardSize == 0) {
                    return;
                }
                if (numCards > cardSize) {
                    numCards = cardSize;
                }
                List<Card> dealList = cards.subList(0, numCards);
                cardMap.addCards(players[p], ArrayUtil.toCard(dealList));
                dealList.clear();
            }
            ++p;
        }
    }

    public static Card[] dealCards(Card[] cards, Card[] target) {
        int c = 0;
        while (c < target.length) {
            target[c] = c < cards.length ? cards[c] : null;
            ++c;
        }
        return CardUtil.removeCards(cards, target);
    }

    public static List<Card> dealCards(List<Card> cards, int num) {
        int listSize = cards.size();
        if (listSize == 0 || num <= 0) {
            return new ArrayList<Card>();
        }
        if (num > listSize) {
            num = listSize;
        }
        List<Card> tmpList = cards.subList(0, num);
        ArrayList<Card> dealList = new ArrayList<Card>(tmpList);
        tmpList.clear();
        return dealList;
    }

    public static Card[] reverseCards(Card[] cards) {
        List<Card> reverseList = CardUtil.reverseCards(Arrays.asList(cards));
        return ArrayUtil.toCard(reverseList);
    }

    public static List<Card> reverseCards(List<Card> cards) {
        ArrayList<Card> newList = new ArrayList<Card>(cards);
        Collections.reverse(newList);
        return newList;
    }

    public static Card[] doubleCards(Card[] cards) {
        Object[] sum = new Card[cards.length * 2];
        HGBaseTools.sumArrays(sum, cards, cards);
        return sum;
    }

    public static List<Card> doubleCards(List<Card> cards) {
        ArrayList<Card> list = new ArrayList<Card>(cards);
        list.addAll(cards);
        return list;
    }

    public static int getCardsValue(Card[] cards) {
        int values = 0;
        if (cards != null) {
            int i = 0;
            while (i < cards.length) {
                values += cards[i].getValue();
                ++i;
            }
        }
        return values;
    }

    public static int getCardsValue(List<Card> cards) {
        return CardUtil.getCardsValue(ArrayUtil.toCard(cards));
    }
}

