/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;
import tjger.gui.completed.Card;
import tjger.lib.AbstractPlayerMap;
import tjger.lib.ArrayUtil;
import tjger.lib.NetworkUtil;
import tjger.lib.XmlUtil;

public class PlayerCardMap
extends AbstractPlayerMap
implements Cloneable {
    private Map<GamePlayer, List<Card>> mapCards = new LinkedHashMap<GamePlayer, List<Card>>();

    public PlayerCardMap() {
        this.resetPlayers();
    }

    public void newPlayer(GamePlayer player) {
        this.mapCards.put(player, new ArrayList());
    }

    @Override
    public void resetPlayers() {
        this.mapCards = new LinkedHashMap<GamePlayer, List<Card>>();
    }

    public void resetCards() {
        GamePlayer[] p = this.getPlayers();
        int i = 0;
        while (i < p.length) {
            this.resetCards(p[i]);
            ++i;
        }
    }

    public void resetCards(GamePlayer player) {
        if (this.mapCards.containsKey(player)) {
            this.mapCards.put(player, new ArrayList());
        }
    }

    public void addCards(GamePlayer player, Card[] cards) {
        if (cards.length == 0 && !this.mapCards.containsKey(player)) {
            this.newPlayer(player);
        } else {
            int i = 0;
            while (i < cards.length) {
                this.addCard(player, cards[i]);
                ++i;
            }
        }
    }

    public void addCards(GamePlayer player, List<Card> cards) {
        if (!this.mapCards.containsKey(player)) {
            this.newPlayer(player);
        }
        if (!cards.isEmpty()) {
            List<Card> cardList = this.mapCards.get(player);
            cardList.addAll(cards);
        }
    }

    public void addCard(GamePlayer player, Card card) {
        if (!this.mapCards.containsKey(player)) {
            this.newPlayer(player);
        }
        List<Card> cardList = this.mapCards.get(player);
        cardList.add(card);
    }

    public void removeCards(GamePlayer player, Card[] cards) {
        int i = 0;
        while (i < cards.length) {
            this.removeCard(player, cards[i]);
            ++i;
        }
    }

    public void removeCards(GamePlayer player, List<Card> cards) {
        List<Card> cardList;
        if (this.mapCards.containsKey(player) && (cardList = this.mapCards.get(player)) != null) {
            cardList.removeAll(cards);
        }
    }

    public boolean removeCard(GamePlayer player, Card card) {
        List<Card> cardList;
        if (this.mapCards.containsKey(player) && (cardList = this.mapCards.get(player)) != null) {
            return cardList.remove(card);
        }
        return false;
    }

    public boolean replaceCard(GamePlayer player, Card oldCard, Card newCard) {
        int index;
        List<Card> cardList;
        if (this.mapCards.containsKey(player) && (cardList = this.mapCards.get(player)) != null && (index = cardList.indexOf(oldCard)) != -1) {
            cardList.set(index, newCard);
            return true;
        }
        return false;
    }

    public Card[] getCards(GamePlayer player) {
        return this.getCards(player, true);
    }

    public Card[] getCards(GamePlayer player, boolean ordered) {
        List<Card> cardList = this.mapCards.get(player);
        if (cardList == null) {
            return new Card[0];
        }
        Card[] cards = cardList.toArray(new Card[cardList.size()]);
        if (ordered) {
            HGBaseTools.orderList(cards);
        }
        return cards;
    }

    public Card[] getAllCards(boolean ordered) {
        List<Card> cardList = this.getAllCardList(ordered);
        return ArrayUtil.toCard(cardList);
    }

    public List<Card> getCardList(GamePlayer player) {
        return this.getCardList(player, true);
    }

    public List<Card> getCardList(GamePlayer player, boolean ordered) {
        List<Card> cardList = this.mapCards.get(player);
        if (ordered && cardList != null) {
            Collections.sort(cardList);
        }
        return cardList;
    }

    public List<Card> getAllCardList(boolean ordered) {
        ArrayList<Card> cardList = new ArrayList<Card>();
        GamePlayer[] p = this.getPlayers();
        int i = 0;
        while (i < p.length) {
            cardList.addAll(this.getCardList(p[i], false));
            ++i;
        }
        if (ordered) {
            Collections.sort(cardList);
        }
        return cardList;
    }

    public Card getCard(GamePlayer player, int index) {
        Card[] cards = this.getCards(player);
        if (index >= 0 && index < cards.length) {
            return cards[index];
        }
        return null;
    }

    @Override
    public GamePlayer[] getPlayers() {
        return this.mapCards.keySet().toArray(new GamePlayer[0]);
    }

    @Override
    public void saveMap(Document doc, Element root) {
        GamePlayer[] player = this.getPlayers();
        int i = 0;
        while (i < player.length) {
            int index = GameManager.getInstance().getGameEngine().getIndexOfPlayer(player[i]);
            Card[] cards = this.getCards(player[i]);
            Element eP = XmlUtil.saveCardArray(doc, "player" + index, cards);
            root.appendChild(eP);
            ++i;
        }
    }

    @Override
    protected void loadNode(GameEngine engine, Node node) {
        GamePlayer p;
        int player = HGBaseTools.toInt(node.getNodeName().replaceFirst("player", ""));
        if (player >= 0 && (p = engine.getPlayerWithIndex(player)) != null) {
            Card[] cards = XmlUtil.loadCardArray(node);
            this.addCards(p, cards);
        }
    }

    @Override
    protected void appendPlayerData(StringBuilder data, GamePlayer player) {
        data.append(NetworkUtil.fromCardArray(this.getCards(player)));
    }

    @Override
    protected boolean readPlayerData(GamePlayer player, String string) {
        Card[] cards = NetworkUtil.toCardArray(string);
        this.addCards(player, cards);
        return true;
    }

    public Object clone() {
        PlayerCardMap newMap = new PlayerCardMap();
        GamePlayer[] players = this.getPlayers();
        int i = 0;
        while (i < players.length) {
            newMap.addCards(players[i], this.getCards(players[i], false));
            ++i;
        }
        return newMap;
    }

    public String toString() {
        return this.mapCards == null ? "null" : this.mapCards.entrySet().toString();
    }
}

