/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseTools;
import java.util.HashSet;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.lib.PlayerUtil;

public class ScoreUtil {
    private ScoreUtil() {
    }

    public static int[] getScore(GamePlayer[] players, int scoreType) {
        return ScoreUtil.getScore(players, scoreType, false);
    }

    public static int[] getScore(GamePlayer[] players, int scoreType, boolean withoutDropOut) {
        GamePlayer[] playersToTest = players;
        if (playersToTest != null && withoutDropOut) {
            playersToTest = PlayerUtil.getAdvancedPlayers(playersToTest);
        }
        int[] score = new int[playersToTest == null ? 0 : playersToTest.length];
        int i = 0;
        while (i < score.length) {
            score[i] = playersToTest[i].getScore(scoreType);
            ++i;
        }
        return score;
    }

    public static int getMaximumScore(int[] scores) {
        return HGBaseTools.getMaximum(scores);
    }

    public static int getMinimumScore(int[] scores) {
        return HGBaseTools.getMinimum(scores);
    }

    public static int[] getScoreRanking(GamePlayer[] players, int scoreType) {
        return ScoreUtil.getScoreRanking(players, scoreType, GameConfig.getInstance().isLowerScoreBetter());
    }

    public static int[] getScoreRanking(GamePlayer[] players, int scoreType, boolean lessIsBetter) {
        return ScoreUtil.getScoreRanking(ScoreUtil.getScore(players, scoreType), lessIsBetter);
    }

    public static int[] getScoreRanking(int[] scores) {
        return ScoreUtil.getScoreRanking(scores, GameConfig.getInstance().isLowerScoreBetter());
    }

    public static int[] getScoreRanking(int[] scores, boolean lessIsBetter) {
        HashSet<Integer> listScores = new HashSet<Integer>();
        int i = 0;
        while (i < scores.length) {
            listScores.add(scores[i]);
            ++i;
        }
        Integer[] diffScores = listScores.toArray(new Integer[listScores.size()]);
        HGBaseTools.orderList(diffScores, lessIsBetter);
        int[] rank = new int[scores.length];
        int i2 = 0;
        while (i2 < rank.length) {
            boolean found = false;
            int j = 0;
            while (j < diffScores.length && !found) {
                if (diffScores[j] == scores[i2]) {
                    found = true;
                    rank[i2] = diffScores.length - j;
                }
                ++j;
            }
            ++i2;
        }
        return rank;
    }

    public static GamePlayer[] getPlayersInRankingOrder(GamePlayer[] player, int[] ranks) {
        GamePlayer[] rankedPlayer = (GamePlayer[])player.clone();
        if (ranks != null) {
            int[] ranks2 = (int[])ranks.clone();
            int i = 0;
            while (i < rankedPlayer.length - 1) {
                int minIndex = i;
                int minRank = ranks2[i];
                int j = i;
                while (j < rankedPlayer.length) {
                    if (ranks2[j] > 0 && (ranks2[j] < minRank || minRank <= 0)) {
                        minIndex = j;
                        minRank = ranks2[j];
                    }
                    ++j;
                }
                if (minIndex != i) {
                    GamePlayer h = rankedPlayer[i];
                    rankedPlayer[i] = rankedPlayer[minIndex];
                    rankedPlayer[minIndex] = h;
                    int h2 = ranks2[i];
                    ranks2[i] = ranks2[minIndex];
                    ranks2[minIndex] = h2;
                }
                ++i;
            }
        }
        return rankedPlayer;
    }

    public static int numberOfRanks(int[] ranking, int rank) {
        int num = 0;
        int i = 0;
        while (i < ranking.length) {
            if (ranking[i] == rank) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public static int getPlayerRank(int scoreType, GamePlayer[] players, GamePlayer player) {
        int[] ranks = ScoreUtil.getScoreRanking(players, scoreType);
        GamePlayer[] playersInRankingOrder = ScoreUtil.getPlayersInRankingOrder(players, ranks);
        int rankIndex = 0;
        while (rankIndex < playersInRankingOrder.length) {
            if (player.equals(playersInRankingOrder[rankIndex])) {
                return rankIndex + 1;
            }
            ++rankIndex;
        }
        return 0;
    }
}

