/*
 * Decompiled with CFR 0.152.
 */
package tjger.net;

import hgb.gui.HGBaseDialog;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import tjger.game.NetworkPlayer;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.net.NetworkClient;
import tjger.net.NetworkConnection;
import tjger.net.NetworkMessage;

public class NetworkClientConnection
extends NetworkConnection {
    private static NetworkClientConnection connection = new NetworkClientConnection();
    private final NetworkClient client = new NetworkClient();

    private NetworkClientConnection() {
    }

    public static NetworkClientConnection getInstance() {
        return connection;
    }

    public void startClient(final String serverIp, String name) {
        super.start();
        this.client.setServerIP(serverIp);
        this.client.setClientName(name);
        this.client.setState(2);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Socket sock = new Socket(serverIp, GameConfig.getInstance().getNetworkPort());
                    NetworkClientConnection.this.client.setSocket(sock);
                    NetworkClientConnection.this.client.setOutStream(new PrintStream(sock.getOutputStream(), false, Charset.defaultCharset().displayName()));
                    NetworkClientConnection.this.client.setInStream(new BufferedReader(new InputStreamReader(sock.getInputStream(), Charset.defaultCharset())));
                    NetworkClientConnection.this.client.setClientIP(sock.getLocalAddress().getHostAddress());
                    ArrayList<Integer> alOut = new ArrayList<Integer>();
                    boolean succ = NetworkClientConnection.this.putMessage(NetworkMessage.msgShakehandC(NetworkClientConnection.this.client.getClientName(), NetworkClientConnection.this.getIp())) == 0;
                    while (succ && !NetworkClientConnection.this.messageServerAccepted(alOut)) {
                        succ = !NetworkClientConnection.this.messageServerAbort();
                        NetworkClientConnection.netWait();
                    }
                    if (succ) {
                        if (!alOut.isEmpty()) {
                            NetworkClientConnection.this.client.setClientId((Integer)alOut.get(0));
                            NetworkClientConnection.this.client.setState(1);
                            NetworkClientConnection.this.putMessage(NetworkMessage.msgAcknowledgeC());
                        } else {
                            NetworkClientConnection.this.client.setState(0);
                        }
                    } else {
                        NetworkClientConnection.this.client.setState(0);
                    }
                }
                catch (IOException e) {
                    int oldState = NetworkClientConnection.this.client.getState();
                    NetworkClientConnection.this.client.setState(0);
                    if (oldState == 2) {
                        HGBaseDialog.printError(-30216, (JFrame)NetworkClientConnection.this.getMainFrame());
                    }
                    NetworkClientConnection.this.close();
                }
            }
        };
        t.start();
    }

    @Override
    public void close() {
        super.close();
        int state = this.getState();
        if (state == 1 || state == 2) {
            this.putMessage(NetworkMessage.msgAbort());
        }
        this.closeSockets();
        this.client.resetClient();
    }

    private void closeSockets() {
        HGBaseFileTools.closeStream(this.client.getSocket());
        HGBaseFileTools.closeStream(this.client.getOutStream());
        HGBaseFileTools.closeStream(this.client.getInStream());
    }

    @Override
    public int getId() {
        return this.client.getClientId();
    }

    @Override
    public String getIp() {
        String ip = this.client.getClientIP();
        if (HGBaseTools.hasContent(ip)) {
            return ip;
        }
        return super.getIp();
    }

    public String getName() {
        return this.client.getClientName();
    }

    public int getState() {
        return this.client.getState();
    }

    public int getClientNr() {
        return this.client.getClientNr();
    }

    public void setClientNr(int nr) {
        this.client.setClientNr(nr);
    }

    public boolean isConnected() {
        return this.getState() == 1;
    }

    public int putMessage(String msg) {
        if (this.client.getOutStream() != null) {
            return this.putMessage(this.client.getOutStream(), msg);
        }
        return -30221;
    }

    @Override
    protected String getMessage() {
        StringBuffer msg = new StringBuffer("");
        if (this.getMessage(this.client.getInStream(), msg) != 0) {
            this.close();
            return null;
        }
        return msg.toString();
    }

    @Override
    protected boolean handleMessage(String msg) {
        String type = this.getMessagePart(0, msg);
        String param = this.getMessagePart(1, msg);
        if (type != null) {
            if (type.equals("TJxERR") && param != null && param.equals("err.nextgame")) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        NetworkClientConnection.netWait();
                        NetworkClientConnection.netWait();
                        NetworkClientConnection.this.getNextMessage("TJxGE", "NEXTGM");
                        NetworkClientConnection.this.getNextMessage("TJxERR", "err.nextgame");
                        GameEngine.getInstance().nextNetworkGame();
                    }
                };
                t.start();
                return true;
            }
            if (type.equals("TJxERR")) {
                this.close();
                return true;
            }
        }
        return false;
    }

    public boolean messageServerAbort() {
        String msg = this.getNextMessage("TJxERR", null);
        if (msg != null) {
            String err = this.getMessagePart(1, msg);
            if (!err.equals("err.netabort") && !err.equals("err.nextgame")) {
                String param = this.getMessagePart(2, msg);
                HGBaseDialog.printError(err, new String[]{param}, this.getMainFrame());
            }
            return true;
        }
        return false;
    }

    public boolean messageServerAccepted(List<Integer> al) {
        al.clear();
        String msg = this.getNextMessage("TJxCTRL", "SRACC");
        if (msg != null) {
            al.add(HGBaseTools.toInt(this.getMessagePart(2, msg)));
            return true;
        }
        return false;
    }

    public boolean messageServerPlayerNames(List<String> listPlayer, List<String> listColor) {
        listPlayer.clear();
        String msg = this.getNextMessage("TJxGE", "PLNAM");
        if (msg != null) {
            String[] data = this.getMessagePart(2, msg).split("/");
            int i = 0;
            while (i < data.length) {
                String[] nameColor = data[i].split("=");
                listPlayer.add(nameColor[0]);
                if (nameColor.length > 1) {
                    listColor.add(nameColor[1]);
                } else {
                    listColor.add("");
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean messageServerNewGameInfo(int[] clientNr, int[] cyclicStartPlayer, Map<String, String> mapInfo) {
        if (clientNr.length > 0) {
            mapInfo.clear();
            String msg = this.getNextMessage("TJxGE", "NEWGM");
            if (msg != null) {
                clientNr[0] = HGBaseTools.toInt(this.getMessagePart(2, msg));
                if (clientNr[0] < 0 || cyclicStartPlayer[0] < 0) {
                    return false;
                }
                cyclicStartPlayer[0] = HGBaseTools.toInt(this.getMessagePart(3, msg));
                if (clientNr[0] < 0 || cyclicStartPlayer[0] < 0) {
                    return false;
                }
                String[] info = this.getMessagePart(4, msg).split("/");
                int i = 0;
                while (i < info.length) {
                    String[] value = info[i].split("=");
                    if (value.length == 2) {
                        mapInfo.put(value[0], value[1]);
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public boolean messageServerNextGame() {
        String msg = this.getNextMessage("TJxGE", "NEXTGM");
        return msg != null;
    }

    public String messageServerGameState() {
        return this.messageGameInformation("TJxGS");
    }

    public boolean waitForServerGameInformation(String msgType, StringBuffer msgReceived, NetworkPlayer player) {
        String msg = null;
        while ((player == null || player.isPlaying()) && !this.messageServerAbort() && msg == null) {
            msg = this.messageGameInformation(msgType);
            NetworkConnection.netWait();
        }
        if (msg != null) {
            msgReceived.append(msg);
            return this.putMessage(NetworkMessage.msgClientGameOkC(msgType)) == 0;
        }
        return false;
    }
}

